/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import java.util.Collection;
import java.util.Stack;

public class In
extends ChemFunction {
    public In() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        int i;
        int index = -1;
        MolAtom atom = null;
        int[] array = null;
        Collection coll = null;
        Number number = null;
        for (i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p instanceof int[]) {
                array = (int[])p;
                continue;
            }
            if (p instanceof Collection) {
                coll = (Collection)p;
                continue;
            }
            if (p instanceof Number) {
                try {
                    index = In.getInt(p);
                }
                catch (ParseException e) {
                    number = (Number)p;
                }
                continue;
            }
            if (p instanceof MolAtom) {
                atom = (MolAtom)p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (array == null && coll == null) {
            throw new ParseException("Array parameter is missing.");
        }
        if (atom != null) {
            index = atom.getParent().indexOf(atom);
        }
        if (index == -1) {
            Object p = this.callback("atom", null);
            if (p != null) {
                index = In.getInt(p);
            }
            if (index == -1) {
                throw new ParseException("Atom index parameter is missing.");
            }
        }
        if (coll != null) {
            if (number == null) {
                number = new Double(index);
            }
            s.push(coll.contains(number) ? TRUE : FALSE);
            return;
        }
        for (i = 0; i < array.length; ++i) {
            if (index != array[i]) continue;
            s.push(TRUE);
            return;
        }
        s.push(FALSE);
    }
}

