/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jep.MatchFunction;
import chemaxon.jep.Standardizer;
import chemaxon.jep.function.MoleculeData;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.ConfigTools;
import chemaxon.util.SearchAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Match
extends MatchFunction {
    private MolSearch searcher = null;
    private String qstr = null;
    private Molecule query = null;
    private int[] qindices = null;
    private int[] qfingerprint = null;
    private chemaxon.reaction.Standardizer standardizer = null;

    public Match() {
        super(null, 0, null);
    }

    public Match(int type, SearchAttributes attributes) {
        super(null, type, attributes);
    }

    @Override
    public void setStandardizer(Standardizer standardizer) {
        this.standardizer = (chemaxon.reaction.Standardizer)standardizer;
    }

    @Override
    public void run(Stack s) throws ParseException {
        int count;
        Data data;
        block59: {
            int[] tfingerprint;
            MoleculeGraph target = null;
            int index = -1;
            MolAtom atom = null;
            ArrayList list = new ArrayList(this.curNumberOfParameters);
            int t = 0;
            for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
                Object p = s.pop();
                if (p instanceof Molecule || p instanceof String) {
                    ++t;
                }
                if (p == null) continue;
                list.add(p);
            }
            boolean qset = false;
            for (int i = list.size() - 1; i >= 0; --i) {
                Object p = list.get(i);
                if (p instanceof Number) {
                    if (qset || index != -1) continue;
                    index = Match.getInt(p);
                    list.remove(i);
                    continue;
                }
                if (p instanceof Molecule) {
                    if (t == 2 && target == null) {
                        target = (Molecule)p;
                        list.remove(i);
                        continue;
                    }
                    qset = true;
                    continue;
                }
                if (p instanceof MolAtom) {
                    atom = (MolAtom)p;
                    list.remove(i);
                    continue;
                }
                if (!(p instanceof String)) continue;
                qset = true;
            }
            if (this.qstr == null) {
                this.query = null;
                if (!list.isEmpty()) {
                    this.setQueryData(list);
                }
            }
            if (atom == null) {
                Object p;
                if (target == null) {
                    target = (Molecule)this.callback("mol", null);
                }
                if (index == -1 && (p = this.callback("atom", null)) != null) {
                    index = Match.getInt(p);
                }
            } else {
                if (target == null) {
                    target = (Molecule)atom.getParent();
                }
                index = target.indexOf(atom);
            }
            if (this.query == null) {
                this.query = (Molecule)this.callback("query", null);
            }
            data = null;
            if (this.isCached() && target != null) {
                String mid = this.getMID(index);
                data = (Data)((Molecule)target).getPropertyObject(mid);
                long grinvCC = target.getGrinvCC();
                if (data == null || data.getGrinvCC() != grinvCC) {
                    data = new Data(grinvCC);
                    ((Molecule)target).setPropertyObject(mid, data);
                } else {
                    switch (this.type) {
                        case 0: 
                        case 3: {
                            s.push(data.isMatched() ? TRUE : FALSE);
                            break;
                        }
                        case 1: {
                            s.push(new Double(data.getCount()));
                        }
                    }
                    return;
                }
            }
            if ((tfingerprint = (int[])this.callback("fingerprint", target)) != null) {
                if (this.qstr != null) {
                    if (this.qfingerprint == null && this.fingerprintGenerator != null) {
                        this.qfingerprint = this.fingerprintGenerator.getFingerprint(this.query);
                    }
                } else {
                    this.qfingerprint = (int[])this.callback("qfingerprint", this.query);
                }
                if (this.qfingerprint != null) {
                    if (!FingerprintHandler.targetContainsQuery(this.qfingerprint, tfingerprint)) {
                        s.push(this.type == 0 ? FALSE : new Double(0.0));
                        return;
                    }
                    if (this.query == null || target == null) {
                        s.push(UNDECIDED);
                        return;
                    }
                }
            }
            if (this.searcher == null) {
                if (this.query == null) {
                    throw new ParseException("No query specified for match function.");
                }
                this.searcher = new MolSearch();
                this.searcher.setLicenseEnvironment(this.licenseEnvironment);
                this.searcher.setStandardizer(this.standardizer, true, true);
                this.setSearchAttributes();
                this.searcher.setQuery(this.query);
            } else if (this.qstr == null) {
                if (this.query == null) {
                    throw new ParseException("No query specified for match function.");
                }
                this.searcher.setQuery(this.query);
            }
            if (target == null) {
                throw new ParseException("No target specified for match function.");
            }
            this.searcher.setTarget((Molecule)target);
            count = 0;
            try {
                if (index != -1) {
                    for (int i = 0; i < this.qindices.length; ++i) {
                        this.searcher.clearMatch();
                        this.searcher.addMatch(this.qindices[i], index);
                        switch (this.type) {
                            case 0: 
                            case 3: {
                                if (!this.searcher.isMatching()) break;
                                if (data != null) {
                                    data.setMatched(true);
                                }
                                s.push(TRUE);
                                return;
                            }
                            case 1: {
                                count += this.searcher.getMatchCount();
                                break;
                            }
                            case 2: {
                                if (!this.searcher.isMatching()) break;
                                count = 1;
                            }
                        }
                        if (this.type != 2 || count <= 0) {
                            continue;
                        }
                        break block59;
                    }
                    break block59;
                }
                switch (this.type) {
                    case 0: 
                    case 3: {
                        if (!this.searcher.isMatching()) break;
                        if (data != null) {
                            data.setMatched(true);
                        }
                        s.push(TRUE);
                        return;
                    }
                    case 1: {
                        count += this.searcher.getMatchCount();
                        break;
                    }
                    case 2: {
                        Molecule q = null;
                        while (this.searcher.isMatching()) {
                            ++count;
                            if (q == null) {
                                q = this.query.cloneMolecule();
                            }
                            q.fuse(this.query.cloneMolecule());
                            this.searcher.setQuery(q);
                        }
                        this.searcher.setQuery(this.query);
                    }
                }
            }
            catch (SearchException e) {
                throw new ParseException(e);
            }
        }
        switch (this.type) {
            case 0: 
            case 3: {
                s.push(FALSE);
                break;
            }
            case 1: 
            case 2: {
                if (data != null) {
                    data.setCount(count);
                }
                s.push(new Double(count));
            }
        }
    }

    private void setQueryData(List list) throws ParseException {
        int size = list.size();
        if (size == 0) {
            return;
        }
        try {
            for (int i = size - 1; i >= 0; --i) {
                Object q = list.get(i);
                if (q instanceof Molecule) {
                    this.query = (Molecule)q;
                    list.remove(i);
                    break;
                }
                if (!(q instanceof String)) continue;
                this.qstr = (String)q;
                this.query = ConfigTools.getQueryMolecule((String)q, null, this.dir);
                list.remove(i);
                break;
            }
            if (this.query == null) {
                return;
            }
            int[] qmaps = null;
            this.qindices = null;
            if (--size > 0) {
                qmaps = new int[size];
                for (int j = 0; j < size; ++j) {
                    qmaps[j] = Match.getInt(list.get(j));
                }
                IntVector qatoms = new IntVector(size);
                for (int j = this.query.getAtomCount() - 1; j >= 0; --j) {
                    if (!Match.isQueryAtom(this.query.getAtom(j), qmaps)) continue;
                    qatoms.addElement(j);
                }
                if (!qatoms.isEmpty()) {
                    this.qindices = qatoms.toArray();
                }
            }
            if (this.qindices == null) {
                this.qindices = new int[this.query.getAtomCount()];
                for (int i = 0; i < this.qindices.length; ++i) {
                    this.qindices[i] = i;
                }
            }
            this.qindices = Match.removeRepetitions(this.qindices, this.query);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private void setSearchAttributes() {
        if (this.attributes != null) {
            MolSearchOptions mso = this.searcher.getSearchOptions();
            mso.setStereoSearchType(this.attributes.isStereoSearch() ? 0 : 1);
            mso.setDoubleBondStereoMatchingMode(this.attributes.getDoubleBondStereoMatchingMode());
            mso.setSubgraphSearch(this.attributes.isSubgraphSearch());
            boolean exact = this.attributes.isExactAtomMatching();
            if (exact) {
                mso.setRadicalMatching(1);
                mso.setChargeMatching(1);
                mso.setIsotopeMatching(1);
            } else {
                mso.setRadicalMatching(0);
                mso.setChargeMatching(0);
                mso.setIsotopeMatching(0);
            }
            mso.setExactQueryAtomMatching(exact);
            mso.setStereoSearchType(this.attributes.isExactStereoMatching() ? 2 : (mso.getStereoSearchType() == 2 ? 0 : mso.getStereoSearchType()));
            this.searcher.setSearchOptions(mso);
        }
    }

    private static int[] removeRepetitions(int[] qindices, Molecule query) {
        if (qindices.length <= 1) {
            return qindices;
        }
        int[] grinv = new int[query.getAtomCount()];
        query.getGrinv(grinv);
        IntVector v = new IntVector(qindices.length);
        v.addElement(qindices[0]);
        for (int i = 1; i < qindices.length; ++i) {
            if (Match.isRepeatedGrinv(i, qindices, grinv)) continue;
            v.addElement(qindices[i]);
        }
        return v.toArray();
    }

    private static boolean isRepeatedGrinv(int t, int[] qindices, int[] grinv) {
        int gi = grinv[qindices[t]];
        for (int i = t - 1; i >= 0; --i) {
            if (grinv[qindices[i]] != gi) continue;
            return true;
        }
        return false;
    }

    private static boolean isQueryAtom(MolAtom atom, int[] qmaps) {
        if (qmaps == null) {
            return true;
        }
        int map = atom.getAtomMap();
        for (int i = 0; i < qmaps.length; ++i) {
            if (map != qmaps[i]) continue;
            return true;
        }
        return false;
    }

    private String getMID(int index) {
        return "JEP_MATCH(" + this.searcher + "," + index + ")";
    }

    static class Data
    extends MoleculeData {
        private int result = 0;

        public Data(long grinvCC) {
            super(grinvCC);
        }

        public void setMatched(boolean matched) {
            this.result = 1;
        }

        public boolean isMatched() {
            return this.result > 0;
        }

        public void setCount(int count) {
            this.result = count;
        }

        public int getCount() {
            return this.result;
        }
    }
}

