/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;

public class MinMax
extends PostfixMathCommand {
    private double sign = 0.0;

    public MinMax(double sign) {
        this.sign = sign;
        this.numberOfParameters = -1;
        this.curNumberOfParameters = -1;
    }

    @Override
    public void run(Stack s) throws ParseException {
        double res = Double.NaN;
        for (int k = 0; k < this.curNumberOfParameters; ++k) {
            res = this.max(s.pop(), res);
        }
        s.push(new Double(res *= this.sign));
    }

    private double max(Object p, double res) {
        block12: {
            block11: {
                if (!(p instanceof Number)) break block11;
                double x = ((Number)p).doubleValue() * this.sign;
                if (Double.isNaN(x) || res > x) break block12;
                res = x;
                break block12;
            }
            if (p instanceof double[]) {
                double[] a = (double[])p;
                for (int i = 0; i < a.length; ++i) {
                    double x = a[i] * this.sign;
                    if (Double.isNaN(x) || res > x) continue;
                    res = x;
                }
            } else if (p instanceof int[]) {
                int[] a = (int[])p;
                for (int i = 0; i < a.length; ++i) {
                    double x = (double)a[i] * this.sign;
                    if (Double.isNaN(x) || res > x) continue;
                    res = x;
                }
            } else if (p instanceof long[]) {
                long[] a = (long[])p;
                for (int i = 0; i < a.length; ++i) {
                    double x = (double)a[i] * this.sign;
                    if (Double.isNaN(x) || res > x) continue;
                    res = x;
                }
            } else if (p instanceof Collection) {
                Collection coll = (Collection)p;
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    res = this.max(it.next(), res);
                }
            }
        }
        return res;
    }
}

