/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.jep.ChemFunction;
import chemaxon.marvin.io.MolExportException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Stack;

public class MolString
extends ChemFunction {
    public MolString() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = null;
        Molecule[] mols = null;
        String format2 = null;
        int[] filter = null;
        int cleanDim = 0;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p instanceof String) {
                format2 = (String)p;
                continue;
            }
            if (p instanceof Molecule) {
                mol = (Molecule)p;
                continue;
            }
            if (p instanceof Molecule[]) {
                mols = (Molecule[])p;
                continue;
            }
            if (p instanceof Integer) {
                cleanDim = (Integer)p;
                continue;
            }
            if (p instanceof Double) {
                cleanDim = ((Double)p).intValue();
                continue;
            }
            if (p instanceof int[]) {
                filter = (int[])p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (format2 == null) {
            throw new ParseException("Format parameter is not set.");
        }
        if (!MFileFormatUtil.isOutputCleanable(format2)) {
            cleanDim = 0;
        }
        if (mol == null && mols == null && (mol = (Molecule)this.callback("mol", null)) == null) {
            throw new ParseException("No input molecule.");
        }
        if (mol != null) {
            if (filter == null || filter.length == 0) {
                Molecule clone = mol.cloneMolecule();
                clone.clean(cleanDim, null);
                s.push(clone.toFormat(format2));
            } else {
                MoleculeGraph fmol = null;
                mol.clonecopy(filter, fmol);
                fmol.clean(cleanDim, null);
                s.push(((Molecule)fmol).toFormat(format2));
            }
        } else if (mols != null) {
            String molString = null;
            try {
                molString = MolString.exportMolecules(mols, format2, cleanDim);
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
            s.push(molString);
        } else {
            throw new ParseException("No input molecule(s).");
        }
    }

    private static String exportMolecules(Molecule[] mols, String fmtWithOpts, int cleanDim) throws MolExportException, IllegalArgumentException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MolExporter exporter = new MolExporter(baos, fmtWithOpts);
        exporter.setClean(cleanDim, null);
        for (Molecule mol : mols) {
            exporter.write(mol);
        }
        exporter.close();
        return baos.toString();
    }
}

