/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class Sort
extends PostfixMathCommand {
    private boolean asc = true;

    public Sort(boolean asc) {
        this.asc = asc;
        this.numberOfParameters = 1;
        this.curNumberOfParameters = 1;
    }

    @Override
    public void run(Stack s) throws ParseException {
        double res = Double.NaN;
        Object p = s.peek();
        if (p instanceof double[]) {
            double[] a = (double[])p;
            Arrays.sort(a);
            if (!this.asc) {
                int i;
                int n = a.length - 1;
                for (i = n / 2; i >= 0; --i) {
                    double x = a[i];
                    a[i] = a[n - i];
                    a[n - i] = x;
                }
                if (n >= 0 && !Double.isNaN(a[n])) {
                    while (Double.isNaN(a[0])) {
                        for (i = 0; i < n; ++i) {
                            a[i] = a[i + 1];
                        }
                        a[n] = Double.NaN;
                    }
                }
            }
        } else if (p instanceof int[]) {
            int[] a = (int[])p;
            Arrays.sort(a);
            if (!this.asc) {
                int n = a.length - 1;
                for (int i = n / 2; i >= 0; --i) {
                    int x = a[i];
                    a[i] = a[n - i];
                    a[n - i] = x;
                }
            }
        } else if (p instanceof long[]) {
            long[] a = (long[])p;
            Arrays.sort(a);
            if (!this.asc) {
                int n = a.length - 1;
                for (int i = n / 2; i >= 0; --i) {
                    long x = a[i];
                    a[i] = a[n - i];
                    a[n - i] = x;
                }
            }
        } else if (p instanceof List) {
            List list = (List)p;
            Collections.sort(list);
            if (!this.asc) {
                Collections.reverse(list);
            }
        } else {
            throw new ParseException("Array sort is not implemented for class: " + p.getClass().getName());
        }
    }
}

