/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseReader;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LicenseDescriptionGUIFactory {
    String[] columnNames = new String[]{"Software", "Status", "License Term", "Licensee", "Expiration Date", "Support Expiration Date", "Restriction", "Number of Users", "Comment"};
    private Font baseFont;
    private JTable licenseTable;
    private JTable licenseOverviewTable;
    private JTable installOverviewTable;
    Vector<Vector<String>> dataRowVectors = new Vector();
    Vector<String> columnVector = new Vector();
    DefaultTableModel tmodel;
    private long time = 0L;

    public LicenseDescriptionGUIFactory(Font baseFont) {
        this.baseFont = baseFont;
    }

    public JTable createLicenseTable(String product) {
        this.licenseTable = this.createOverviewTable();
        ArrayList<License> licenses = LicenseHandler.getInstance().getLicenses(product, null);
        this.updateLicenseOverviewTable(licenses, this.licenseTable);
        return this.licenseTable;
    }

    public void updateLicenseTable(String product) {
        ArrayList<License> licenses = LicenseHandler.getInstance().getLicenses(product, null);
        this.updateLicenseOverviewTable(licenses, this.licenseTable);
    }

    public JTable createLicenseOverviewTable() {
        this.licenseOverviewTable = this.createOverviewTable();
        this.updateLicenseOverviewTable();
        return this.licenseOverviewTable;
    }

    public JTable createInstallOverviewTable(ArrayList<License> installedLicenses) {
        this.installOverviewTable = this.createOverviewTable();
        this.updateLicenseOverviewTable(installedLicenses, this.installOverviewTable);
        return this.installOverviewTable;
    }

    private JTable createOverviewTable() {
        JTable overviewTable = new JTable();
        DefaultTableModel tmodel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }
        };
        tmodel.setColumnIdentifiers(this.columnNames);
        overviewTable.setModel(tmodel);
        overviewTable.setFont(this.baseFont);
        overviewTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        overviewTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        overviewTable.getColumnModel().getColumn(6).setPreferredWidth(200);
        overviewTable.setDefaultRenderer(String.class, new MultiLineCellRenderer());
        overviewTable.setRowHeight(overviewTable.getRowHeight() * 3);
        return overviewTable;
    }

    private Vector<String> getRowVector(License lic) {
        Vector<String> v = new Vector<String>();
        v.add(lic.getSoftware());
        v.add(LicenseReader.getInstance().getValidationState(lic, this.time));
        v.add(lic.getLicenseTerm());
        v.add(lic.getLicensee());
        v.add(lic.getExpirationDate());
        v.add(lic.getSupportExpirationDate());
        v.add(lic.getRestrictions());
        v.add(lic.getLicensedUnitCount());
        v.add(lic.getFieldValue("Comment"));
        return v;
    }

    public void updateLicenseOverviewTable() {
        this.updateLicenseOverviewTable(LicenseHandler.getInstance().getLicenses(null, null), this.licenseOverviewTable);
    }

    public void updateLicenseOverviewTable(ArrayList<License> licenses, JTable table) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.getDataVector().clear();
        this.time = System.currentTimeMillis();
        for (License lic : licenses) {
            model.getDataVector().add(this.getRowVector(lic));
        }
        table.setModel(model);
        table.revalidate();
        table.repaint();
    }

    public void setCustomLicenseState(JTable table, String state) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        Vector<Vector> rows = model.getDataVector();
        for (int i = 0; i < rows.size(); ++i) {
            Vector row = rows.get(i);
            if (!(row instanceof Vector)) continue;
            Vector rowVector = row;
            rowVector.remove(1);
            rowVector.add(1, state);
        }
        table.setModel(model);
        table.revalidate();
        table.repaint();
    }

    private class MultiLineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        public MultiLineCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

