/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.license.License;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.LicenseStateChecker;
import chemaxon.license.XMLVerifier;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class LicenseReader {
    private static ArrayList<LicenseFileContent> cxlFileContents = new ArrayList();
    static final String DEFAULT_LICENSE_FILE = "license.cxl";
    static final String DEFAULT_LICENSE_DIRECTORY = "licenses";
    private static ArrayList<License> licenses = new ArrayList();
    private static XMLVerifier verifier = null;
    private static String lastLicensePath = "";
    private static String fullLicensePath = "";
    private static int maximumSearchPerMin = 0;
    private static Logger installLogger = null;
    private static Logger verifyLogger = null;
    private boolean readUserHome = true;
    private static final String DEFAULT = "default";

    private LicenseReader() {
    }

    public static LicenseReader getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setLoggers(Logger il, Logger vl) {
        installLogger = il;
        verifyLogger = vl;
    }

    public void clear() {
        licenses.clear();
        cxlFileContents.clear();
        LicenseExceptionHandler.getInstance().setLicenseRead(false);
    }

    public void read() {
        this.readSystemProperty();
        this.readEnvironmentVariable();
        if (this.readUserHome) {
            this.readBuiltIn();
            this.readUserHome();
        }
    }

    public void fetch() throws LicenseProcessingException {
        for (LicenseFileContent license : cxlFileContents) {
            this.verifyCXLContents(new ByteArrayInputStream(license.getContent().getBytes()), license.isUrlPath(), licenses);
        }
    }

    public synchronized int getJChemSearchPerMin() {
        return maximumSearchPerMin;
    }

    void setJChemSearchPerMin(String spm) {
        if (spm.equals("Unlimited")) {
            maximumSearchPerMin = Integer.MAX_VALUE;
        } else {
            try {
                int s = Integer.parseInt(spm);
                if (s > maximumSearchPerMin) {
                    maximumSearchPerMin = s;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized void setLicense(String s) {
        cxlFileContents.add(new LicenseFileContent(s, true));
    }

    public synchronized void setLicenseFile(String licensePath) throws LicenseProcessingException {
        this.setLastLicensePath(licensePath);
        installLogger.config("Setting license file: " + licensePath);
        LicenseInputStream is = this.getInputStream(licensePath);
        if (is == null) {
            installLogger.warning("License file not found: " + licensePath);
            throw new LicenseProcessingException(3, null, licensePath);
        }
        try {
            this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), cxlFileContents);
        }
        catch (IOException ioex) {
            installLogger.warning("Problem reading license file: " + licensePath);
            throw new LicenseProcessingException(2, ioex, licensePath);
        }
    }

    public synchronized ArrayList<License> readLicensesFromFile(String path) throws LicenseProcessingException {
        ArrayList<LicenseFileContent> contents = new ArrayList<LicenseFileContent>();
        ArrayList<License> licenses = new ArrayList<License>();
        LicenseInputStream is = this.getInputStream(path);
        if (is == null) {
            return licenses;
        }
        try {
            this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), contents);
            for (LicenseFileContent license : contents) {
                this.verifyCXLContents(new ByteArrayInputStream(license.getContent().getBytes()), license.isUrlPath(), licenses);
            }
        }
        catch (Exception e) {
            installLogger.warning("Problem reading license file: " + path);
            throw new LicenseProcessingException(2, e, path);
        }
        return licenses;
    }

    private void addLicensePath(String path) {
        fullLicensePath = "".equals(fullLicensePath) ? path : fullLicensePath + ";" + path;
        lastLicensePath = path;
        LicenseExceptionHandler.getInstance().setLicensePath(path);
    }

    public void setLastLicensePath(String path) {
        fullLicensePath = "".equals(fullLicensePath) ? path : fullLicensePath + ";" + path;
        lastLicensePath = path;
        LicenseExceptionHandler.getInstance().setLicensePath(path);
    }

    public String getFullLicensePath() {
        return fullLicensePath;
    }

    public String getLastLicensePath() {
        return lastLicensePath;
    }

    public synchronized ArrayList<License> getReadLicenses() {
        ArrayList<License> list = new ArrayList<License>();
        list.addAll(licenses);
        return list;
    }

    public synchronized License getStrongestLicense(String product) {
        License license = new License();
        int strongest = -1;
        for (int i = 0; i < licenses.size(); ++i) {
            License lic = licenses.get(i);
            if (!lic.getSoftware().toLowerCase().equals(product.toLowerCase()) || LicenseStateChecker.isExpired(lic) || strongest != -1) continue;
            strongest = i;
            license.setLicensee(lic.getLicensee());
            license.setLicenseTerm(lic.getLicenseTerm());
            license.setSoftware(lic.getSoftware());
            license.setExpirationDate(lic.getExpirationDate());
        }
        return license;
    }

    public synchronized ArrayList<License> getLicenses(String product, String term) {
        ArrayList<License> retlic = new ArrayList<License>();
        for (License lic : licenses) {
            if (product != null && !lic.getSoftware().toLowerCase().equals(product.toLowerCase()) || term != null && !lic.getLicenseTerm().equals(term)) continue;
            try {
                retlic.add(lic.clone());
            }
            catch (CloneNotSupportedException cne) {
                return retlic;
            }
        }
        return retlic;
    }

    private void readSystemProperty() {
        String licPath = null;
        installLogger.config("Searching for license file given with Java system property: chemaxon.license.url");
        try {
            licPath = System.getProperty("chemaxon.license.url");
            if (licPath != null) {
                this.readUserHome = false;
                this.readPaths(licPath);
            }
        }
        catch (SecurityException se) {
            installLogger.warning("Reading Java system property is not allowed: " + licPath);
        }
    }

    private void readPaths(String pathString) {
        String[] paths = pathString.split(";");
        for (int i = 0; i < paths.length; ++i) {
            if (DEFAULT.equals(paths[i])) {
                this.addLicensePath(paths[i]);
                this.readUserHome = true;
                continue;
            }
            LicenseInputStream is = this.getInputStreamFromVariable(paths[i]);
            if (is == null) continue;
            try {
                this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), cxlFileContents);
                this.addLicensePath(paths[i]);
                installLogger.config("Reading license file from: " + paths[i]);
                continue;
            }
            catch (IOException e) {
                installLogger.warning("Reading file given as Java system property failed:" + paths[i]);
            }
        }
    }

    private void readEnvironmentVariable() {
        String licPath = null;
        installLogger.config("Searching for license file given with environment variable: CHEMAXON_LICENSE_URL");
        try {
            licPath = System.getenv("CHEMAXON_LICENSE_URL");
            if (licPath != null) {
                if (this.readUserHome && "".equals(this.getLastLicensePath())) {
                    this.readUserHome = false;
                }
                this.readPaths(licPath);
            }
        }
        catch (SecurityException se) {
            installLogger.warning("Reading environment variable is not allowed: " + licPath);
        }
    }

    private boolean readBuiltIn() {
        try {
            String path = "/chemaxon/license.cxl";
            InputStream is = BasicEnvironment.getResourceAsStream(LicenseHandler.class, path);
            if (is != null) {
                installLogger.fine("Reading built-in license.cxl");
                this.addLicenseFileContent(is, false, cxlFileContents);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public String getDefaultLicensePath() {
        return DotfileUtil.getDotDir() + File.separator + DEFAULT_LICENSE_FILE;
    }

    private void readUserHome() {
        try {
            this.readFileFromUserHome(DotfileUtil.getDotDir() + File.separator + DEFAULT_LICENSE_FILE);
            File f = new File(DotfileUtil.getDotDir() + File.separator + DEFAULT_LICENSE_DIRECTORY);
            if (f.exists() && f.isDirectory()) {
                File[] licenseFiles = f.listFiles();
                for (int i = 0; i < licenseFiles.length; ++i) {
                    this.readFileFromUserHome(licenseFiles[i].getPath());
                }
            }
        }
        catch (SecurityException se) {
            installLogger.warning("Reading license.cxl file from user home is not allowed: " + lastLicensePath);
        }
    }

    private void readFileFromUserHome(String path) {
        try {
            FileInputStream is = new FileInputStream(path);
            this.addLicensePath(path);
            this.addLicenseFileContent(is, false, cxlFileContents);
            installLogger.config("Reading license file from user home: " + path);
        }
        catch (IOException e) {
            installLogger.config("Reading license file from user home failed: " + path);
        }
    }

    private void addLicenseFileContent(InputStream is, boolean urlPath, ArrayList<LicenseFileContent> licenseFileContents) throws IOException {
        String line;
        LicenseExceptionHandler.getInstance().setLicenseRead(true);
        String fileContent = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            fileContent = fileContent + line + "\n";
        }
        LicenseFileContent lfc = new LicenseFileContent(fileContent, urlPath);
        if (!licenseFileContents.contains(lfc)) {
            licenseFileContents.add(lfc);
        }
        br.close();
        is.close();
    }

    private LicenseInputStream getInputStream(String path) {
        try {
            File f = new File(path);
            FileInputStream fis = new FileInputStream(f);
            installLogger.fine("Creating FileInputStream from " + path);
            return new LicenseInputStream(fis, false);
        }
        catch (FileNotFoundException fnf) {
            InputStream is = BasicEnvironment.getResourceAsStream(LicenseHandler.class, path);
            if (is != null) {
                installLogger.fine("Creating ResourceStream from " + path);
                return new LicenseInputStream(is, true);
            }
            installLogger.fine("Creating URLStream from " + path);
            return this.getURLStream(path);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private LicenseInputStream getInputStreamFromVariable(String licPath) {
        LicenseInputStream is = this.getURLStream(licPath);
        if (is != null) {
            return is;
        }
        try {
            return new LicenseInputStream(new FileInputStream(licPath), false);
        }
        catch (FileNotFoundException fne) {
            installLogger.config("FileInputStream could not created from " + licPath);
            return null;
        }
    }

    private LicenseInputStream getURLStream(String path) {
        try {
            URL url = new URL(path);
            return new LicenseInputStream(url.openConnection().getInputStream(), true);
        }
        catch (Exception ex) {
            installLogger.config("URL stream could not be created from " + path);
            return null;
        }
    }

    private synchronized void verifyCXLContents(InputStream licenseInputStream, boolean isURLPath, ArrayList<License> licenses) throws LicenseProcessingException {
        if (verifier == null) {
            try {
                verifier = new XMLVerifier();
            }
            catch (NoSuchAlgorithmException e) {
                installLogger.severe("Fatal error - required java cryptography algorithm is not available.");
                throw new LicenseProcessingException(4, e);
            }
        }
        ArrayList<License> readLicenses = null;
        try {
            readLicenses = verifier.verifyXML(licenseInputStream, verifyLogger);
        }
        catch (LicenseProcessingException e) {
            installLogger.warning(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            installLogger.warning("Problem reading license file: " + lastLicensePath);
            throw new LicenseProcessingException(1, e, lastLicensePath);
        }
        for (int i = 0; i < readLicenses.size(); ++i) {
            License lic = readLicenses.get(i);
            if (licenses.contains(lic) || isURLPath && lic.getRestriction("Server Use").equals("Not Allowed")) continue;
            lic.validated = true;
            licenses.add(lic);
        }
    }

    public synchronized String report() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < licenses.size(); ++i) {
            sb.append(licenses.get(i).getLicenseData());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static synchronized String report(String product, String term) {
        StringBuffer sb = new StringBuffer();
        for (License lic : licenses) {
            if (product != null && !lic.getSoftware().equals(product) || term != null && !lic.getLicenseTerm().equals(term)) continue;
            sb.append(lic.toString());
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append("License is not found with the given condition.");
        }
        return sb.toString();
    }

    public synchronized String report(String product, String term, boolean expired) {
        StringBuffer sb = new StringBuffer();
        for (License lic : licenses) {
            if (product != null && !lic.getSoftware().equals(product) || term != null && !lic.getLicenseTerm().equals(term) || this.isExpired(lic.getSoftware()) != expired) continue;
            sb.append(lic.toString());
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append("License is not found with the given condition.");
        }
        return sb.toString();
    }

    public synchronized boolean isAboutToExpire(String product) {
        boolean expires = false;
        for (License lic : licenses) {
            if (!lic.getSoftware().toLowerCase().equals(product.toLowerCase()) || LicenseStateChecker.isExpired(lic)) continue;
            if (LicenseStateChecker.isAboutToExpire(lic)) {
                expires = true;
                continue;
            }
            return false;
        }
        return expires;
    }

    public synchronized boolean isExpired(String product) {
        long time = System.currentTimeMillis();
        for (License lic : licenses) {
            if (!lic.getSoftware().toLowerCase().equals(product.toLowerCase()) || LicenseStateChecker.isExpired(lic, time)) continue;
            return false;
        }
        return true;
    }

    public String getValidationState(License lic) {
        return this.getValidationState(lic, System.currentTimeMillis());
    }

    public String getValidationState(License lic, long timeStamp) {
        if (timeStamp == 0L) {
            return this.getValidationState(lic, System.currentTimeMillis());
        }
        if (LicenseStateChecker.isExpired(lic, timeStamp)) {
            return "Expired";
        }
        if (LicenseStateChecker.isAboutToExpire(lic, timeStamp)) {
            return "About to Expire";
        }
        if (!licenses.contains(lic)) {
            return "Invalid";
        }
        return "Valid";
    }

    private final class LicenseInputStream {
        private InputStream inputStream;
        private boolean urlPath;

        private LicenseInputStream(InputStream inputStream, boolean urlPath) {
            this.inputStream = inputStream;
            this.urlPath = urlPath;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public boolean isUrlPath() {
            return this.urlPath;
        }

        public void setUrlPath(boolean urlPath) {
            this.urlPath = urlPath;
        }
    }

    private final class LicenseFileContent {
        private String content;
        private boolean urlPath;

        private LicenseFileContent(String content, boolean urlPath) {
            this.content = content;
            this.urlPath = urlPath;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean isUrlPath() {
            return this.urlPath;
        }

        public void setUrlPath(boolean urlPath) {
            this.urlPath = urlPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LicenseFileContent that = (LicenseFileContent)o;
            return !(this.content != null ? !this.content.equals(that.content) : that.content != null);
        }

        public int hashCode() {
            int result = this.content != null ? this.content.hashCode() : 0;
            result = 31 * result + (this.urlPath ? 1 : 0);
            return result;
        }
    }

    private static class SingletonHolder {
        private static final LicenseReader INSTANCE = new LicenseReader();

        private SingletonHolder() {
        }
    }
}

