/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.marvin.version.VersionInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LicenseStateChecker {
    private static long versionTime = 0L;
    private static long expiration;
    private static long supportExpiration;
    private static long exactExpiration;

    public static long setExpirationTime(License lic) {
        LicenseStateChecker.setExpirationInMs(lic);
        return expiration;
    }

    private static void setExpirationInMs(License lic) {
        expiration = 0L;
        supportExpiration = 0L;
        exactExpiration = 0L;
        LicenseStateChecker.setExpirationInMs(lic, true);
        LicenseStateChecker.setExpirationInMs(lic, false);
    }

    private static void setExpirationInMs(License lic, boolean upgrade) {
        Date expTime;
        String date;
        String string = date = upgrade ? lic.getSupportExpirationDate() : lic.getExpirationDate();
        if (date.toLowerCase().equals("never")) {
            if (upgrade) {
                supportExpiration = Long.MAX_VALUE;
            } else {
                expiration = Long.MAX_VALUE;
                exactExpiration = Long.MAX_VALUE;
            }
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            expTime = sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Calendar expDate = Calendar.getInstance();
        expDate.setTime(expTime);
        if (!upgrade) {
            exactExpiration = expDate.getTimeInMillis();
        }
        if (lic.getLicenseTerm().equals("Evaluation")) {
            expDate.add(5, 7);
        } else {
            expDate.add(5, 30);
        }
        if (upgrade) {
            supportExpiration = expDate.getTimeInMillis();
        } else {
            expiration = expDate.getTimeInMillis();
        }
    }

    public static boolean isExpired(License lic, long timeStamp) {
        LicenseStateChecker.setExpirationInMs(lic);
        return timeStamp > expiration;
    }

    public static boolean isExpired(License lic) {
        return LicenseStateChecker.isExpired(lic, System.currentTimeMillis());
    }

    public static boolean isAboutToExpire(License lic, long timeStamp) {
        LicenseStateChecker.setExpirationInMs(lic);
        return timeStamp > exactExpiration && timeStamp < expiration;
    }

    public static boolean isAboutToExpire(License lic) {
        return LicenseStateChecker.isAboutToExpire(lic, System.currentTimeMillis());
    }

    public static boolean isUpgradeExpired(License lic) {
        LicenseStateChecker.setExpirationInMs(lic);
        return LicenseStateChecker.getVersionTime() > supportExpiration;
    }

    private static long getVersionTime() {
        if (versionTime == 0L) {
            Date versionDate;
            String buildDate = VersionInfo.buildDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                versionDate = sdf.parse(buildDate);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            versionTime = versionDate.getTime();
        }
        return versionTime;
    }

    public static String getValidationState(License lic) {
        long now = System.currentTimeMillis();
        if (now - lic.lastStateUpdate < 36000L) {
            return lic.getStateText();
        }
        LicenseStateChecker.setValidationState(lic, now);
        return lic.getStateText();
    }

    private static void setValidationState(License lic, long timeStamp) {
        if (timeStamp == 0L) {
            LicenseStateChecker.setValidationState(lic, System.currentTimeMillis());
        }
        if (LicenseStateChecker.isExpired(lic, timeStamp)) {
            lic.setState(3);
        } else if (LicenseStateChecker.isAboutToExpire(lic, timeStamp)) {
            lic.setState(4);
        } else if (!lic.validated) {
            lic.setState(2);
        } else {
            lic.setState(1);
        }
    }
}

