/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLReader {
    public ArrayList<License> readXML(InputStream is) throws ParserConfigurationException, IOException, SAXException, LicenseProcessingException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(is);
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("ChemAxon")) {
            return null;
        }
        NodeList licenseNodes = root.getElementsByTagName("License");
        ArrayList<License> licenses = new ArrayList<License>(licenseNodes.getLength());
        for (int i = 0; i < licenseNodes.getLength(); ++i) {
            License license = new License();
            Node licenseNode = licenseNodes.item(i);
            if (licenseNode.getNodeType() == 1) {
                Node sig;
                String value;
                String name;
                Element licenseElement = (Element)licenseNode;
                NodeList fieldList = licenseElement.getElementsByTagName("Field");
                for (int j = 0; j < fieldList.getLength(); ++j) {
                    Node field = fieldList.item(j);
                    if (field.getNodeType() != 1) continue;
                    Element fieldElement = (Element)field;
                    name = fieldElement.getAttribute("Name");
                    value = fieldElement.getAttribute("Value");
                    if (value.length() == 0) {
                        throw new LicenseProcessingException("Bad license for " + license.getSoftware() + ", missing field value: " + name);
                    }
                    license.setField(name, value);
                }
                NodeList resList = licenseElement.getElementsByTagName("Restriction");
                for (int j = 0; j < resList.getLength(); ++j) {
                    Node res = resList.item(j);
                    if (res.getNodeType() != 1) continue;
                    Element resElement = (Element)res;
                    name = resElement.getAttribute("Name");
                    value = resElement.getAttribute("Value");
                    if (value.length() == 0) {
                        throw new LicenseProcessingException("Bad license for " + license.getSoftware() + ", missing restriction value: " + name);
                    }
                    license.setRestriction(name, value);
                }
                NodeList sigList = licenseElement.getElementsByTagName("Signature");
                if (sigList.getLength() == 1 && (sig = sigList.item(0)).getNodeType() == 1) {
                    Element signature = (Element)sig;
                    license.setSignature(signature.getAttribute("Value"));
                }
            }
            licenses.add(license);
        }
        return licenses;
    }
}

