/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.markush.MarkushFeature;
import chemaxon.markush.graph.ExpansionData;
import chemaxon.markush.graph.ExpansionGraphUtil;
import chemaxon.markush.graph.FeatureNode;
import chemaxon.markush.graph.MarkushSelectionMolecule;
import chemaxon.markush.graph.Node;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.HashSet;

public class StructureNode
extends Node {
    private MoleculeGraph structure = null;
    private MarkushSelectionMolecule fixedPart = null;
    private FeatureNode[] featureNodes = null;

    StructureNode(MoleculeGraph structure, ExpansionData data) {
        this.structure = structure;
        this.fixedPart = new MarkushSelectionMolecule();
        this.fixedPart.fuse(this.structure);
        this.init(data);
    }

    private void init(ExpansionData data) {
        ArrayList<FeatureNode> v = new ArrayList<FeatureNode>();
        this.processMultiBonds(v, data);
        this.processAtoms(v, data);
        this.processRepeatingParts(v, data);
        this.featureNodes = v.toArray(new FeatureNode[v.size()]);
    }

    private void processAtoms(ArrayList<FeatureNode> v, ExpansionData data) {
        int count = this.structure.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = this.structure.getAtom(i);
            MarkushFeature feature = null;
            if (!data.atom2features.containsKey(atom) && this.fixedPart.contains(atom)) {
                switch (atom.getAtno()) {
                    case 134: {
                        int rgindex = data.markush.findRgroupIndex(atom.getRgroup());
                        if (rgindex == -1) break;
                        feature = new MarkushFeature(6, rgindex);
                        break;
                    }
                    case 128: {
                        feature = new MarkushFeature(1, data.markush.indexOf(atom));
                    }
                }
            }
            if (feature == null) continue;
            v.add(StructureNode.getFeatureNode(feature, data, this.fixedPart));
            this.updateFixedPart(atom, data.markush);
        }
    }

    private void processMultiBonds(ArrayList<FeatureNode> v, ExpansionData data) {
        int atomCount = data.markush.getGraphUnion().getAtomCount();
        int count = this.structure.getBondCount();
        for (int i = 0; i < count; ++i) {
            MarkushFeature feature;
            MolBond bond = this.structure.getBond(i);
            if (data.atom2features.containsKey(bond.getAtom1()) || data.atom2features.containsKey(bond.getAtom2()) || !StructureNode.isExpandableMultiBond(bond)) continue;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            int index1 = data.markush.indexOf(atom1);
            int index2 = data.markush.indexOf(atom2);
            assert (index1 != -1);
            assert (index2 != -1);
            if (atom1.getAtno() == 137) {
                feature = new MarkushFeature(4, MarkushFeature.calcMultiBondData(index1, index2, atomCount));
                v.add(StructureNode.getFeatureNode(feature, data, this.fixedPart));
                this.updateFixedPartMulticenter(atom1, data.markush);
            }
            if (atom2.getAtno() != 137) continue;
            feature = new MarkushFeature(4, MarkushFeature.calcMultiBondData(index2, index1, atomCount));
            v.add(StructureNode.getFeatureNode(feature, data, this.fixedPart));
            this.updateFixedPartMulticenter(atom2, data.markush);
        }
    }

    private void updateFixedPart(MolAtom atom, RgMolecule markush) {
        for (int i = this.fixedPart.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = this.fixedPart.getBond(i);
            if (atom == bond.getAtom1()) {
                ExpansionGraphUtil.addAttachment(bond.getAtom2(), bond, this.fixedPart, markush);
                this.fixedPart.removeBond(bond);
                continue;
            }
            if (atom != bond.getAtom2()) continue;
            ExpansionGraphUtil.addAttachment(bond.getAtom1(), bond, this.fixedPart, markush);
            this.fixedPart.removeBond(bond);
        }
        this.fixedPart.removeAtom(atom);
    }

    private void updateFixedPartMulticenter(MolAtom multicenter, RgMolecule markush) {
        MarkushSelectionMolecule variablePart = new MarkushSelectionMolecule();
        variablePart.add(multicenter);
        MulticenterSgroup sgroup = markush.findContainingMulticenterSgroup(multicenter);
        if (sgroup != null) {
            variablePart.fuse(sgroup.getSgroupGraph());
        }
        this.updateFixedPart(variablePart, markush);
    }

    private void updateFixedPart(MoleculeGraph variablePart, RgMolecule markush) {
        int i;
        for (i = this.fixedPart.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = this.fixedPart.getBond(i);
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            boolean v1 = variablePart.contains(atom1);
            boolean v2 = variablePart.contains(atom2);
            if (v1 && !v2) {
                ExpansionGraphUtil.addAttachment(atom2, bond, this.fixedPart, markush);
            } else if (!v1 && v2) {
                ExpansionGraphUtil.addAttachment(atom1, bond, this.fixedPart, markush);
            }
            if (!v1 && !v2) continue;
            this.fixedPart.removeBond(bond);
        }
        for (i = variablePart.getAtomCount() - 1; i >= 0; --i) {
            this.fixedPart.removeAtom(variablePart.getAtom(i));
        }
    }

    private static boolean isExpandableMultiBond(MolBond bond) {
        return bond.getType() != 9 && (bond.getAtom1().getAtno() == 137 || bond.getAtom2().getAtno() == 137);
    }

    private void processRepeatingParts(ArrayList<FeatureNode> v, ExpansionData data) {
        MarkushFeature feature = null;
        while ((feature = this.getNextCoveringFeature(data)) != null) {
            this.removeCoveringFeature(feature, data);
            v.add(StructureNode.getFeatureNode(feature, data, this.fixedPart));
        }
    }

    private MarkushFeature getNextCoveringFeature(ExpansionData data) {
        int coverage = Integer.MAX_VALUE;
        MarkushFeature feature = null;
        int count = this.fixedPart.getAtomCount();
        for (int i = 0; i < count; ++i) {
            HashSet<MarkushFeature> features;
            int size;
            MolAtom atom = this.fixedPart.getAtom(i);
            if (!data.atom2features.containsKey(atom) || (size = (features = data.atom2features.get(atom)).size()) >= coverage) continue;
            feature = features.iterator().next();
            coverage = size;
            if (size == 1) break;
        }
        return feature;
    }

    private void removeCoveringFeature(MarkushFeature feature, ExpansionData data) {
        MoleculeGraph part = data.feature2part.get(feature);
        for (int i = part.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = part.getAtom(i);
            data.atom2features.get(atom).remove(feature);
            if (!data.atom2features.get(atom).isEmpty()) continue;
            data.atom2features.remove(atom);
        }
        this.updateFixedPart(part, data.markush);
    }

    private static FeatureNode getFeatureNode(MarkushFeature feature, ExpansionData data, SelectionMolecule part) {
        FeatureNode node = data.feature2node.get(feature);
        if (node == null) {
            node = new FeatureNode(feature, data, part);
            if (feature.getType() != 1) {
                data.feature2node.put(feature, node);
            }
        }
        return node;
    }

    public SelectionMolecule getFixedPart() {
        return this.fixedPart;
    }

    public MoleculeGraph getStructure() {
        return this.structure;
    }

    public int getFeatureNodeCount() {
        return this.featureNodes.length;
    }

    public FeatureNode getFeatureNode(int i) {
        return this.featureNodes[i];
    }
}

