/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.properties;

import chemaxon.markush.CalculatorDataProvider;
import chemaxon.markush.MarkushDataProvider;
import chemaxon.markush.MarkushFeature;
import chemaxon.markush.PropertyCalculator;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.SelectionMolecule;
import java.math.BigInteger;

public class EnumerationCountCalculator
implements PropertyCalculator<BigInteger> {
    private static long getBondMultiplicity(int type) {
        switch (type) {
            case 0: {
                return 3L;
            }
            case 5: 
            case 6: 
            case 7: {
                return 2L;
            }
        }
        return 1L;
    }

    @Override
    public BigInteger calculate(CalculatorDataProvider cdp, MarkushDataProvider mdp) {
        SelectionMolecule structure = cdp.getCalcSelection();
        long count = 1L;
        for (int i = structure.getBondCount() - 1; i >= 0; --i) {
            MarkushFeature feature2;
            MarkushFeature feature1;
            MolBond bond = structure.getBond(i);
            long m = EnumerationCountCalculator.getBondMultiplicity(bond.getType());
            if (m == 1L) continue;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            MarkushFeature markushFeature = atom1.getAtno() == 138 ? MarkushDataProvider.getMarkushFeature(atom1) : (feature1 = null);
            MarkushFeature markushFeature2 = atom2.getAtno() == 138 ? MarkushDataProvider.getMarkushFeature(atom2) : (feature2 = null);
            if (feature1 != null || feature2 != null) continue;
            count *= m;
        }
        return BigInteger.valueOf(count);
    }
}

