/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.properties;

import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.markush.CalculatorDataProvider;
import chemaxon.markush.MarkushDataProvider;
import chemaxon.markush.PropertyCalculator;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;

public class MolWeightCalculator
implements PropertyCalculator<double[]> {
    private ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();

    private static int getMinType(int type) {
        switch (type) {
            case 0: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: {
                return 4;
            }
        }
        return type;
    }

    private static int getMaxType(int type) {
        switch (type) {
            case 0: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 2;
            }
        }
        return type;
    }

    @Override
    public double[] calculate(CalculatorDataProvider cdp, MarkushDataProvider mdp) {
        SelectionMolecule structure = cdp.getCalcSelection();
        Molecule m1 = new Molecule();
        Molecule m2 = new Molecule();
        structure.clonecopy(m1);
        structure.clonecopy(m2);
        for (int i = structure.getBondCount() - 1; i >= 0; --i) {
            int type = structure.getBond(i).getType();
            int type1 = MolWeightCalculator.getMinType(type);
            int type2 = MolWeightCalculator.getMaxType(type);
            if (type1 != type) {
                m1.getBond(i).setType(type1);
            }
            if (type2 == type) continue;
            m2.getBond(i).setType(type2);
        }
        this.elemanal.setMolecule(m1);
        double mass1 = this.elemanal.exactMass();
        this.elemanal.setMolecule(m2);
        double mass2 = this.elemanal.exactMass();
        return new double[]{mass2, mass1};
    }
}

