/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.calculator.CalculatorLogger;
import chemaxon.calculator.CalculatorRunner;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginCachedResults;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.CalculatorResultAccess;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginManager;
import chemaxon.marvin.plugin.ServiceOutput;
import chemaxon.marvin.plugin.concurrent.DefaultPluginWorkUnit;
import chemaxon.marvin.plugin.concurrent.PluginExecutionException;
import chemaxon.marvin.plugin.concurrent.ReusablePluginWorkUnit;
import chemaxon.marvin.services.ChemicalTermsArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorTools;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.Molecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.marvin.CompositeInputProducer;
import chemaxon.util.concurrent.marvin.CompositeWorkUnit;
import chemaxon.util.concurrent.marvin.MolInputProducer;
import chemaxon.util.concurrent.marvin.ReusableInputProducer;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class Calculator {
    public static boolean DIRECT_RUN = true;
    private static final String MOLCOUNT_PROP = "_MOLCOUNT";
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final String DASH = "--";
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = lineSep + "Calculator, (C) 1998-2012 ChemAxon Ltd." + lineSep + "version " + VersionInfo.MARVIN_VERSION + lineSep + "Licenses of additionally used third party programs can be found in license.html" + lineSep + "Online version: http://www.chemaxon.com/marvin/license.html" + lineSep + "Runs various molecule calculations: charge, pKa, logP, etc." + lineSep + lineSep + "Usage:" + lineSep + "  cxcalc [general options] [input files/strings]" + lineSep + "       <plugin> [plugin options] [input files/strings]" + lineSep + "  cxcalc [general options] [input files]" + lineSep + "       <plugin1> [plugin1 options] [input files/strings]" + lineSep + "       <plugin2> [plugin2 options] [input files/strings]" + lineSep + "       ..." + lineSep + "" + lineSep + "General options:" + lineSep + "  cxcalc -h, --help                 this help message," + lineSep + "                                    list of available calculations" + lineSep + "  cxcalc <plugin> -h, --help        plugin specific help message" + lineSep + "  -o, --output <filepath>           output file path (default: standard output)" + lineSep + "  -t, --tag <tag name>              name of the SDFile tag to store the" + lineSep + "                                    calculation results, tag name prefix" + lineSep + "                                    to default tag names in case of multiple" + lineSep + "                                    plugins (default: see plugin help)" + lineSep + "  -i, --id <tag name|format>        the name of the existing SDFile tag that " + lineSep + "                                    stores the molecule ID; or create " + lineSep + "                                    molecule ID by converting the input " + lineSep + "                                    molecule into the specified format; " + lineSep + "                                    (default: molecule index is used as ID)" + lineSep + "  -N, --do-not-display <type>       [i|h|ih]" + lineSep + "                                    do not display molecule ID and/or" + lineSep + "                                    table header (in table output form)" + lineSep + "          i                         no molecule ID" + lineSep + "          h                         no table header" + lineSep + "          ih                        neither molecule ID nor table header" + lineSep + "  -S, --sdf-output                  SDF output with results in SDF tags" + lineSep + "  -M, --mrv-output                  result molecule output in MRV format" + lineSep + "                                    (if neither -S nor -M is specified, then" + lineSep + "                                    plugin results are written in table form)" + lineSep + "  -g, --ignore-error                continue with next molecule on error" + lineSep + "  -v, --verbose                     print calculation warnings to the console" + lineSep + "      --log <filepath>              write log messages to file" + lineSep + "                                    (default: write log to system error)" + lineSep + "      --log-level <level>           [error|warning|off]" + lineSep + "                                    set log level (default: error)" + lineSep + "          error                     log error level information" + lineSep + "          warning                   log warning and error level information" + lineSep + "          off                       no log information " + lineSep + "      --log-options <options>       list of logger options, separated by ','" + lineSep + "          time                      log calculation execution time; calculation" + lineSep + "                                    will run on ONE CPU in this case " + lineSep + "          timelimit=<time in ms>    only execution times above the specified " + lineSep + "                                    limit will be logged " + lineSep + "          format=<molecule format>  log file format; default is SDF when " + lineSep + "                                    logging to file and SMILES when logging to " + lineSep + "                                    system error" + lineSep + "" + lineSep;
    private static final String examplestext = lineSep + "Examples:" + lineSep + "  cxcalc mols.sdf charge" + lineSep + "  cxcalc -i smiles mols.sdf logP pKa" + lineSep + "  cxcalc -S -t myLOGP mols.sdf logp -t increments,logP -p 3" + lineSep + "  cxcalc -t my mols.sdf logd -l 3 -u 7 -s 0.5 logp -t increments,logP -p 3" + lineSep;
    private static final String DEFAULT_HELP_TEXT = "-h, --help             this help message" + lineSep;
    private static final String CONFIG_FILE = "calc.properties";
    private static final String RCFILES_PROPKEY = "rcfiles";
    private static Hashtable plugins = null;
    private static Hashtable<String, ServiceDescriptor> services = null;
    private static Hashtable<String, Class<? extends chemaxon.calculator.Calculator>> calculators = null;
    private PluginConfig[] configs = null;
    private Properties[] params = null;
    private Properties[] serviceParams = null;
    private String[] serviceNames = null;
    private Properties[] calculatorParams = null;
    private String[] calculatorCommands = null;
    private CalculatorPluginOutput[] outputs = null;
    private boolean onlyPluginOutput = true;
    private boolean sdfOutput = false;
    private boolean mrvOutput = false;
    private boolean displayID = true;
    private boolean displayHeader = true;
    private PrintStream os = null;
    private MolExporter exporter = null;
    private String format = null;
    private StringBuffer errors = new StringBuffer();
    private CLQ.Parameter pOut = null;
    private boolean ignoreError = false;
    private boolean verbose = false;
    private String[] tags = null;
    private String separator = null;
    private String idTagOrFormat = null;
    private String[] pluginNames = null;
    private boolean outputInited = false;
    private boolean singleTestMode = false;
    private static CalculatorLogger logger;

    private static Hashtable readPluginConfig() throws PluginException {
        ExternalFileLoader pcpLoader;
        InputStream is;
        Properties props = new Properties();
        Calculator.readConfig(props, "/xjars/calc.properties");
        String rcfiles = (String)props.remove(RCFILES_PROPKEY);
        if (rcfiles != null) {
            StringTokenizer stc = new StringTokenizer(rcfiles, ",");
            while (stc.hasMoreTokens()) {
                String filename = stc.nextToken();
                if (!filename.startsWith("/")) {
                    filename = "/" + filename;
                }
                Calculator.readConfig(props, filename);
            }
        }
        if ((is = (pcpLoader = new ExternalFileLoader("plugins/calc.properties")).openFileOutJar()) != null) {
            Calculator.readConfig(props, is, pcpLoader.getFilename());
        }
        return Calculator.readPluginConfig(props);
    }

    private static Hashtable<String, ServiceDescriptor> readServiceConfig() {
        Hashtable<String, ServiceDescriptor> config = new Hashtable<String, ServiceDescriptor>();
        ServiceDescriptorReader serviceReader = ServiceDescriptorTools.getDefaultServiceDescriptorReader();
        if (serviceReader == null) {
            return config;
        }
        InputStream stream = ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream();
        if (stream == null) {
            return config;
        }
        List<ServiceDescriptor> services = serviceReader.readServiceDescriptors(stream);
        for (int i = 0; i < services.size(); ++i) {
            ServiceDescriptor descriptor = services.get(i);
            config.put(descriptor.getName().toLowerCase(), descriptor);
            if (descriptor.getAlias() == null) continue;
            config.put(descriptor.getAlias().toLowerCase(), descriptor);
        }
        return config;
    }

    private static Hashtable readPluginConfig(Properties props) throws PluginException {
        Hashtable<String, PluginConfig> pdtab = new Hashtable<String, PluginConfig>();
        Enumeration<?> plugins = props.propertyNames();
        while (plugins.hasMoreElements()) {
            String plugin = (String)plugins.nextElement();
            String prop = props.getProperty(plugin);
            String cl = null;
            String jar = null;
            String group = null;
            String parameters = null;
            String tag = null;
            String description = null;
            String helptext = null;
            String exampletext = null;
            String delim = String.valueOf(prop.charAt(0));
            StringTokenizer st = new StringTokenizer(prop, delim);
            if (st.hasMoreTokens()) {
                cl = st.nextToken();
                if (cl.equals("-")) {
                    cl = null;
                }
                if (st.hasMoreTokens()) {
                    jar = st.nextToken();
                    if (jar.equals("-")) {
                        jar = null;
                    }
                    if (st.hasMoreTokens() && (group = st.nextToken()).equals("-")) {
                        group = "";
                    }
                    if (st.hasMoreTokens()) {
                        parameters = st.nextToken();
                        if (parameters.equals("-")) {
                            parameters = "";
                        }
                        if (st.hasMoreTokens()) {
                            tag = st.nextToken();
                            if (st.hasMoreTokens()) {
                                description = st.nextToken();
                                if (st.hasMoreTokens()) {
                                    helptext = st.nextToken();
                                    if (helptext.trim().length() == 0 || helptext.equals("-")) {
                                        helptext = DEFAULT_HELP_TEXT;
                                    }
                                    if (st.hasMoreTokens()) {
                                        exampletext = st.nextToken();
                                    }
                                } else {
                                    helptext = DEFAULT_HELP_TEXT;
                                }
                            } else {
                                description = plugin + " calculation";
                            }
                        } else {
                            tag = plugin.toUpperCase();
                        }
                    } else {
                        parameters = "";
                    }
                }
            }
            if (cl == null && jar == null) {
                throw new PluginException("No class for plugin: " + plugin);
            }
            PluginConfig pd = new PluginConfig(plugin, cl, jar, group, parameters, tag, description, helptext, exampletext);
            pdtab.put(plugin.toLowerCase(), pd);
        }
        return pdtab;
    }

    private static void readConfig(Properties props, String filename) throws PluginException {
        InputStream is = BasicEnvironment.getResourceAsStream(PluginManager.class, filename);
        Calculator.readConfig(props, is, filename);
    }

    private static void readConfig(Properties props, InputStream is, String filename) throws PluginException {
        if (is != null) {
            try {
                props.load(new BufferedInputStream(is));
            }
            catch (IOException e) {
                throw new PluginException("Could not load config file: " + filename);
            }
        } else {
            System.err.println("Config file not found: " + filename);
        }
    }

    private static String getServiceHelpText(ServiceDescriptor descriptor) {
        String serviceName = Calculator.mergeNameAndAlias(descriptor.getName(), descriptor.getAlias()).toLowerCase();
        StringBuilder helpText = new StringBuilder("Calculation: " + serviceName.toLowerCase() + "\n");
        helpText.append("\n" + Calculator.removeHTML(descriptor.getDescription()) + "\n");
        helpText.append("\nUsage: \n");
        helpText.append("  cxcalc [general options] [input files/strings] " + serviceName);
        helpText.append("\n[" + serviceName + " options] [input files/strings]\n");
        ArrayList<String> paramlist = new ArrayList<String>();
        for (int i = 0; i < descriptor.getArgumentCount(); ++i) {
            ServiceArgument<?> arg = descriptor.getArgument(i);
            if (arg.getType().equals(Molecule.class)) continue;
            String paramName = Calculator.mergeNameAndAlias(arg.getName(), arg.getAlias());
            String[] type = ("" + arg.getType()).split("\\.");
            StringBuilder param = new StringBuilder(DASH + paramName + " ");
            param.append("\t<" + paramName + " as " + type[type.length - 1] + ">");
            if (arg.getValue() != null) {
                param.append(" (default value: " + arg.getValue() + ")");
            } else if (arg instanceof ChemicalTermsArgument) {
                param.append(" (default: " + ((ChemicalTermsArgument)arg).getExpression() + ")");
            }
            paramlist.add(param.toString());
        }
        if (!paramlist.isEmpty()) {
            helpText.append("\n" + serviceName + " options:\n");
        }
        return Calculator.addParameters(helpText, paramlist).toString();
    }

    private static StringBuilder addParameters(StringBuilder helpText, List<String> params) {
        for (int i = 0; i < params.size(); ++i) {
            helpText.append("  " + params.get(i) + "\n");
        }
        return helpText;
    }

    private static String mergeNameAndAlias(String name, String alias) {
        if (alias != null && !alias.equals(name)) {
            return name + "/" + alias;
        }
        return name;
    }

    private static String getPluginHelpText(PluginConfig pd) {
        StringBuffer s = new StringBuffer();
        s.append(lineSep);
        s.append("Calculator plugin: " + pd.name + "." + lineSep + lineSep);
        s.append(pd.description + lineSep + lineSep);
        s.append("Usage:" + lineSep);
        s.append("  cxcalc [general options] [input files/strings] " + pd.name + lineSep + "[" + pd.name + " options] [input files/strings]" + lineSep);
        s.append(lineSep);
        s.append(pd.name + " options: " + lineSep);
        if (!pd.helptext.equals(DEFAULT_HELP_TEXT)) {
            StringTokenizer st = new StringTokenizer(pd.helptext, ";");
            int n = st.countTokens() + 1;
            String[] left = new String[n];
            String[] right = new String[n];
            left[0] = "-h, --help";
            right[0] = "this help message";
            int i = 1;
            int maxlen = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int k = token.indexOf(61);
                left[i] = token.substring(0, k);
                right[i] = token.substring(k + 1);
                maxlen = Math.max(k, maxlen);
                ++i;
            }
            maxlen += 2;
            StringBuffer spc = new StringBuffer("  ");
            for (int j = 0; j < maxlen; ++j) {
                spc.append(' ');
            }
            String leftfill = new String(spc);
            for (i = 0; i < n; ++i) {
                s.append("  " + left[i]);
                for (int j = maxlen - left[i].length(); j > 0; --j) {
                    s.append(" ");
                }
                int k = 0;
                StringTokenizer rst = new StringTokenizer(right[i], "\n");
                while (rst.hasMoreTokens()) {
                    if (k++ > 0) {
                        s.append(leftfill);
                    }
                    s.append(rst.nextToken() + lineSep);
                }
            }
            s.append(lineSep + "Multiple values for the same parameter should be" + lineSep + "quoted and separated by commas without space" + lineSep + "(e.g.: -t \"v1,v2,v3\" where v1, v2, v3" + lineSep + "are the specified values of parameter t)." + lineSep);
        } else {
            s.append("  " + pd.helptext);
        }
        if (pd.exampletext != null) {
            s.append(lineSep + "Example:" + lineSep);
            s.append("  " + pd.exampletext + lineSep);
        }
        return new String(s);
    }

    private static String getAvailablePluginsHelpText(Hashtable plugins) throws PluginException {
        String group;
        StringBuffer s = new StringBuffer();
        s.append(lineSep + "Available calculations:");
        int size = plugins.size();
        ArrayList names = new ArrayList(size);
        names.addAll(plugins.keySet());
        Collections.sort(names);
        ArrayList<String> groupList = new ArrayList<String>();
        HashMap<String, List<Object>> groupMap = new HashMap<String, List<Object>>();
        groupList.add("");
        groupMap.put("", new ArrayList());
        for (int i = 0; i < size; ++i) {
            String name = (String)names.get(i);
            name = name.toLowerCase();
            PluginConfig pd = (PluginConfig)plugins.get(name);
            group = pd.group;
            if (group.equals("")) {
                ((List)groupMap.get("")).add(name);
                continue;
            }
            if (groupMap.containsKey(group)) {
                ((List)groupMap.get(group)).add(name);
                continue;
            }
            groupList.add(group);
            groupMap.put(group, new ArrayList());
            ((List)groupMap.get(group)).add(name);
        }
        Hashtable<String, List<String>> calcCommands = CalculatorRunner.getCommandGroups();
        for (String cmd : calcCommands.keySet()) {
            if (groupMap.containsKey(cmd)) {
                ((List)groupMap.get(cmd)).addAll((Collection)calcCommands.get(cmd));
                continue;
            }
            groupList.add(cmd);
            groupMap.put(cmd, calcCommands.get(cmd));
        }
        Collections.sort(groupList);
        String lastGroup = null;
        ListIterator it = groupList.listIterator();
        while (lastGroup == null || !lastGroup.startsWith(">")) {
            lastGroup = (String)it.next();
        }
        it.remove();
        groupList.add(lastGroup);
        it = groupList.listIterator();
        while (it.hasNext()) {
            group = (String)it.next();
            if (group.startsWith(">")) {
                s.append(lineSep + group.substring(1) + lineSep + "  ");
            } else {
                s.append(lineSep + group + lineSep + "  ");
            }
            boolean first = true;
            int len = 0;
            ArrayList groupedNames = (ArrayList)groupMap.get(group);
            for (int i = 0; i < groupedNames.size(); ++i) {
                String name = (String)groupedNames.get(i);
                if (first) {
                    first = false;
                } else {
                    len += 2;
                    s.append(", ");
                }
                if ((len += name.length()) > 72) {
                    s.append(lineSep + "  ");
                    len = 2 + name.length();
                }
                s.append(name);
            }
            s.append(lineSep);
        }
        return new String(s);
    }

    private static int[] getPluginNameIndices(String[] args, Hashtable plugins) {
        int[] indices = new int[args.length];
        int k = 0;
        String prevarg = "";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (plugins.containsKey(arg) && (k == 0 && !Calculator.isCxcalcParamWithArg(prevarg) || k > 0 && !prevarg.startsWith("-"))) {
                indices[k++] = i;
            }
            prevarg = arg;
        }
        int[] res = new int[k];
        System.arraycopy(indices, 0, res, 0, k);
        return res;
    }

    private static int[] getPluginAndServiceNameIndices(String[] args, Hashtable plugins, Hashtable services, Hashtable calculators) {
        int[] indices = new int[args.length];
        Hashtable pool = new Hashtable();
        pool.putAll(plugins);
        pool.putAll(services);
        pool.putAll(calculators);
        int k = 0;
        String prevarg = "";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (Calculator.isCommand(pool, arg, k == 0, prevarg)) {
                indices[k++] = i;
            }
            prevarg = arg;
        }
        int[] res = new int[k];
        System.arraycopy(indices, 0, res, 0, k);
        return res;
    }

    private static boolean isCommand(Hashtable commands, String parameter, boolean first, String prev) {
        if (!commands.containsKey(parameter)) {
            return false;
        }
        if (first) {
            return !Calculator.isCxcalcParamWithArg(prev);
        }
        return !prev.startsWith("-");
    }

    private static boolean isCxcalcParamWithArg(String p) {
        return p.equals("-o") || p.equals("--output") || p.equals("-t") || p.equals("--tag") || p.equals("-i") || p.equals("--id") || p.equals("-N") || p.equals("--do-not-display") || p.equals("-T") || p.equals("--generate-training-data");
    }

    private static Properties getPluginParams(String[][] pdata, CLQ clq) throws PluginException {
        Properties params = new Properties();
        if (pdata != null) {
            for (int j = 0; j < pdata.length; ++j) {
                String name1 = pdata[j][0];
                String name2 = pdata[j][1];
                String defval = pdata[j][2];
                String range = "false".equalsIgnoreCase(defval) || "true".equalsIgnoreCase(defval) ? "true|false" : null;
                try {
                    String val;
                    CLQ.Parameter pParam = clq.lookup("-" + name1, DASH + name2, "", 2, false, false, range);
                    String string = pParam != null ? (pParam.size() > 0 ? pParam.getString() : "true") : (val = defval);
                    if (val == null) continue;
                    params.put(name2, val);
                    continue;
                }
                catch (ArgumentException e) {
                    throw new PluginException(e);
                }
            }
        }
        return params;
    }

    private static CalculatorPlugin getPlugin(String cl, String jar) throws PluginException {
        CalculatorPlugin plugin = CalculatorPlugin.create(cl, jar);
        return plugin;
    }

    public static CalculatorPluginOutput getPluginOutput(String name, String arg, boolean spec) throws PluginException {
        PluginConfig pd = (PluginConfig)plugins.get(name = name.toLowerCase());
        if (pd == null) {
            throw new PluginException("No plugin found with name: " + name);
        }
        if (arg == null) {
            arg = "";
        }
        StringTokenizer st = new StringTokenizer(arg, " \t\r\n");
        String[] args = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i++] = st.nextToken();
        }
        CLQ clq = new CLQ(args, null);
        Properties params = Calculator.getPluginParams(pd.getParameterData(), clq);
        CalculatorPlugin plugin = Calculator.getPlugin(pd.cl, pd.jar);
        CalculatorPluginOutput output = Calculator.getPluginOutput(plugin, spec);
        output.setPlugin(plugin);
        output.setSeparator("\t");
        output.setParameters(params);
        return output;
    }

    private static CalculatorPluginOutput getPluginOutput(CalculatorPlugin plugin, boolean spec) throws PluginException {
        Class outputClass = null;
        if (spec) {
            outputClass = plugin.loadClass(plugin.getClass().getName() + "Output");
        }
        if (outputClass == null) {
            outputClass = CalculatorPluginOutput.class;
        }
        try {
            return (CalculatorPluginOutput)outputClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(e);
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        catch (ClassCastException e) {
            throw new PluginException(e);
        }
    }

    public static double getPluginSpecResult(String name, Molecule mol, String arg) throws PluginException {
        PluginConfig pd = (PluginConfig)plugins.get(name = name.toLowerCase());
        if (pd == null) {
            throw new PluginException("No plugin found with name: " + name);
        }
        CalculatorPlugin plugin = Calculator.getPlugin(pd.cl, pd.jar);
        CalculatorPluginOutput output = Calculator.getPluginOutput(plugin, true);
        output.setPlugin(plugin);
        return output.getSpecResult(mol, arg);
    }

    private void write(Molecule mol, String molCountString) throws MolExportException, IOException {
        try {
            this.exporter.write(mol);
        }
        catch (MolExportException e) {
            if (this.ignoreError) {
                System.err.println("Error writing molecule: " + molCountString);
                System.err.println(e);
            }
            throw e;
        }
    }

    public static void runPlugin(CalculatorPlugin plugin, Molecule target) throws PluginException {
        plugin.checkMolecule(target);
        plugin.setMolecule(target);
        if (!plugin.run()) {
            throw new PluginException(plugin.getResultMessage());
        }
    }

    private void run(CLQ calcClq, CLQ[] pluginClqs, String[] pluginNames, CLQ[] serviceClqs, String[] serviceNames, CLQ[] calculatorCLqs, String[] calculatorNames) throws Exception {
        MolImporter importer;
        CLQ clq;
        int i;
        String structure;
        CLQ.Parameter pIdTag;
        int i2;
        this.pluginNames = pluginNames;
        int n = pluginClqs.length;
        this.os = null;
        CLQ.Parameter pNo = calcClq.lookup("-N", "--do-not-display", "", 2, false, false);
        this.displayID = true;
        this.displayHeader = true;
        if (pNo != null) {
            String str = pNo.getString().toLowerCase();
            if (str.indexOf("i") != -1) {
                this.displayID = false;
            }
            if (str.indexOf("h") != -1) {
                this.displayHeader = false;
            }
        }
        this.singleTestMode |= calcClq.lookup("-s", "--single-test-mode", "", 1, false, false) != null;
        this.singleTestMode |= serviceNames.length > 0 || calculatorNames.length > 0;
        this.sdfOutput = calcClq.lookup("-S", "--sdf-output", "", 1, false, false) != null;
        boolean bl = this.mrvOutput = calcClq.lookup("-M", "--mrv-output", "", 1, false, false) != null;
        if (this.sdfOutput && this.mrvOutput) {
            System.err.println("Options --sdf-output and --mrv-output are mutually exclusive.");
            return;
        }
        this.onlyPluginOutput = !this.sdfOutput && !this.mrvOutput;
        this.verbose = calcClq.lookup("-v", "--verbose", "", 1, false, false) != null;
        this.ignoreError = calcClq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        this.ignoreError |= logger != null;
        CLQ.Parameter pTag = calcClq.lookup("-t", "--tag", "", 2, false, false);
        this.tags = new String[n + serviceNames.length + calculatorNames.length];
        if (pTag != null) {
            String tag = pTag.getString();
            if (n == 1) {
                this.tags[0] = tag;
            } else {
                for (i2 = 0; i2 < n; ++i2) {
                    PluginConfig pd = (PluginConfig)plugins.get(pluginNames[i2]);
                    this.tags[i2] = tag + pd.tag;
                }
                for (i2 = 0; i2 < serviceNames.length; ++i2) {
                    this.tags[i2 + n] = serviceNames[i2];
                }
                for (i2 = 0; i2 < calculatorNames.length; ++i2) {
                    this.tags[i2 + n + serviceNames.length] = calculatorNames[i2];
                }
            }
        } else {
            int i3;
            for (i3 = 0; i3 < n; ++i3) {
                PluginConfig pd = (PluginConfig)plugins.get(pluginNames[i3]);
                this.tags[i3] = pd.tag;
            }
            for (i3 = 0; i3 < serviceNames.length; ++i3) {
                this.tags[i3 + n] = serviceNames[i3];
            }
            for (i3 = 0; i3 < calculatorNames.length; ++i3) {
                this.tags[i3 + n + serviceNames.length] = calculatorNames[i3];
            }
        }
        if ((pIdTag = calcClq.lookup("-i", "--id", "", 2, false, false)) != null) {
            this.idTagOrFormat = pIdTag.getString();
        }
        this.separator = this.onlyPluginOutput ? "\t" : lineSep;
        this.pOut = calcClq.lookup("-o", "--output", "", 2, false, false);
        this.os = this.pOut != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.pOut.getString()))) : new PrintStream(new BufferedOutputStream(System.out));
        this.configs = new PluginConfig[n];
        this.params = new Properties[n];
        for (i2 = 0; i2 < n; ++i2) {
            this.configs[i2] = (PluginConfig)plugins.get(pluginNames[i2]);
            this.params[i2] = Calculator.getPluginParams(this.configs[i2].getParameterData(), pluginClqs[i2]);
            String fmt = this.params[i2].getProperty("format");
            if (fmt == null) continue;
            if (this.format == null) {
                this.format = fmt;
                continue;
            }
            throw new PluginException("More than one calculations with molecular output is not allowed.");
        }
        Vector<MolImporter> v = new Vector<MolImporter>();
        int k = 0;
        CLQ clq2 = calcClq;
        while (clq2 != null) {
            structure = null;
            while ((structure = clq2.notUsed()) != null) {
                MolImporter importer2 = MFileFormatUtil.isURLOrFileName(structure) ? new MolImporter(structure) : new MolImporter(new ByteArrayInputStream(structure.getBytes()));
                v.addElement(importer2);
            }
            clq2 = k < pluginClqs.length ? pluginClqs[k++] : null;
        }
        this.serviceParams = new Properties[serviceNames.length];
        this.serviceNames = serviceNames;
        for (i = 0; i < this.serviceParams.length; ++i) {
            this.serviceParams[i] = this.getServiceParams(serviceNames[i], serviceClqs[i]);
        }
        for (i = 0; i < serviceNames.length; ++i) {
            structure = null;
            clq = serviceClqs[i];
            while ((structure = clq.notUsed()) != null) {
                importer = MFileFormatUtil.isURLOrFileName(structure) ? new MolImporter(structure) : new MolImporter(new ByteArrayInputStream(structure.getBytes()));
                v.addElement(importer);
            }
        }
        this.calculatorParams = new Properties[calculatorNames.length];
        this.calculatorCommands = calculatorNames;
        for (i = 0; i < this.calculatorParams.length; ++i) {
            this.calculatorParams[i] = this.getCalculatorParams(calculatorNames[i], calculatorCLqs[i]);
        }
        for (i = 0; i < calculatorNames.length; ++i) {
            structure = null;
            clq = calculatorCLqs[i];
            while ((structure = clq.notUsed()) != null) {
                importer = MFileFormatUtil.isURLOrFileName(structure) ? new MolImporter(structure) : new MolImporter(new ByteArrayInputStream(structure.getBytes()));
                v.addElement(importer);
            }
        }
        MolImporter[] importers = null;
        if (v.isEmpty()) {
            importers = new MolImporter[]{new MolImporter(System.in)};
        } else {
            int size = v.size();
            importers = new MolImporter[size];
            for (int i4 = 0; i4 < size; ++i4) {
                importers[i4] = (MolImporter)v.elementAt(i4);
            }
        }
        this.run(importers);
    }

    private Properties getServiceParams(String serviceName, CLQ parameters) throws ArgumentException {
        ServiceArgument<?> val;
        CLQ.Parameter pParam;
        String param;
        ServiceArgument<?> arg;
        int i;
        Properties params = new Properties();
        ServiceDescriptor descriptor = services.get(serviceName);
        for (i = 0; i < descriptor.getArgumentCount(); ++i) {
            arg = descriptor.getArgument(i);
            param = arg.getAlias();
            pParam = parameters.lookup("-" + param, DASH + param, "", 2, false, false);
            if (pParam == null) continue;
            val = ServiceArgument.createConstantFromString(pParam.getString(), arg.getType());
            val.setName(param);
            params.put(DASH + arg.getName(), val);
        }
        for (i = 0; i < descriptor.getArgumentCount(); ++i) {
            arg = descriptor.getArgument(i);
            param = arg.getName();
            pParam = parameters.lookup("-" + param, DASH + param, "", 2, false, false);
            if (pParam == null) continue;
            val = ServiceArgument.createConstantFromString(pParam.getString(), arg.getType());
            val.setName(param);
            params.put(DASH + param, val);
        }
        return params;
    }

    private Properties getCalculatorParams(String calculatorName, CLQ paramaters) throws ArgumentException {
        Properties params = new Properties();
        CalculatorRunner.CalculatorParameter[] paramList = CalculatorRunner.getAllParameter(calculators.get(calculatorName), calculatorName);
        for (int i = 0; i < paramList.length; ++i) {
            int paramCount = paramList[i].getParameterCount();
            CLQ.Parameter pParam = null;
            String value = null;
            pParam = this.lookup(paramaters, paramList[i], 2);
            if (pParam != null) {
                value = pParam.getString();
            } else if (paramCount < 2 && (pParam = this.lookup(paramaters, paramList[i], paramCount)) != null) {
                value = Boolean.TRUE.toString();
            }
            if (pParam == null) continue;
            params.put(DASH + paramList[i].getName(), value);
        }
        return params;
    }

    private CLQ.Parameter lookup(CLQ parameters, CalculatorRunner.CalculatorParameter toLookup, int paramCount) throws ArgumentException {
        CLQ.Parameter pParam = parameters.lookup(DASH + toLookup.getName(), DASH + toLookup.getName(), paramCount, false, false);
        if (pParam == null) {
            pParam = parameters.lookup("-" + toLookup.getShortname(), "-" + toLookup.getShortname(), paramCount, false, false);
        }
        return pParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(MolImporter[] importers) throws Exception {
        if (this.singleTestMode) {
            this.runSingle(importers);
            return;
        }
        CalculatorInputProducer inputProducer = new CalculatorInputProducer(3 * CPU_COUNT, importers);
        CalculatorWorkUnitFactory workUnitFactory = new CalculatorWorkUnitFactory(this.configs.length);
        int processorType = CPU_COUNT == 1 || !inputProducer.isMultiThreadedRunEnabled() ? 2 : 1;
        ConcurrentProcessor processor = ConcurrentProcessors.create(processorType, inputProducer, workUnitFactory);
        processor.start();
        try {
            while (processor.hasNext()) {
                CalculatorPlugin[] plugins = this.consume(processor.getNext());
                inputProducer.reuse(plugins);
            }
        }
        catch (Throwable throwable) {
            processor.cleanup();
            for (int i = 0; i < importers.length; ++i) {
                importers[i].close();
            }
            this.closeOutput(DIRECT_RUN ? 1 : 2);
            throw throwable;
        }
        processor.cleanup();
        for (int i = 0; i < importers.length; ++i) {
            importers[i].close();
        }
        this.closeOutput(DIRECT_RUN ? 1 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runSingle(MolImporter[] importers) throws Exception {
        plugins = new CalculatorPlugin[this.configs.length];
        this.outputs = new CalculatorPluginOutput[this.configs.length];
        for (i = 0; i < this.configs.length; ++i) {
            this.outputs[i] = this.getPluginOutput(i);
            plugins[i] = this.outputs[i].getPlugin();
        }
        results = new Object[plugins.length + 1 + this.serviceNames.length + this.calculatorCommands.length];
        molProducer = new CalculatorMolInputProducer(importers);
        while (true) {
            block28: {
                block27: {
                    try {
                        if (!molProducer.hasNext()) break;
                        target = (Molecule)molProducer.getNext();
                        for (i = 0; i < plugins.length; ++i) {
                            try {
                                start = System.currentTimeMillis();
                                Calculator.runPlugin(plugins[i], target);
                                results[i] = plugins[i];
                                finish = System.currentTimeMillis();
                                Calculator.logger.log(target, this.configs[i].name, finish - start);
                                continue;
                            }
                            catch (Exception e) {
                                results[i] = new CalculatorPluginCachedResults(this.outputs[i].getHeader(), null, null, null, plugins[i].getResultMessage(), plugins[i].getRemark(), new PluginExecutionException(plugins[i], (Throwable)e), false);
                            }
                        }
                        block13: for (i = 0; i < this.serviceNames.length; ++i) {
                            try {
                                start = System.currentTimeMillis();
                                descriptor = Calculator.services.get(this.serviceNames[i]);
                                if (!descriptor.isAvailable()) {
                                    errorMsg = "Unsupported service:\n" + Calculator.removeHTML(descriptor.getDescription());
                                    Calculator.logger.log(target, this.serviceNames[i], new String[]{errorMsg});
                                    break block27;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception e) {
                                Calculator.logger.log(target, this.serviceNames[i], e);
                            }
lbl35:
                            // 2 sources

                        }
                        break block28;
                    }
                    catch (Throwable var17_29) {
                        for (i = 0; i < importers.length; ++i) {
                            importers[i].close();
                        }
                        this.closeOutput(Calculator.DIRECT_RUN != false ? 1 : 2);
                        throw var17_29;
                    }
                }
                for (i = 0; i < importers.length; ++i) {
                    importers[i].close();
                }
                this.closeOutput(Calculator.DIRECT_RUN != false ? 1 : 2);
                return;
lbl-1000:
                // 1 sources

                {
                    args = descriptor.getArguments();
                    parameters = new ArrayList<Object>();
                    for (ServiceArgument<?> arg : args) {
                        if (arg.getType().equals(Molecule.class)) {
                            if (arg instanceof ChemicalTermsArgument) {
                                parameters.add(((ChemicalTermsArgument)arg).evaluate(target));
                                continue;
                            }
                            parameters.add(target);
                            continue;
                        }
                        name = "--" + arg.getName();
                        sArg = (ServiceArgument)this.serviceParams[i].get(name);
                        if (sArg != null) {
                            val = sArg.getValue();
                            parameters.add(val);
                            continue;
                        }
                        if (arg instanceof ChemicalTermsArgument) {
                            parameters.add(((ChemicalTermsArgument)arg).evaluate(target));
                            continue;
                        }
                        if (arg.getValue() == null) throw new ServiceException("Invalid method call.\n" + Calculator.getServiceHelpText(descriptor));
                        parameters.add(arg.getValue());
                    }
                    serviceHandler = descriptor.getServiceHandler();
                    result = serviceHandler.callService(descriptor, parameters.toArray());
                    parameters.clear();
                    parameters.add(this.serviceNames[i]);
                    parameters.add(result);
                    results[plugins.length + i] = parameters;
                    finish = System.currentTimeMillis();
                    Calculator.logger.log(target, this.serviceNames[i], finish - start);
                    ** continue;
                }
            }
            for (i = 0; i < this.calculatorCommands.length; ++i) {
                try {
                    start = System.currentTimeMillis();
                    runner = new CalculatorRunner();
                    p = this.calculatorParams[i];
                    for (Object name : p.keySet()) {
                        runner.setParameter((String)name, (String)p.get(name));
                    }
                    result = new ArrayList<Object>();
                    result.add(runner.getHeader(this.calculatorCommands[i], Calculator.calculators.get(this.calculatorCommands[i])));
                    result.add(runner.runCommand(this.calculatorCommands[i], Calculator.calculators.get(this.calculatorCommands[i]), Calculator.logger, new Molecule[]{target}));
                    results[plugins.length + this.serviceNames.length + i] = result;
                    if (!runner.needHeader()) {
                        this.displayHeader = false;
                        this.displayID = false;
                    }
                    finish = System.currentTimeMillis();
                    Calculator.logger.log(target, this.calculatorCommands[i], finish - start);
                    continue;
                }
                catch (Exception e) {
                    Calculator.logger.log(target, this.calculatorCommands[i], e);
                }
            }
            results[results.length - 1] = target;
            this.consume(results);
        }
        for (i = 0; i < importers.length; ++i) {
            importers[i].close();
        }
        this.closeOutput(Calculator.DIRECT_RUN != false ? 1 : 2);
    }

    private static String removeHTML(String text) {
        return text.replaceAll("\\<\\\\*[bB][rR]>", "\n").replaceAll("<[^<]*>", "");
    }

    private CalculatorPluginOutput getPluginOutput(int i) throws PluginException, IOException {
        CalculatorPlugin plugin = CalculatorPlugin.create(this.configs[i].cl, this.configs[i].jar);
        CalculatorPluginOutput output = Calculator.getPluginOutput(plugin, !this.sdfOutput);
        output.setPlugin(plugin);
        output.setParameters(this.params[i]);
        output.setSeparator(this.separator);
        output.setOutputStream(this.os);
        plugin.setParameters(output.getPluginParameters());
        output.setOutputParameters(plugin.getResultTypes());
        if (output.isMolecular() || output.isStreamOutput()) {
            this.displayID = false;
            this.displayHeader = false;
        }
        return output;
    }

    private void initOutput(CalculatorResultAccess[] cra) throws Exception {
        String fmt = null;
        for (int i = 0; i < cra.length && fmt == null; ++i) {
            if (!(cra[i] instanceof ServiceOutput) || !this.onlyPluginOutput) continue;
            fmt = ((ServiceOutput)cra[i]).getResultFormat();
        }
        if (fmt == null) {
            fmt = this.onlyPluginOutput ? this.format : (this.sdfOutput ? "sdf" : "mrv");
        }
        MolExporter molExporter = this.exporter = fmt != null ? new MolExporter(this.os, fmt) : null;
        if (this.onlyPluginOutput && this.displayHeader) {
            StringBuffer s = new StringBuffer();
            if (this.displayID) {
                s.append(this.idTagOrFormat != null ? this.idTagOrFormat : "id");
                s.append(this.separator);
            }
            for (int i = 0; i < cra.length; ++i) {
                if (i > 0) {
                    s.append(this.separator);
                }
                String header = cra[i].getHeader();
                s.append(header);
            }
            this.os.println(new String(s));
        }
        this.outputInited = true;
    }

    private void closeOutput(int opts) throws Exception {
        if (this.verbose && this.errors.length() > 0) {
            System.err.println();
            System.err.println("Calculation warnings:");
            System.err.println(new String(this.errors));
        }
        for (int i = 0; i < this.outputs.length; ++i) {
            if (this.outputs[i] == null) continue;
            this.outputs[i].close(opts);
        }
        if (this.exporter != null) {
            this.exporter.close(opts);
        } else if (this.onlyPluginOutput) {
            this.os.flush();
            if (this.pOut != null && opts == 1) {
                this.os.close();
            }
        }
    }

    private String getMolID(Molecule target) {
        String id = null;
        if (this.idTagOrFormat != null) {
            id = target.getProperty(this.idTagOrFormat);
            if (id == null) {
                try {
                    target.setProperty(MOLCOUNT_PROP, null);
                    id = target.exportToFormat(this.idTagOrFormat);
                }
                catch (MolExportException e) {
                    id = target.getProperty(MOLCOUNT_PROP);
                    this.errors.append(lineSep + id + ":\tCould not determine molecule ID - " + e);
                    logger.log(target, null, "Could not determine molecule ID");
                }
            }
        } else {
            id = target.getProperty(MOLCOUNT_PROP);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalculatorPlugin[] consume(Object obj) throws Exception {
        int i;
        Object[] results = (Object[])obj;
        int n = results.length - 1;
        Molecule target = (Molecule)results[n];
        CalculatorPlugin[] plugins = new CalculatorPlugin[n];
        CalculatorResultAccess[] cra = new CalculatorResultAccess[n];
        for (i = 0; i < n; ++i) {
            if (results[i] instanceof CalculatorPlugin) {
                plugins[i] = (CalculatorPlugin)results[i];
                this.outputs[i].setPlugin(plugins[i]);
                cra[i] = this.outputs[i];
                continue;
            }
            if (results[i] instanceof List) {
                String serviceName = (String)((List)results[i]).remove(0);
                Object result = ((List)results[i]).remove(0);
                cra[i] = new ServiceOutput(serviceName, result);
                continue;
            }
            cra[i] = (CalculatorResultAccess)results[i];
            if (!(cra[i].getThrowable() instanceof PluginExecutionException)) continue;
            PluginExecutionException e = (PluginExecutionException)cra[i].getThrowable();
            plugins[i] = e.getPlugin();
        }
        try {
            if (!this.outputInited) {
                this.initOutput(cra);
            }
            if (this.onlyPluginOutput) {
                this.outputOnlyPlugin(cra, target);
            } else if (this.sdfOutput) {
                this.outputSDF(cra, target);
            } else {
                this.outputMRV(cra, target);
            }
        }
        finally {
            for (i = 0; i < n; ++i) {
                if (i >= this.outputs.length || this.outputs[i] == null) continue;
                if (!this.singleTestMode) {
                    this.outputs[i].setPlugin(null);
                }
                this.outputs[i].setThrowable(null);
            }
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputOnlyPlugin(CalculatorResultAccess[] cra, Molecule target) throws Exception {
        String result = null;
        StringBuffer s = new StringBuffer();
        if (this.displayID) {
            s.append(this.getMolID(target));
            s.append(this.separator);
        }
        try {
            for (int i = 0; i < cra.length; ++i) {
                if (i > 0) {
                    s.append(this.separator);
                }
                String name = null;
                name = i < this.pluginNames.length ? this.pluginNames[i] : (i < this.pluginNames.length + this.serviceNames.length ? this.serviceNames[i - this.pluginNames.length] : this.calculatorCommands[i - (this.serviceNames.length + this.pluginNames.length)]);
                try {
                    Calculator.checkResult(cra[i]);
                    if (this.exporter != null) {
                        boolean cleanable = this.exporter.isCleanable();
                        Molecule[] mols = cra[i].getResultMolecules(target);
                        if (mols != null) {
                            for (Molecule mol : mols) {
                                if (cleanable && mol.getDim() == 0) {
                                    mol.clean(2, null);
                                }
                                try {
                                    this.exporter.write(mol);
                                }
                                catch (IOException e) {
                                    throw new PluginException(e);
                                }
                            }
                        }
                    }
                    result = cra[i].getResult(target);
                    this.outputRemarks(target, name, cra[i]);
                }
                catch (PluginException e) {
                    this.outputPluginError(target, name, e);
                    continue;
                }
                catch (Throwable e) {
                    this.outputError(target, name, e);
                    if (this.ignoreError) {
                        result = this.pluginNames[i] + ":FAILED";
                    }
                    throw new ExecutionException(e);
                }
                s.append(result);
            }
        }
        finally {
            if (s.length() > 0) {
                this.os.println(new String(s));
            }
            if (this.pOut == null) {
                this.os.flush();
            }
        }
    }

    private void outputSDF(CalculatorResultAccess[] cra, Molecule target) throws Exception {
        String result = null;
        for (int i = 0; i < cra.length; ++i) {
            String name = i < this.pluginNames.length ? this.pluginNames[i] : (i < this.serviceNames.length + this.pluginNames.length ? this.serviceNames[i - this.pluginNames.length] : this.calculatorCommands[i - this.pluginNames.length - this.serviceNames.length]);
            try {
                Calculator.checkResult(cra[i]);
                result = cra[i].getResult(target);
                this.outputRemarks(target, name, cra[i]);
            }
            catch (PluginException e) {
                this.outputPluginError(target, name, e);
                continue;
            }
            catch (Throwable e) {
                this.outputError(target, name, e);
                if (this.ignoreError) {
                    result = "FAILED";
                }
                throw new ExecutionException(e);
            }
            String value = target.getProperty(this.tags[i]);
            value = value == null ? result : value + "\n" + result;
            target.setProperty(this.tags[i], value);
        }
        if (target.getDim() == 0) {
            target.clean(2, null);
        }
        String molCountString = target.getProperty(MOLCOUNT_PROP);
        target.setProperty(MOLCOUNT_PROP, null);
        this.write(target, molCountString);
    }

    private void outputMRV(CalculatorResultAccess[] cra, Molecule target) throws Exception {
        for (int i = 0; i < cra.length; ++i) {
            String name = i < this.pluginNames.length ? this.pluginNames[i] : (i < this.serviceNames.length + this.pluginNames.length ? this.serviceNames[i - this.pluginNames.length] : this.calculatorCommands[i - this.pluginNames.length - this.serviceNames.length]);
            try {
                Calculator.checkResult(cra[i]);
                Molecule rmol = cra[i].getResultMolecule(target);
                if (rmol != null) {
                    if (rmol.getDim() == 0) {
                        rmol.clean(2, null);
                    }
                    this.exporter.write(rmol);
                } else {
                    this.errors.append(lineSep + this.getMolID(target) + "\t" + name + ": " + "no result molecule available");
                    logger.log(target, name, "no result molecule available");
                }
                this.outputRemarks(target, name, cra[i]);
                continue;
            }
            catch (PluginException e) {
                this.outputPluginError(target, name, e);
                continue;
            }
            catch (Throwable e) {
                this.outputError(target, name, e);
                if (this.ignoreError) continue;
                throw new ExecutionException(e);
            }
        }
    }

    private static void checkResult(CalculatorResultAccess access) throws Throwable {
        Throwable e = access.getThrowable();
        if (e != null) {
            throw e instanceof PluginExecutionException ? e.getCause() : e;
        }
    }

    private void outputPluginError(Molecule target, String pluginName, PluginException e) {
        this.errors.append(lineSep + this.getMolID(target) + "\t" + pluginName + ": " + e.getMessage());
        logger.log(target, pluginName, e);
    }

    private void outputError(Molecule target, String pluginName, Throwable e) throws Exception {
        String id = this.getMolID(target);
        if (this.ignoreError) {
            this.errors.append(lineSep + id + "\t" + pluginName + ": " + e.getMessage());
        }
        logger.log(target, pluginName, e);
    }

    private void outputRemarks(Molecule target, String pluginName, CalculatorResultAccess access) {
        String remark;
        String id = this.getMolID(target);
        if (!access.isOK()) {
            this.errors.append(lineSep + id + ":\t" + pluginName + ": " + access.getResultMessage());
            logger.log(target, pluginName, access.getResultMessage());
        }
        if ((remark = access.getRemark()) != null) {
            this.errors.append(lineSep + id + ":\t" + pluginName + ": " + remark);
            logger.log(target, pluginName, remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                System.out.println(helptext + Calculator.getAvailablePluginsHelpText(plugins) + examplestext);
                return;
            }
            CLQ clq = new CLQ(args, null);
            int[] indices = Calculator.getPluginAndServiceNameIndices(args, plugins, services, calculators);
            int[] p = indices;
            int n = p.length;
            if (n == 0) {
                if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                    System.out.println(helptext + Calculator.getAvailablePluginsHelpText(plugins) + examplestext);
                } else {
                    if (clq.lookup("-T", "--generate-training-data", "", 1, false, false) != null) {
                        System.err.println("Use \"cxtrain\" command line application or Instant JChem for prediction training.");
                        return;
                    }
                    System.err.println("Calculation name is not found.");
                    System.err.println(Calculator.getAvailablePluginsHelpText(plugins));
                }
                return;
            }
            int argLen = p[0];
            String[] calcArgs = new String[argLen];
            System.arraycopy(args, 0, calcArgs, 0, argLen);
            String[] commandNames = new String[n];
            String[][] commandArgs = new String[n][];
            Calculator.collectCommands(args, indices, n, commandNames, commandArgs);
            ArrayList<String> pNames = new ArrayList<String>();
            ArrayList<String> sNames = new ArrayList<String>();
            ArrayList<String> cNames = new ArrayList<String>();
            ArrayList<String[]> pArgs = new ArrayList<String[]>();
            ArrayList<String[]> sArgs = new ArrayList<String[]>();
            ArrayList<String[]> cArgs = new ArrayList<String[]>();
            Calculator.splitCommands(commandNames, commandArgs, pNames, sNames, cNames, pArgs, sArgs, cArgs);
            String[] pluginNames = pNames.toArray(new String[0]);
            String[] serviceNames = sNames.toArray(new String[0]);
            String[] calculatorNames = cNames.toArray(new String[0]);
            String[][] pluginArgs = (String[][])pArgs.toArray((T[])new String[0][]);
            String[][] serviceArgs = (String[][])sArgs.toArray((T[])new String[0][]);
            String[][] calculatorArgs = (String[][])cArgs.toArray((T[])new String[0][]);
            n = pluginNames.length;
            CLQ calcClq = new CLQ(calcArgs, null);
            CLQ[] pluginClqs = Calculator.createCLQs(pluginNames, pluginArgs);
            CLQ[] serviceClqs = Calculator.createCLQs(serviceNames, serviceArgs);
            CLQ[] calculatorCLqs = Calculator.createCLQs(calculatorNames, calculatorArgs);
            if (pluginClqs == null || serviceClqs == null || calculatorCLqs == null) {
                return;
            }
            Calculator calculator = new Calculator();
            logger = Calculator.createLogger(calcClq, args, calculator);
            try {
                calculator.run(calcClq, pluginClqs, pluginNames, serviceClqs, serviceNames, calculatorCLqs, calculatorNames);
            }
            catch (ServiceException se) {
                System.err.println(se.getMessage());
            }
            catch (PluginException e) {
                System.err.println(e);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
        }
        finally {
            logger.close();
        }
    }

    private static CalculatorLogger createLogger(CLQ clq, String[] args, Calculator calculator) throws ArgumentException {
        String time;
        CLQ.Parameter logFile = clq.lookup("--log", "--log", 2, false, false);
        CLQ.Parameter logLevel = clq.lookup("--log-level", "--log-level", 2, false, false);
        CLQ.Parameter logOptions = clq.lookup("--log-options", "--log-options", 2, false, false);
        String level = logLevel == null ? CalculatorLogger.Level.ERROR.toString() : logLevel.getString();
        String[] options = logOptions == null ? null : logOptions.getString().split(",");
        String format2 = Calculator.getOption(options, "format");
        CalculatorLogger logger = logFile == null ? new CalculatorLogger(System.err, format2.length() > 0 ? format2 : "smiles") : new CalculatorLogger(logFile.getString(), format2.length() > 0 ? format2 : "sdf");
        logger.setCommandLineParameters(args);
        logger.setLogLevel(level);
        if (Calculator.getOption(options, "time").length() > 0) {
            logger.setTimeLogging(true);
            calculator.singleTestMode = true;
        }
        if ((time = Calculator.getOption(options, "timelimit")).length() > 0) {
            int limit = 0;
            try {
                limit = Integer.parseInt(time);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            logger.setTimeLimit(limit);
        }
        return logger;
    }

    private static String getOption(String[] optionList, String key) {
        if (optionList == null) {
            return "";
        }
        for (int i = 0; i < optionList.length; ++i) {
            if (!optionList[i].startsWith(key.toLowerCase())) continue;
            int index = optionList[i].indexOf(61);
            if (index > 0 && index < optionList[i].length()) {
                return optionList[i].substring(index + 1);
            }
            return "true";
        }
        return "";
    }

    private static CLQ[] createCLQs(String[] names, String[][] args) throws ArgumentException {
        int n = names.length;
        CLQ[] clqs = new CLQ[n];
        for (int i = 0; i < n; ++i) {
            clqs[i] = new CLQ(args[i], null);
            if (clqs[i].lookup("-h", "--help", "", 1, false, false) == null) continue;
            PluginConfig pd = (PluginConfig)plugins.get(names[i]);
            if (pd != null) {
                System.out.println(Calculator.getPluginHelpText(pd));
            } else if (services.get(names[i]) != null) {
                System.out.println(Calculator.getServiceHelpText(services.get(names[i])));
            } else if (calculators.get(names[i]) != null) {
                System.out.println(CalculatorRunner.getHelpText(calculators.get(names[i]), names[i]));
            }
            clqs = null;
        }
        return clqs;
    }

    private static void splitCommands(String[] commandNames, String[][] commandArgs, List<String> pNames, List<String> sNames, List<String> cNames, List<String[]> pArgs, List<String[]> sArgs, List<String[]> cArgs) {
        for (int i = 0; i < commandNames.length; ++i) {
            if (plugins.containsKey(commandNames[i].toLowerCase())) {
                pNames.add(commandNames[i]);
                pArgs.add(commandArgs[i]);
                continue;
            }
            if (calculators.containsKey(commandNames[i].toLowerCase())) {
                cNames.add(commandNames[i]);
                cArgs.add(commandArgs[i]);
                continue;
            }
            sNames.add(commandNames[i]);
            sArgs.add(commandArgs[i]);
        }
    }

    private static void collectCommands(String[] args, int[] p, int n, String[] pluginNames, String[][] pluginArgs) {
        for (int i = 0; i < n; ++i) {
            pluginNames[i] = args[p[i]].toLowerCase();
            int len = i < n - 1 ? p[i + 1] - p[i] - 1 : args.length - p[i] - 1;
            pluginArgs[i] = new String[len];
            System.arraycopy(args, p[i] + 1, pluginArgs[i], 0, len);
        }
    }

    static /* synthetic */ CalculatorPluginOutput[] access$102(Calculator x0, CalculatorPluginOutput[] x1) {
        x0.outputs = x1;
        return x1;
    }

    static {
        try {
            plugins = Calculator.readPluginConfig();
        }
        catch (PluginException e) {
            System.err.println("Could not plugin configuration for Calculator: " + e);
            plugins = new Hashtable();
        }
        services = Calculator.readServiceConfig();
        calculators = CalculatorRunner.getAllCommands();
        logger = new CalculatorLogger();
    }

    class CalculatorWorkUnitFactory
    implements WorkUnitFactory {
        private int count = 0;

        public CalculatorWorkUnitFactory(int count) {
            this.count = count;
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            WorkUnit[] workUnits = new WorkUnit[this.count + 1];
            for (int i = 0; i < this.count; ++i) {
                workUnits[i] = Calculator.this.outputs[i] == null ? new DefaultPluginWorkUnit(Calculator.this.getPluginOutput(i), Calculator.this.onlyPluginOutput || Calculator.this.sdfOutput) : new ReusablePluginWorkUnit();
            }
            workUnits[this.count] = new SimpleWorkUnit();
            return new CalculatorWorkUnit(workUnits);
        }
    }

    static class SimpleWorkUnit
    implements WorkUnit {
        private Object input = null;

        SimpleWorkUnit() {
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            this.input = obj;
        }

        public Object call() throws Exception {
            return this.input;
        }
    }

    static class CalculatorWorkUnit
    extends CompositeWorkUnit {
        public CalculatorWorkUnit(WorkUnit[] workUnits) {
            super(workUnits);
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            Object[] inputs = (Object[])obj;
            int length = this.workUnits.length - 1;
            Object target = inputs[length];
            for (int i = 0; i < length; ++i) {
                if (inputs[i] != null) {
                    this.workUnits[i].setInput(new Object[]{inputs[i], target});
                    continue;
                }
                this.workUnits[i].setInput(target);
            }
            this.workUnits[length].setInput(target);
        }
    }

    class PluginInputProducer
    extends ReusableInputProducer {
        private String cl;
        private String jar;
        private Properties params;

        public PluginInputProducer(Object[] inputs, String cl, String jar, Properties params) {
            super(inputs);
            this.cl = null;
            this.jar = null;
            this.params = null;
            this.cl = cl;
            this.jar = jar;
            this.params = params;
        }

        @Override
        protected Object createInput() {
            try {
                CalculatorPlugin plugin = CalculatorPlugin.create(this.cl, this.jar);
                plugin.setParameters(this.params);
                return plugin;
            }
            catch (PluginException e) {
                return null;
            }
        }
    }

    class NullInputProducer
    implements InputProducer {
        NullInputProducer() {
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            return true;
        }

        @Override
        public Object getNext() throws InterruptedException, ExecutionException {
            return null;
        }
    }

    class CalculatorInputProducer
    extends CompositeInputProducer {
        private boolean multiThreadedRunEnabled = true;

        CalculatorInputProducer(int n, MolImporter[] importers) throws PluginException, IOException {
            Calculator.access$102(Calculator.this, new CalculatorPluginOutput[Calculator.this.configs.length]);
            InputProducer[] inputProducers = new InputProducer[Calculator.this.configs.length + 1];
            for (int i = 0; i < Calculator.this.configs.length; ++i) {
                CalculatorPlugin plugin = CalculatorPlugin.create(((Calculator)Calculator.this).configs[i].cl, ((Calculator)Calculator.this).configs[i].jar);
                if (plugin.canRepeat()) {
                    inputProducers[i] = new NullInputProducer();
                    ((Calculator)Calculator.this).outputs[i] = null;
                } else {
                    Object[] plugins = new CalculatorPlugin[n];
                    plugins[0] = plugin;
                    for (int j = 1; j < n; ++j) {
                        plugins[j] = CalculatorPlugin.create(((Calculator)Calculator.this).configs[i].cl, ((Calculator)Calculator.this).configs[i].jar);
                    }
                    ((Calculator)Calculator.this).outputs[i] = Calculator.getPluginOutput(plugin, !Calculator.this.sdfOutput);
                    Calculator.this.outputs[i].setParameters(Calculator.this.params[i]);
                    Properties pluginParams = Calculator.this.outputs[i].getPluginParameters();
                    Calculator.this.outputs[i].setSeparator(Calculator.this.separator);
                    Calculator.this.outputs[i].setOutputStream(Calculator.this.os);
                    for (int j = 0; j < n; ++j) {
                        plugins[j].setParameters(pluginParams);
                    }
                    Calculator.this.outputs[i].setOutputParameters(plugin.getResultTypes());
                    if (Calculator.this.outputs[i].isMolecular() || Calculator.this.outputs[i].isStreamOutput()) {
                        Calculator.this.displayID = false;
                        Calculator.this.displayHeader = false;
                    }
                    inputProducers[i] = new PluginInputProducer(plugins, ((Calculator)Calculator.this).configs[i].cl, ((Calculator)Calculator.this).configs[i].jar, pluginParams);
                    Calculator.this.format = null;
                }
                this.multiThreadedRunEnabled = this.multiThreadedRunEnabled && plugin.isMultiThreadedRunEnabled();
            }
            inputProducers[((Calculator)Calculator.this).configs.length] = new CalculatorMolInputProducer(importers);
            this.setInputProducers(inputProducers);
        }

        public void reuse(CalculatorPlugin[] plugins) {
            for (int i = 0; i < plugins.length; ++i) {
                if (!(this.inputProducers[i] instanceof PluginInputProducer)) continue;
                ((PluginInputProducer)this.inputProducers[i]).reuse(plugins[i]);
            }
        }

        boolean isMultiThreadedRunEnabled() {
            return this.multiThreadedRunEnabled;
        }
    }

    class CalculatorMolInputProducer
    extends MolInputProducer {
        private int inMolCount;

        public CalculatorMolInputProducer(MolImporter[] importers) {
            super(importers);
            this.inMolCount = 0;
        }

        @Override
        protected Molecule read(MolImporter importer) throws IOException {
            if (Calculator.this.ignoreError) {
                while (true) {
                    try {
                        return this.readMol(importer);
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
            return this.readMol(importer);
        }

        private Molecule readMol(MolImporter importer) throws IOException {
            Molecule mol = null;
            try {
                mol = importer.read();
            }
            catch (IOException e) {
                ++this.inMolCount;
                System.err.println("Error reading molecule: " + this.inMolCount);
                System.err.println(e);
                throw e;
            }
            if (mol != null) {
                ++this.inMolCount;
                mol.setProperty(Calculator.MOLCOUNT_PROP, String.valueOf(this.inMolCount));
            }
            return mol;
        }
    }

    private static class PluginConfig {
        String name = null;
        String cl = null;
        String jar = null;
        String group = null;
        String parameters = null;
        String tag = null;
        String description = null;
        String helptext = null;
        String exampletext = null;

        public PluginConfig(String name, String cl, String jar, String group, String parameters, String tag, String description, String helptext, String exampletext) {
            this.name = name;
            this.cl = cl;
            this.jar = jar;
            this.group = group;
            this.parameters = parameters;
            this.tag = tag;
            this.description = description;
            this.helptext = helptext;
            this.exampletext = exampletext;
        }

        public String[][] getParameterData() {
            if (this.parameters == null || this.parameters.trim().length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(this.parameters, ";");
            String[][] p = new String[st.countTokens()][3];
            int t = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int k = token.indexOf(61);
                int l = token.indexOf(58, k);
                p[t][0] = token.substring(0, k);
                if (l != -1) {
                    p[t][1] = token.substring(k + 1, l);
                    p[t][2] = token.substring(l + 1);
                } else {
                    p[t][1] = token.substring(k + 1);
                    p[t][2] = null;
                }
                ++t;
            }
            return p;
        }

        public String toString() {
            return this.name + ", " + this.cl + "," + this.description + ", " + this.tag + ", " + this.helptext;
        }
    }
}

