/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class MolPrinter {
    private MolPainter painter;
    private MDocument document = new MDocument(new RgMolecule());

    public MolPrinter() {
        this((MDocument)null);
    }

    public MolPrinter(MoleculeGraph m) {
        this(m != null ? (m.getDocument() != null ? m.getDocument() : new MDocument(m)) : null);
    }

    public MolPrinter(MDocument d) {
        this.painter = new MolPainter(new MolPainterCommon());
        this.painter.setCentralized(true);
        if (d == null) {
            this.document = new MDocument(new RgMolecule());
        } else {
            this.document = d.cloneDocument();
            this.initMol();
            this.painter.setBoundsFor(this.document);
        }
    }

    public int getDispopts() {
        return this.painter.getCommon().getDispopts();
    }

    public void setDispopts(int f) {
        this.painter.getCommon().setDispopts(f);
        if (this.document != null) {
            this.painter.setBoundsFor(this.document);
        }
    }

    public void setDispopts(int f, int mask) {
        int opts = this.painter.getCommon().getDispopts();
        this.setDispopts(opts & ~mask | f & mask);
    }

    public int getDispoptsExt() {
        return this.painter.getCommon().getDispoptsExt();
    }

    public void setDispoptsExt(int f) {
        this.painter.getCommon().setDispoptsExt(f);
        if (this.document != null) {
            this.painter.setBoundsFor(this.document);
        }
    }

    public void setDispoptsExt(int f, int mask) {
        int opts = this.painter.getCommon().getDispoptsExt();
        this.setDispoptsExt(opts & ~mask | f & mask);
    }

    public double getScale() {
        return this.painter.getScale();
    }

    public void setScale(double m) {
        this.painter.setScale(m);
    }

    public double maxScale(Rectangle r) {
        return this.painter.maxScale(new Dimension(r.width, r.height));
    }

    public double maxScale(Dimension d) {
        return this.painter.maxScale(d);
    }

    public Rectangle getBoundingRectangle(MoleculeGraph[] mols) {
        return this.painter.getBoundsFor(mols, this.getScale());
    }

    public double getAtomsize() {
        return this.getAtomSize();
    }

    public double getAtomSize() {
        return this.painter.getAtomSize();
    }

    public synchronized void setAtomsize(double l) {
        this.setAtomSize(l);
    }

    public synchronized void setAtomSize(double s) {
        this.painter.setAtomSize(s);
    }

    public double getBondSpacing() {
        return this.painter.getCommon().getBondSpacing();
    }

    public double getBallRadius() {
        return this.painter.getCommon().getBallRadius();
    }

    public void setBallRadius(double r) {
        this.painter.getCommon().setBallRadius(r);
    }

    public double getStickThickness() {
        return this.painter.getCommon().getStickThickness();
    }

    public void setStickThickness(double w) {
        this.painter.getCommon().setStickThickness(w);
    }

    public double getWireThickness() {
        return this.painter.getCommon().getWireThickness();
    }

    public void setWireThickness(double w) {
        this.painter.getCommon().setWireThickness(w);
    }

    public void setBondSpacing(double s) {
        this.painter.getCommon().setBondSpacing(s);
    }

    public String getImplicitH() {
        return this.painter.getCommon().getImplicitH();
    }

    public void setImplicitH(String s) {
        this.painter.getCommon().setImplicitH(s);
    }

    public String getColorScheme() {
        return this.painter.getCommon().getColorScheme();
    }

    public void setColorScheme(String s) {
        this.painter.getCommon().setColorScheme(s);
    }

    public boolean isSetColoringEnabled() {
        return this.painter.getCommon().isSetColoringEnabled();
    }

    public void setSetColoringEnabled(boolean v) {
        this.painter.getCommon().setSetColoringEnabled(v);
    }

    public String getRendering() {
        return this.painter.getCommon().getRendering();
    }

    public void setRendering(String s) {
        this.painter.getCommon().setRendering(s);
    }

    public Color getBackgroundColor() {
        return this.painter.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.painter.setBackground(color);
    }

    public boolean isAtomSymbolsVisible() {
        return (this.getDispopts() & 0x400) != 0;
    }

    public void setAtomSymbolsVisible(boolean v) {
        int h = v ? 1024 : 0;
        this.setDispopts(this.getDispopts() & 0xFFFFFBFF | h);
    }

    public void setAtomNumbersVisible(boolean v) {
        this.painter.getCommon().setAtomNumbersVisible(v);
    }

    public boolean isAtomNumbersVisible() {
        return this.painter.getCommon().isAtomNumbersVisible();
    }

    public void setAtomMappingVisible(boolean v) {
        this.painter.getCommon().setAtomMappingVisible(v);
    }

    public boolean isAtomMappingVisible() {
        return this.painter.getCommon().isAtomMappingVisible();
    }

    public int getChiralitySupport() {
        return this.painter.getCommon().getChiralitySupport();
    }

    public synchronized void setChiralitySupport(int l) {
        this.setDispopts(this.getDispopts() & 0xFFFF3FFF | l << 14);
    }

    public boolean isEzVisible() {
        return this.isEZLabelsVisible();
    }

    public void setEzVisible(boolean v) {
        this.setEZLabelsVisible(v);
    }

    public boolean isEZLabelsVisible() {
        return (this.getDispopts() & 0x10000) != 0;
    }

    public void setEZLabelsVisible(boolean v) {
        int h = v ? 65536 : 0;
        this.setDispopts(this.getDispopts() & 0xFFFEFFFF | h);
    }

    public boolean isLonePairsVisible() {
        return this.painter.getCommon().areLonePairsVisible();
    }

    public void setLonePairsVisible(boolean v) {
        this.painter.getCommon().setLonePairsVisible(v);
    }

    public boolean isLonePairsAutoCalculated() {
        return this.painter.getCommon().areLonePairsAutoCalc();
    }

    public synchronized void setLonePairsAutoCalculated(boolean v) {
        this.painter.getCommon().setLonePairsAutoCalc(v);
    }

    public String getCarbonVisibility() {
        return this.painter.getCommon().getCarbonVisibility();
    }

    public void setCarbonVisibility(String s) {
        this.painter.getCommon().setCarbonVisibility(s);
    }

    public boolean isTransparent() {
        return this.painter.isTransparent();
    }

    public void setTransparent(boolean transparency) {
        this.painter.setTransparent(transparency);
    }

    public boolean isValenceErrorvisible() {
        return this.painter.getCommon().isValenceErrorVisible();
    }

    public void setValenceErrorVisible(boolean b) {
        this.painter.getCommon().setValenceErrorVisible(b);
        this.painter.getCommon().setErrorVisible(b);
    }

    public String getLigandOrderVisibility() {
        return this.painter.getCommon().getLigandOrderVisibility();
    }

    public void setLigandOrderVisibility(String s) {
        this.painter.getCommon().setLigandOrderVisibility(s);
    }

    public boolean isAtomPropertiesVisible() {
        return this.painter.getCommon().isAtomPropertiesVisible();
    }

    public synchronized void setAtomPropertiesVisible(boolean v) {
        this.painter.getCommon().setAtomPropertiesVisible(v);
    }

    public boolean isRLogicVisible() {
        return this.painter.getCommon().isRLogicVisible();
    }

    public synchronized void setRLogicVisible(boolean v) {
        this.painter.getCommon().setRLogicVisible(v);
    }

    public boolean isValencePropertyVisible() {
        return this.painter.getCommon().isValencePropertyVisible();
    }

    public synchronized void setValencePropertyVisible(boolean v) {
        this.painter.getCommon().setValencePropertyVisible(v);
    }

    public boolean isLigandErrorVisible() {
        return this.painter.getCommon().isLigandErrorVisible();
    }

    public synchronized void setLigandErrorVisible(boolean v) {
        this.painter.getCommon().setLigandErrorVisible(v);
    }

    public synchronized String getCoordinateBondStyle() {
        return this.painter.getCommon().getCoordinateBondStyle();
    }

    public synchronized void setCoordinateBondStyle(String s) {
        this.painter.getCommon().setCoordinateBondStyle(s);
    }

    public synchronized String getCoordinateBondStyleAtMulticenter() {
        return this.painter.getCommon().getCoordinateBondStyleAtMulticenter();
    }

    public synchronized void setCoordinateBondStyleAtMulticenter(String s) {
        this.painter.getCommon().setCoordinateBondStyleAtMulticenter(s);
    }

    public void setMol(Molecule m) {
        if (m == null) {
            this.document = new MDocument(new RgMolecule());
        } else if (m.getDocument() != null) {
            this.setDoc(m.getDocument());
        } else {
            m = m.cloneMolecule();
            this.document = new MDocument(m);
            this.initMol();
            this.painter.setBoundsFor(this.document);
        }
    }

    public void setMolTemplate(Molecule m) {
        this.setMol(m);
        this.painter.setBoundsFor(m, true, false);
    }

    public void setMol(String s) throws MolFormatException {
        Molecule mol;
        this.document = MolImporter.importDoc(s.getBytes());
        if (this.document == null) {
            this.document = new MDocument(new RgMolecule());
        }
        if (this.document.getMainMoleculeGraph() instanceof Molecule && (mol = (Molecule)this.document.getMainMoleculeGraph()) != null && !mol.isGUIContracted()) {
            mol.setGUIContracted(true);
        }
        this.painter.setBoundsFor(this.document);
    }

    public void setDoc(MDocument d) {
        if (d == null) {
            this.document = new MDocument(new RgMolecule());
        } else {
            this.document = d.cloneDocument();
            this.initMol();
            this.painter.setBoundsFor(this.document);
        }
    }

    private void initMol() {
        Molecule m;
        MoleculeGraph mg = this.document.getMainMoleculeGraph();
        if (mg instanceof Molecule && (m = (Molecule)mg).getSgroupCount() != 0) {
            m.setGUIContracted(true);
        }
        if (mg.getDim() == 0) {
            mg.clean(2, null);
        }
    }

    public void paint(Graphics g, Rectangle r) {
        if (g instanceof Graphics2D) {
            this.paint((Graphics2D)g, r);
        }
    }

    public void paint(Graphics2D g, Rectangle r) {
        g.translate(r.x, r.y);
        this.painter.setScreen(new Dimension(r.width, r.height));
        if (g.getClip() == null) {
            g.setClip(r);
        }
        this.painter.paintDocument(g, this.document, null);
        g.translate(-r.x, -r.y);
    }

    public void paint(Graphics2D g, Dimension d) {
        this.painter.setScreen(d);
        if (g.getClip() == null) {
            g.setClip(new Rectangle(0, 0, d.width, d.height));
        }
        this.painter.paintDocument(g, this.document, null);
    }

    public double getBondWidth() {
        return this.getBondSpacing();
    }

    public void setBondWidth(double w) {
        this.setBondSpacing(w);
    }

    public void molToScreenCoords(DPoint3 molcoords, Point2D scrcoords) {
        DPoint3 p = new DPoint3(molcoords);
        this.painter.calcGP(p);
        scrcoords.setLocation(p.x, p.y);
    }

    @Deprecated
    public void setExplicitH(boolean show) {
    }

    @Deprecated
    public boolean isExplicitHVisible() {
        return true;
    }

    @Deprecated
    public void setExplicitHVisible(boolean b) {
    }

    public int getDisplayQuality() {
        return this.painter.getCommon().getDispQuality();
    }

    public void setDisplayQuality(int q) {
        this.painter.getCommon().setDispQuality(q);
    }

    public boolean isBondLengthVisible() {
        return this.painter.getCommon().isBondLengthVisible();
    }

    public void setBondLengthVisible(boolean v) {
        this.painter.getCommon().setBondLengthVisible(v);
    }

    public boolean isGraphInvariantVisible() {
        return this.painter.getCommon().isGrinvVisible();
    }

    public void setGraphInvariantVisible(boolean v) {
        this.painter.getCommon().setGrinvVisible(v);
    }

    public String getDownWedge() {
        return this.painter.getCommon().getDownWedge();
    }

    public void setDownWedge(String orientation) {
        this.painter.getCommon().setDownWedge(orientation);
    }
}

