/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.common.util.ColorParser;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseException;
import chemaxon.marvin.OSXHelper;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.marvin.beans.MarvinPane;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.swing.ActionMenuItem;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.TableOptions;
import chemaxon.marvin.view.swing.TableSupport;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.ProgressMonitorInputStream;

public class View
extends JFrame
implements WindowListener {
    private static final ResourceBundle RESOURCES;
    private static final int VCOLS_DEFAULT = 4;
    private static final int VROWS_DEFAULT = 4;
    private static final int MAXSIZE_DEFAULT = 0;
    private static final int STARTAT_DEFAULT = 1;
    private List<String> colorKeys = null;
    private static String help;
    private static Vector viewWindows;
    private MViewPane viewPane = null;
    private Thread realTimeMovieThread = null;
    private static String fileWaittingForDisplay;
    private static String sdfColoringPropertyTag;
    private static Properties sdfColoringProps;
    private static boolean shouldExit;
    private final Action openAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            View.this.viewPane.showFileDialog("open", null);
        }
    };
    private final Action printAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            View.this.viewPane.print();
        }
    };
    private final Action exitAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            View.closeAll();
        }
    };
    private static AppEventHandler aeh;
    private boolean hasInitalized = false;

    public View(int startAt, int maxSize, boolean shSmiles, boolean shFields, String[] incFields, int maxCols, int maxRows, int vhtype) {
        viewWindows.addElement(this);
        Environment.installPlasticLookAndFeel(false);
        this.initActions();
        URL u = this.getClass().getResource("/chemaxon/icons/marvin/mview24.png");
        Image img = new ImageIcon(u).getImage();
        this.setIconImage(img);
        this.setTitle("MarvinView " + VersionInfo.MARVIN_VERSION);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(1, 1));
        Environment.setSkinEnabled(true);
        this.viewPane = new MViewPane();
        contentPane.add(this.viewPane);
        this.addKeyListener(this.viewPane);
        this.addWindowListener(this);
        this.viewPane.setBorderWidth(1);
        this.viewPane.setBackground(new Color(0xCCCCCC));
        this.viewPane.setEditable(1);
        this.viewPane.setSaveIniEnabled(true);
        this.viewPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String cmd = ev.getActionCommand();
                if (cmd.equals("file")) {
                    View.this.realTimeMovieThread = null;
                    File f = View.this.viewPane.getFile();
                    if (f != null) {
                        MolImporter mi;
                        String path = f.getPath();
                        String format2 = View.this.recognizeFormat(f);
                        if (format2 != null) {
                            path = path + "{" + format2 + "}";
                        }
                        try {
                            mi = new MolImporter(path, this, "Reading %p");
                        }
                        catch (IOException ex) {
                            View.this.handleImportExceptions(path, ex);
                            return;
                        }
                        catch (LicenseException ex) {
                            View.this.handleImportExceptions(path, ex);
                            return;
                        }
                        View.this.viewPane.getTableSupport().start(mi, path);
                        View.this.setTitle(View.this.getPreferredTitle());
                    }
                }
            }
        });
        TableSupport tblsup = this.viewPane.getTableSupport();
        tblsup.setSDFColoring(sdfColoringPropertyTag, sdfColoringProps);
        TableOptions tableOptions = tblsup.getTableOptions();
        tableOptions.setStartAt(startAt);
        tableOptions.setMaxSize(maxSize);
        tableOptions.setFieldsShown(shFields);
        tableOptions.setSMILESShown(shSmiles);
        tableOptions.setMaxCols(maxCols);
        tableOptions.setMaxRows(maxRows);
        if (vhtype == 0) {
            vhtype = this.viewPane.getUserSettings().getViewLayout();
        }
        tableOptions.setViewHandlerType(vhtype);
        if (incFields != null) {
            tableOptions.setSelectedFields(incFields);
        }
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu menu = BasicActions.createFileMenu();
        menubar.add(menu);
        menu.add(new ActionMenuItem(this.openAction));
        this.viewPane.makeRecentFileListMenu(menu);
        menu.addSeparator();
        this.viewPane.makeSaveAsMenu(menu);
        this.viewPane.getCommonActions().getSaveImageAction().addTo(menu);
        menu.addSeparator();
        menu.add(new ActionMenuItem(this.printAction));
        menu.addSeparator();
        boolean ismac = System.getProperty("os.name").indexOf("Mac") >= 0;
        String jver = System.getProperty("java.version");
        String macmenu = System.getProperty(jver.startsWith("1.3") ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar");
        if (!ismac || macmenu == null || !macmenu.equals("true")) {
            menu.add(new ActionMenuItem(this.exitAction));
        }
        menu = BasicActions.createEditMenu(true);
        menubar.add(menu);
        this.viewPane.makeEditMenu(menu);
        menu = BasicActions.createViewMenu();
        menubar.add(menu);
        this.viewPane.makeViewMenu(menu);
        menu = SwingUtil.createMenu(RESOURCES, "table");
        menubar.add(menu);
        tblsup.makeTableMenu(menu);
        menu = BasicActions.createStructureMenu(true);
        menubar.add(menu);
        this.viewPane.makeStructureMenu(menu);
        this.viewPane.addToolsMenu(menubar);
        this.viewPane.addHelpMenu(menubar);
    }

    private void handleImportExceptions(String path, Exception ex) {
        this.viewPane.showErrorDialog(path + ": file cannot be opened\n" + ex.getMessage(), ex);
        this.viewPane.endHourglass();
    }

    private static View createInEDT(final int startAt, final int maxSize, final boolean shSmiles, final boolean shFields, final String[] incFields, final int maxCols, final int maxRows, final int vhtype) {
        final View[] w = new View[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    w[0] = new View(startAt, maxSize, shSmiles, shFields, incFields, maxCols, maxRows, vhtype);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return w[0];
    }

    private void initActions() {
        SwingUtil.initAction(this.openAction, BasicActions.RESOURCES, "open", SwingUtil.getCommandKeyStroke(79));
        SwingUtil.initAction(this.printAction, BasicActions.RESOURCES, "print", SwingUtil.getCommandKeyStroke(80));
        SwingUtil.initAction(this.exitAction, BasicActions.RESOURCES, "exit", SwingUtil.getCommandKeyStroke(81));
    }

    public void setColoring(String tagName, Properties colorProp) {
        if (tagName == null || colorProp == null) {
            return;
        }
        this.colorKeys = new ArrayList<String>();
        Enumeration<Object> e = colorProp.keys();
        while (e.hasMoreElements()) {
            Color color;
            String key = (String)e.nextElement();
            String colorSt = (String)colorProp.get(key);
            try {
                color = ColorParser.parseColor(colorSt);
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Unknown color string: \"" + colorSt + "\".");
                color = Color.black;
            }
            if (key.equals("other")) {
                this.viewPane.setAtomSetColor(63, color);
                continue;
            }
            if (key.equals("empty")) {
                this.viewPane.setAtomSetColor(0, color);
                continue;
            }
            this.viewPane.setAtomSetColor(this.colorKeys.size() + 1, color);
            this.colorKeys.add(View.orderTokens(key, "/"));
        }
    }

    private static String orderTokens(String input, String delimiter) {
        StringTokenizer st = null;
        if (delimiter == null) {
            return null;
        }
        if (delimiter.length() == 0) {
            return null;
        }
        st = new StringTokenizer(input, delimiter.substring(0, 1));
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        String newSt = "";
        for (int y = 0; y < list.size(); ++y) {
            if (y > 0) {
                newSt = newSt + delimiter;
            }
            newSt = newSt + (String)list.get(y);
        }
        return newSt;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.viewPane != null) {
            if (this.viewPane.isExitCanceled()) {
                return;
            }
            this.viewPane.exit();
        }
        this.setVisible(false);
        this.dispose();
        viewWindows.remove(this);
        if (viewWindows.size() == 0) {
            if (aeh != null) {
                aeh.dispose();
            }
            if (shouldExit) {
                System.exit(0);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private String getInputName() {
        TableSupport tblsup = this.viewPane.getTableSupport();
        MDocSource dsrc = tblsup.getDocStorage().getDocSource();
        if (dsrc == null) {
            return "";
        }
        File f = this.viewPane.getFile();
        String path = f != null ? f.getName() : "STDIN";
        return path;
    }

    private String getPreferredTitle() {
        StringBuilder sb = new StringBuilder(this.getInputName());
        if (sb.length() != 0) {
            sb.append(" - ");
        }
        sb.append("MarvinView " + VersionInfo.MARVIN_VERSION);
        return sb.toString();
    }

    private void readStreamRT(MDocSource dsrc) {
        int i = 1;
        try {
            MDocument doc = dsrc.nextDoc();
            ++i;
            if (doc != null) {
                File f = this.viewPane.getFile();
                if (f != null) {
                    this.setTitle(f.getName() + " - MarvinView " + VersionInfo.MARVIN_VERSION);
                } else {
                    this.setTitle("MarvinView " + VersionInfo.MARVIN_VERSION);
                }
                MDocStorage ds = new MDocStorage(1);
                ds.storeMainDoc(doc, 0);
                this.realTimeMovieThread = new RealTimeMovieThread(dsrc);
                this.realTimeMovieThread.start();
            }
        }
        catch (IOException ex) {
            this.viewPane.showErrorDialog("Read error after molecule " + i + ":\n" + ex.getMessage(), ex);
        }
    }

    private MolImporter createCmdLineMolImporter(List files, String stdinOpts, boolean realTime) {
        MolImporter mi = null;
        if (files.size() != 0) {
            Object f = files.get(0);
            try {
                if (f == System.in) {
                    mi = new MolImporter((InputStream)f, stdinOpts);
                } else {
                    mi = realTime ? new MolImporter((String)f) : new MolImporter((String)f, this, "Reading %p");
                    File file = mi.getFile();
                    if (file != null) {
                        this.viewPane.setFile(file);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                ByteArrayInputStream bin = new ByteArrayInputStream(((String)f).getBytes());
                try {
                    mi = new MolImporter(bin, stdinOpts);
                    return mi;
                }
                catch (IOException ioex) {
                    System.err.println(f.toString() + ": not found");
                    System.exit(1);
                }
            }
            catch (LicenseException ex) {
                System.err.println(f.toString() + ": " + ex.getMessage());
                System.exit(1);
            }
            catch (MolFormatException ex) {
                System.err.print(f.toString() + ": ");
                ex.printStackTrace();
                System.exit(1);
            }
            catch (Exception ex) {
                System.err.println("Error: " + f + " is not a structure file.");
                System.exit(1);
            }
        }
        return mi;
    }

    private static void initSdfColoring(String paletteFileName) {
        if (sdfColoringPropertyTag == null && paletteFileName != null) {
            System.err.println("Error: cannot specify palette file without property tag.\n --- Use -h for help.");
            System.exit(1);
        }
        if (sdfColoringPropertyTag != null && paletteFileName == null) {
            System.err.println("Error: cannot specify property tag without palette file.\n --- Use -h for help.");
            System.exit(1);
        }
        if (sdfColoringPropertyTag != null && paletteFileName != null) {
            sdfColoringProps = new Properties();
            try {
                sdfColoringProps.load(new FileInputStream(paletteFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: cannot find palette file:" + paletteFileName);
                System.exit(1);
            }
            catch (IOException e2) {
                System.err.println("Error during parse of palette file.");
                System.exit(1);
            }
        }
    }

    private static Rectangle parseGeometry(String geom) {
        Rectangle r = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        int x = (geom = geom.trim()).indexOf(120);
        int p1 = geom.indexOf(43, x >= 0 ? x : 0);
        if (x >= 0) {
            if (x > 0) {
                r.width = Integer.parseInt(geom.substring(0, x));
            }
            String s = null;
            if (p1 > x + 1) {
                s = geom.substring(x + 1, p1);
            } else if (p1 < 0 && x < geom.length() - 1) {
                s = geom.substring(x + 1);
            }
            if (s != null) {
                r.height = Integer.parseInt(s);
            }
        }
        if (x < 0 && Character.isDigit(geom.charAt(0))) {
            p1 = 0;
        } else if (p1 >= 0) {
            ++p1;
        }
        if (p1 >= 0) {
            int p2 = geom.indexOf(43, p1);
            if (p2 > p1) {
                r.x = Integer.parseInt(geom.substring(p1, p2));
            } else if (p2 < 0 && p1 < geom.length()) {
                r.x = Integer.parseInt(geom.substring(p1));
            }
            if (p2 >= 0 && p2 < geom.length() - 1) {
                r.y = Integer.parseInt(geom.substring(p2 + 1));
            }
        }
        return r;
    }

    private static void showWindow(Window win, Rectangle geom) {
        int h;
        win.pack();
        if (geom == null) {
            geom = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        Dimension size = win.getSize();
        int w = geom.width > 0 ? geom.width : size.width;
        int n = h = geom.height > 0 ? geom.height : size.height;
        if (w > 0 || h > 0) {
            size = new Dimension(w, h);
            win.setSize(size);
        }
        int x = geom.x;
        int y = geom.y;
        if (x == Integer.MIN_VALUE || y == Integer.MIN_VALUE) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension scr = tk.getScreenSize();
            if (x == Integer.MIN_VALUE) {
                x = (scr.width - size.width) / 2;
            }
            if (y == Integer.MIN_VALUE) {
                y = (scr.height - size.height) / 2;
            }
        }
        win.setLocation(x, y);
        win.setVisible(true);
    }

    private String recognizeFormat(File f) {
        String[] fmtopts;
        String format2 = null;
        String filename = f.getPath();
        String[] fileopts = MFileFormatUtil.splitFileAndOptions(filename);
        if (fileopts[1] != null) {
            fmtopts = MFileFormatUtil.splitFormatAndOptions(fileopts[1]);
            f = new File(fileopts[0]);
        } else {
            fmtopts = new String[2];
        }
        if (fmtopts[0] == null) {
            fmtopts[0] = MFileFormatUtil.getUnguessableFormat(fileopts[0]);
        }
        try {
            MolInputStream mis = new MolInputStream((InputStream)new FileInputStream(f), null, null, f.getPath());
            RandomAccessFile raf = new RandomAccessFile(f.getPath(), "r");
            FileInputStream fis = new FileInputStream(raf.getFD());
            ProgressMonitorInputStream pis = new ProgressMonitorInputStream(this, "Examining " + f.getPath(), fis);
            mis = new MolInputStream((InputStream)new BufferedInputStream(pis), fmtopts[0], null, f.getPath());
            format2 = mis.getFormat();
            mis.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return format2;
    }

    public static void main(String[] args) {
        System.setProperty("chemaxon.marvin.View.running", "true");
        String[] incFields = null;
        boolean shSmiles = false;
        boolean shFields = false;
        ArrayList<Object> files = new ArrayList<Object>();
        String stdinOpts = null;
        int startAt = 1;
        int maxSize = 0;
        int vRows = 4;
        int vCols = 4;
        Rectangle geometry = null;
        int vhtype = 0;
        int debug = 0;
        boolean devel = false;
        double tabScale = -1.0;
        String paletteFileName = null;
        boolean realTime = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            try {
                if (arg.startsWith("--")) {
                    if (arg.equals("--help")) {
                        System.out.print(help);
                        System.out.flush();
                        return;
                    }
                    if (arg.equals("--debug")) {
                        ++debug;
                        continue;
                    }
                    if (arg.equals("--devel")) {
                        devel = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--geometry")) {
                        geometry = View.parseGeometry(args[++i]);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--gridbag")) {
                        vhtype = 1;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--spreadsheet")) {
                        vhtype = 2;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--tabscale")) {
                        String s;
                        if ((s = args[++i]).equals("uniform")) {
                            tabScale = 26.4;
                            continue;
                        }
                        try {
                            tabScale = Double.valueOf(s);
                        }
                        catch (NumberFormatException ex) {
                            System.err.println("Error in option --tabScale: value can only be a number or \"uniform\"");
                            System.exit(1);
                        }
                        continue;
                    }
                    if (arg.equals("--real-time")) {
                        realTime = true;
                        continue;
                    }
                    if (arg.equals("--disposeonexit")) {
                        shouldExit = false;
                        continue;
                    }
                    if (arg.equals("--desktoplauncher")) continue;
                    System.err.println("WARNING: Unknown option " + arg + " --- Use -h for help.");
                    continue;
                }
                if (arg.equals("-")) {
                    files.add(System.in);
                    continue;
                }
                if (arg.startsWith("-(") && arg.endsWith(")") || arg.startsWith("-{") && arg.endsWith("}")) {
                    files.add(System.in);
                    stdinOpts = arg.substring(2, arg.length() - 1);
                    continue;
                }
                if (arg.startsWith("-")) {
                    block28: for (int j = 1; j < arg.length(); ++j) {
                        char c = arg.charAt(j);
                        switch (c) {
                            case 'h': {
                                System.out.println(help);
                                return;
                            }
                            case 'c': {
                                try {
                                    vCols = Integer.parseInt(arg.substring(j + 1));
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    vCols = Integer.parseInt(args[++i]);
                                }
                                continue block28;
                            }
                            case 'r': {
                                try {
                                    vRows = Integer.parseInt(arg.substring(j + 1));
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    vRows = Integer.parseInt(args[++i]);
                                }
                                continue block28;
                            }
                            case 'n': {
                                try {
                                    maxSize = Integer.parseInt(arg.substring(j + 1));
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    maxSize = Integer.parseInt(args[++i]);
                                }
                                continue block28;
                            }
                            case 's': {
                                try {
                                    startAt = Integer.parseInt(arg.substring(j + 1));
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    startAt = Integer.parseInt(args[++i]);
                                }
                                continue block28;
                            }
                            case 'S': {
                                shSmiles = true;
                                continue block28;
                            }
                            case 'f': {
                                String s = arg.substring(j + 1);
                                j = arg.length();
                                if (s.equals("")) {
                                    s = args[++i];
                                }
                                if (!s.equals("all")) {
                                    StringTokenizer st = new StringTokenizer(s, ":");
                                    int n = st.countTokens();
                                    incFields = new String[n];
                                    for (int t = 0; t < n; ++t) {
                                        incFields[t] = st.nextToken();
                                    }
                                }
                                shFields = true;
                                continue block28;
                            }
                            case 'p': {
                                try {
                                    paletteFileName = arg.substring(j + 1);
                                    if (paletteFileName.length() == 0) {
                                        throw new Exception();
                                    }
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    paletteFileName = args[++i];
                                }
                                continue block28;
                            }
                            case 't': {
                                try {
                                    sdfColoringPropertyTag = arg.substring(j + 1);
                                    if (sdfColoringPropertyTag.length() == 0) {
                                        throw new Exception();
                                    }
                                    j = arg.length();
                                }
                                catch (Throwable e) {
                                    sdfColoringPropertyTag = args[++i];
                                }
                                continue block28;
                            }
                            default: {
                                System.err.println("WARNING: Error in option " + arg + " --- Use -h for help.");
                            }
                        }
                    }
                    continue;
                }
                files.add(arg);
                continue;
            }
            catch (Throwable e) {
                System.err.println("Error in option: " + arg + " --- Use -h for help.");
                if (debug != 0) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        }
        View.initSdfColoring(paletteFileName);
        final View w = View.createInEDT(startAt, maxSize, shSmiles, shFields, incFields, vCols, vRows, vhtype);
        w.viewPane.setTabScale(tabScale);
        w.viewPane.setDebug(debug);
        w.viewPane.setExperimentalEnabled(devel);
        if (fileWaittingForDisplay != null) {
            files.add(fileWaittingForDisplay);
            fileWaittingForDisplay = null;
        }
        if (!w.hasInitalized) {
            w.loadMolFiles(files, stdinOpts, realTime);
        }
        final Rectangle fgeometry = geometry;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                w.setTitle(w.getPreferredTitle());
                View.showWindow(w, fgeometry);
            }
        });
    }

    private void loadMolFiles(List files, String stdinOpts, boolean realTime) {
        this.hasInitalized = true;
        MolImporter mi = null;
        mi = this.createCmdLineMolImporter(files, stdinOpts, realTime);
        if (mi != null) {
            if (realTime) {
                this.readStreamRT(mi);
            } else {
                TableSupport tblsup = this.viewPane.getTableSupport();
                try {
                    tblsup.startNow(mi, this.getInputName());
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                catch (InvocationTargetException ex) {
                    ex.getTargetException().printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private static void openFile(String filename) {
        if (viewWindows.size() == 1) {
            View w = (View)viewWindows.get(0);
            Molecule m = w.viewPane.getM(0);
            if (m == null || m.isEmpty()) {
                if (!w.hasInitalized) {
                    fileWaittingForDisplay = filename;
                } else {
                    ArrayList<String> files = new ArrayList<String>();
                    files.add(filename);
                    w.loadMolFiles(files, null, false);
                }
                w.setTitle(w.getPreferredTitle());
            } else {
                View.openFileInNewWindow(filename);
            }
        } else if (viewWindows.size() == 0) {
            fileWaittingForDisplay = filename;
        } else {
            View.openFileInNewWindow(filename);
        }
    }

    private static void openFileInNewWindow(String filename) {
        final View w = !EventQueue.isDispatchThread() ? View.createInEDT(1, 0, false, false, null, 4, 4, 0) : new View(1, 0, false, false, null, 4, 4, 0);
        w.viewPane.setTabScale(-1.0);
        w.viewPane.setDebug(0);
        w.viewPane.setExperimentalEnabled(false);
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        w.loadMolFiles(files, null, false);
        final Rectangle fgeometry = null;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    w.setTitle(w.getPreferredTitle());
                    View.showWindow(w, fgeometry);
                }
            });
        } else {
            w.setTitle(w.getPreferredTitle());
            View.showWindow(w, fgeometry);
        }
    }

    private static void closeAll() {
        View w;
        int i;
        for (i = viewWindows.size() - 1; i >= 0; --i) {
            w = (View)viewWindows.elementAt(i);
            if (!w.viewPane.isExitCanceled()) continue;
            return;
        }
        for (i = viewWindows.size() - 1; i >= 0; --i) {
            w = (View)viewWindows.elementAt(i);
            w.windowClosing(null);
        }
    }

    static {
        help = "MarvinView " + MViewPane.VERSION + ", (C) 2000-2012 ChemAxon Ltd.\n" + "Licenses of additionally used third party programs can be found in license.html\n" + "Online version: http://www.chemaxon.com/marvin/license.html \n" + "Displays chemical structures from a file.\n" + "Usage: mview [options] [structure file or URL]\n" + "Options:\n" + "-h  --help          this help message\n" + "-                   import structures from standard input\n" + "--geometry WxH+X+Y  set preferred window size (W x H) and location (X, Y)\n" + "--real-time     display input stream in real time as a movie\n" + "--spreadsheet   use spreadsheet-like viewer with one row per input record\n" + "--gridbag       use compact matrix-like viewer with more molecules in a row\n" + "-c <number>     maximum number of visible columns for GridBagView" + " (default: " + 4 + ")\n" + "-r <number>     maximum number of visible rows for GridBagView" + " (default: " + 4 + ")\n" + "-n <number>     maximum number of molecules to import\n" + "-s <number>     start at the molecule specified by the number" + " (default: " + 1 + ")\n" + "-S              display unique SMILES code\n" + "-f <f1>:<f2>... show specified fields (<f1>, <f2>, ...) in the given order\n" + "                from an SDfile. Field names are separated by colons.\n" + "\n" + "Options for displaying additional atomic properties stored in SDfile:\n" + "-p <file>       palette definition property file\n" + "-t <tagName>    name of the tag in the SDfile that contains property symbols" + "\n\n" + "The structure file may be SDfile, SMILES, or other format supported" + " by Marvin\n" + "Examples:\n" + "1) Displaying the first 1000 structures from str.smi:\n" + "     mview str.smi\n" + "2) Viewing 500 structures starting at the 9500-th one from str.smi:\n" + "     mview -n 500 -s 9500 str.smi\n" + "3) Showing structures and 3 fields (ID, name, and stock) from stock.sdf:\n" + "     mview -f \"ID:name:stock\" stock.sdf\n" + "4) Display in 2 columns, show SMILES code:\n" + "     mview -Sc 2 stock.sdf\n" + "5) Search using JChem's command line search module and display the\n" + "   structure and the ID field from the results:\n" + "     jcsearch -q 'Clc1ccccc1' -f sdf input.sdf | mview -f ID -\n" + "6) Displaying the progress of a molecular dynamics simulation in real time:\n" + "     program_producing_molfiles_on_stdout | mview --real-time -\n" + "7) Atom coloring according to property symbols in SDFile:\n" + "     mview -p colors.ini -t PPL stock.sdf\n";
        viewWindows = new Vector();
        fileWaittingForDisplay = null;
        sdfColoringPropertyTag = null;
        sdfColoringProps = null;
        shouldExit = true;
        aeh = null;
        String jver = System.getProperty("java.version");
        System.setProperty(jver.startsWith("1.3") ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar", "true");
        ResourceBundle rc = null;
        try {
            rc = MarvinPane.getResourceBundle(View.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("properties file not found");
            System.exit(1);
        }
        RESOURCES = rc;
        aeh = AppEventHandler.getDefaultAppEventHandler();
    }

    private class RealTimeMovieThread
    extends Thread {
        private MDocSource docSource;

        RealTimeMovieThread(MDocSource dsrc) {
            this.docSource = dsrc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i = 1;
            try {
                TableSupport tblsup = View.this.viewPane.getTableSupport();
                while (true) {
                    MDocument doc;
                    if ((doc = this.docSource.nextDoc()) != null && View.this.realTimeMovieThread == this) {
                        ++i;
                        if (!tblsup.setDocument(0, doc)) {
                            return;
                        }
                        View.this.viewPane.repaint();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                View.this.viewPane.showErrorDialog("Read error after molecule " + i + ":\n" + ex.getMessage(), ex);
            }
            finally {
                if (View.this.realTimeMovieThread == this) {
                    View.this.realTimeMovieThread = null;
                }
                try {
                    this.docSource.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class AppEventHandler
    implements PropertyChangeListener {
        private OSXHelper helper;

        public static AppEventHandler getDefaultAppEventHandler() {
            if (Environment.MACOS) {
                try {
                    OSXHelper h = OSXHelper.getNewInstance();
                    return new AppEventHandler(h);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
            return null;
        }

        private AppEventHandler(OSXHelper helper) {
            this.helper = helper;
            if (helper != null) {
                helper.addListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if (name.equals("apple.OpenFile")) {
                final String filename = (String)ev.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        View.openFile(filename);
                    }
                };
                new Thread(r).start();
            } else if (name.equals("apple.Quit")) {
                View.closeAll();
            }
        }

        public void dispose() {
            if (this.helper != null) {
                this.helper.removeListener(this);
            }
        }
    }
}

