/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;

public class AlignRigidEasy
implements Licensable {
    private int max_sweeps = 300;
    private double[] q = new double[4];
    private double[] centerOfTheRefIndexed = new double[3];
    private double[] centerOfTheRotIndexed = new double[3];
    private double[][] u = new double[3][3];
    private double[][] cQ = new double[4][4];
    private double[][] vQ = new double[4][4];
    private double[] dQ = new double[4];
    private double[][] crdRefAll;
    private double[][] crdRotAll;
    private double[][] crdRefIndexed;
    private double[][] crdRotIndexed;
    private Molecule reference;
    private Molecule toRotate;
    private String licenseEnvironment = "";

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setReference(Molecule m) {
        this.setReference(MolGeom.getCoordniates(m));
        this.reference = m;
    }

    public void setRotatable(Molecule m) {
        this.setRotatable(MolGeom.getCoordniates(m));
        this.toRotate = m;
    }

    public static double[] convert(double[][] c) {
        double[] ret = new double[c.length * 3];
        int pos = 0;
        for (int i = 0; i < c.length; ++i) {
            ret[pos++] = c[i][0];
            ret[pos++] = c[i][1];
            ret[pos++] = c[i][2];
        }
        return ret;
    }

    public void setReference(double[][] c) {
        this.crdRefAll = c;
        this.reference = null;
    }

    public void setRotatable(double[][] c) {
        this.crdRotAll = c;
        this.toRotate = null;
    }

    public double[][] getRotatedCoordinates() {
        return this.crdRotAll;
    }

    public Molecule getRotatedMolecule() {
        MolGeom.putCoordinates(this.toRotate, this.getRotatedCoordinates());
        return this.toRotate;
    }

    public Molecule getReferenceAndRotatedFused() {
        Molecule ret = this.reference.cloneMolecule();
        ret.fuse(this.getRotatedMolecule());
        return ret;
    }

    public double rmsd() {
        double s = 0.0;
        for (int i = 0; i < this.crdRefIndexed.length; ++i) {
            double x = this.crdRefIndexed[i][0] - this.crdRotIndexed[i][0];
            double y = this.crdRefIndexed[i][1] - this.crdRotIndexed[i][1];
            double z = this.crdRefIndexed[i][2] - this.crdRotIndexed[i][2];
            s += x * x + y * y + z * z;
        }
        return Math.sqrt(s / (double)this.crdRotIndexed.length);
    }

    public void align() {
        this.align(null);
    }

    public void align(int[][] index) {
        this.checkLicense();
        if (this.crdRefAll == null) {
            throw new IllegalStateException("Set reference molecule or its coordinates");
        }
        if (this.crdRotAll == null) {
            throw new IllegalStateException("Set molecule to rotate or its coordinates");
        }
        if (index != null) {
            this.crdRefIndexed = new double[index.length][];
            this.crdRotIndexed = new double[index.length][];
            for (int i = 0; i < index.length; ++i) {
                this.crdRefIndexed[i] = this.crdRefAll[index[i][0]];
                this.crdRotIndexed[i] = this.crdRotAll[index[i][1]];
            }
        } else {
            this.crdRefIndexed = this.crdRefAll;
            this.crdRotIndexed = this.crdRotAll;
            if (this.crdRefAll.length != this.crdRotAll.length) {
                throw new IllegalStateException("Coordinate array size (atom count) mismach.");
            }
        }
        this.centerOfTheRefIndexed = AlignRigidEasy.calcCenter(this.centerOfTheRefIndexed, this.crdRefIndexed);
        this.crdRefAll = this.translate(this.centerOfTheRefIndexed, this.crdRefAll, -1);
        this.centerOfTheRotIndexed = AlignRigidEasy.calcCenter(this.centerOfTheRotIndexed, this.crdRotIndexed);
        this.crdRotAll = this.translate(this.centerOfTheRotIndexed, this.crdRotAll, -1);
        this.qtrfit();
        this.rotmol(this.crdRotAll, this.u);
        this.crdRefAll = this.translate(this.centerOfTheRefIndexed, this.crdRefAll, 1);
        this.crdRotAll = this.translate(this.centerOfTheRefIndexed, this.crdRotAll, 1);
    }

    private double[][] translate(double[] o, double[][] crd, int sign) {
        for (int i = 0; i < crd.length; ++i) {
            double[] dArray = crd[i];
            dArray[0] = dArray[0] + (double)sign * o[0];
            double[] dArray2 = crd[i];
            dArray2[1] = dArray2[1] + (double)sign * o[1];
            double[] dArray3 = crd[i];
            dArray3[2] = dArray3[2] + (double)sign * o[2];
        }
        return crd;
    }

    private static double[] calcCenter(double[] center, double[][] crd) {
        center[0] = 0.0;
        center[1] = 0.0;
        center[2] = 0.0;
        for (int i = 0; i < crd.length; ++i) {
            center[0] = center[0] + crd[i][0];
            center[1] = center[1] + crd[i][1];
            center[2] = center[2] + crd[i][2];
        }
        center[0] = center[0] / (double)crd.length;
        center[1] = center[1] / (double)crd.length;
        center[2] = center[2] / (double)crd.length;
        return center;
    }

    private void rotmol(double[][] x, double[][] u) {
        for (int i = 0; i < x.length; ++i) {
            double yx = u[0][0] * x[i][0] + u[1][0] * x[i][1] + u[2][0] * x[i][2];
            double yy = u[0][1] * x[i][0] + u[1][1] * x[i][1] + u[2][1] * x[i][2];
            double yz = u[0][2] * x[i][0] + u[1][2] * x[i][1] + u[2][2] * x[i][2];
            x[i][0] = yx;
            x[i][1] = yy;
            x[i][2] = yz;
        }
    }

    private static void jacobi(double[][] a, double[] d, double[][] v, int nrot) {
        int j;
        int i;
        double small = 1.0E-12;
        double f0 = 0.0;
        double p5 = 0.5;
        double f1 = 1.0;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                v[i][j] = 0.0;
            }
            v[i][i] = 1.0;
            d[i] = a[i][i];
        }
        for (int l = 1; l <= nrot; ++l) {
            double dtemp;
            int k;
            double dnorm = 0.0;
            double onorm = 0.0;
            for (j = 0; j < 4; ++j) {
                dnorm += Math.abs(d[j]);
                for (i = 0; i <= j - 1; ++i) {
                    onorm += Math.abs(a[i][j]);
                }
            }
            if (onorm / dnorm <= 1.0E-12) {
                nrot = l;
                for (j = 0; j < 3; ++j) {
                    k = j;
                    dtemp = d[k];
                    for (i = j + 1; i <= 3; ++i) {
                        if (!(d[i] < dtemp)) continue;
                        k = i;
                        dtemp = d[k];
                    }
                    if (k <= j) continue;
                    d[k] = d[j];
                    d[j] = dtemp;
                    for (i = 0; i < 4; ++i) {
                        dtemp = v[i][k];
                        v[i][k] = v[i][j];
                        v[i][j] = dtemp;
                    }
                }
                return;
            }
            for (j = 1; j < 4; ++j) {
                for (i = 0; i < j; ++i) {
                    double atemp;
                    double t;
                    double b = a[i][j];
                    if (!(Math.abs(b) > 0.0)) continue;
                    double dma = d[j] - d[i];
                    if (Math.abs(dma) + Math.abs(b) <= Math.abs(dma)) {
                        t = b / dma;
                    } else {
                        double q = 0.5 * dma / b;
                        t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
                        if (q < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double s = t * c;
                    a[i][j] = 0.0;
                    for (k = 0; k < i; ++k) {
                        atemp = c * a[k][i] - s * a[k][j];
                        a[k][j] = s * a[k][i] + c * a[k][j];
                        a[k][i] = atemp;
                    }
                    for (k = i + 1; k < j; ++k) {
                        atemp = c * a[i][k] - s * a[k][j];
                        a[k][j] = s * a[i][k] + c * a[k][j];
                        a[i][k] = atemp;
                    }
                    for (k = j + 1; k < 4; ++k) {
                        atemp = c * a[i][k] - s * a[j][k];
                        a[j][k] = s * a[i][k] + c * a[j][k];
                        a[i][k] = atemp;
                    }
                    for (k = 0; k < 4; ++k) {
                        double vtemp = c * v[k][i] - s * v[k][j];
                        v[k][j] = s * v[k][i] + c * v[k][j];
                        v[k][i] = vtemp;
                    }
                    dtemp = c * c * d[i] + s * s * d[j] - 2.0 * c * s * b;
                    d[j] = s * s * d[i] + c * c * d[j] + 2.0 * c * s * b;
                    d[i] = dtemp;
                }
            }
        }
    }

    private static void q2mat(double[] q, double[][] u) {
        double f2 = 2.0;
        u[0][0] = q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3];
        u[0][1] = 2.0 * (q[1] * q[2] - q[0] * q[3]);
        u[0][2] = 2.0 * (q[1] * q[3] + q[0] * q[2]);
        u[1][0] = 2.0 * (q[2] * q[1] + q[0] * q[3]);
        u[1][1] = q[0] * q[0] - q[1] * q[1] + q[2] * q[2] - q[3] * q[3];
        u[1][2] = 2.0 * (q[2] * q[3] - q[0] * q[1]);
        u[2][0] = 2.0 * (q[3] * q[1] - q[0] * q[2]);
        u[2][1] = 2.0 * (q[3] * q[2] + q[0] * q[1]);
        u[2][2] = q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3];
    }

    private void qtrfit() {
        int i;
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        for (i = 0; i < this.crdRefIndexed.length; ++i) {
            double[] x = this.crdRotIndexed[i];
            double[] y = this.crdRefIndexed[i];
            xxyx += x[0] * y[0];
            xxyy += x[0] * y[1];
            xxyz += x[0] * y[2];
            xyyx += x[1] * y[0];
            xyyy += x[1] * y[1];
            xyyz += x[1] * y[2];
            xzyx += x[2] * y[0];
            xzyy += x[2] * y[1];
            xzyz += x[2] * y[2];
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.cQ[i][j] = 0.0;
            }
        }
        this.cQ[0][0] = xxyx + xyyy + xzyz;
        this.cQ[0][1] = xzyy - xyyz;
        this.cQ[1][1] = xxyx - xyyy - xzyz;
        this.cQ[0][2] = xxyz - xzyx;
        this.cQ[1][2] = xxyy + xyyx;
        this.cQ[2][2] = xyyy - xzyz - xxyx;
        this.cQ[0][3] = xyyx - xxyy;
        this.cQ[1][3] = xzyx + xxyz;
        this.cQ[2][3] = xyyz + xzyy;
        this.cQ[3][3] = xzyz - xxyx - xyyy;
        AlignRigidEasy.jacobi(this.cQ, this.dQ, this.vQ, this.max_sweeps);
        int pos = 3;
        this.q[0] = this.vQ[0][pos];
        this.q[1] = this.vQ[1][pos];
        this.q[2] = this.vQ[2][pos];
        this.q[3] = this.vQ[3][pos];
        AlignRigidEasy.q2mat(this.q, this.u);
    }

    double[] getQuaternion() {
        return this.q;
    }
}

