/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.VanDerWaalsInterface;
import java.util.BitSet;

class AtomicGaussian
extends MolecularGaussian
implements Node,
VanDerWaalsInterface {
    int atomSeq;
    int type = -1;
    private int originalAtomType;
    private double vanDerWaalsRadius;
    private boolean selected = false;

    public AtomicGaussian(double p, double alpha, double[] crd, int atomSeq, int molID, int type, int originalAtomType) {
        super(molID, p, alpha, crd);
        this.type = type;
        this.atomSeq = atomSeq;
        this.originalAtomType = originalAtomType;
    }

    @Override
    public int getMemberCount() {
        return 1;
    }

    @Override
    public String toString() {
        return "AtomicGaussian MolID: " + this.molID + " members: " + this.atomSeq + " type: " + this.type + super.toString();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean equals(Node al) {
        if (!(al instanceof AtomicGaussian)) {
            return false;
        }
        if (al.getMolID() != this.molID) {
            return false;
        }
        AtomicGaussian other = (AtomicGaussian)al;
        return this.atomSeq == other.atomSeq;
    }

    @Override
    public boolean isRealAtom() {
        return true;
    }

    @Override
    public int getFirstAtomSeq() {
        return this.atomSeq;
    }

    @Override
    public int getNextAtomSeq() {
        return -1;
    }

    @Override
    public boolean hasCommonMember(Node node) {
        throw new IllegalStateException();
    }

    @Override
    public BitSet markAtoms(BitSet b) {
        b.clear();
        b.set(this.getFirstAtomSeq(), true);
        return b;
    }

    @Override
    public double getTypeScale(int type, NodeColor c) {
        if (c.isSameType(type, this.type)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public void setType(int t) {
        this.type = t;
    }

    @Override
    public int getOriginalAtomType() {
        return this.originalAtomType;
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.vanDerWaalsRadius;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.vanDerWaalsRadius = radius;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean equalsForDisabling(Node n) {
        return this.equals(n);
    }
}

