/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.NodeColor;
import java.text.DecimalFormat;

class AtomicHistogram {
    public static final double EPS = 1.0E-6;
    int type;
    int[] histogram;
    double binsize;
    int startMin;

    public int getMinBin() {
        return this.startMin;
    }

    public int getMaxBin() {
        return this.startMin + this.histogram.length;
    }

    public int getValue(int i) {
        if (i < this.getMinBin() || i >= this.getMaxBin()) {
            return 0;
        }
        return this.histogram[i - this.startMin];
    }

    AtomicHistogram(int type, int[] histogram, double binsize, int startMin) {
        this.type = type;
        this.histogram = histogram;
        this.binsize = binsize;
        this.startMin = startMin;
    }

    public double tanimoto(AtomicHistogram ah) {
        int i;
        if (ah.getBinsize() != this.getBinsize()) {
            throw new IllegalStateException("BinSize mismatch");
        }
        if (this.getMaxBin() < ah.getMinBin() || ah.getMaxBin() < this.getMinBin()) {
            return 0.0;
        }
        int minOfMax = Math.min(this.getMaxBin(), ah.getMaxBin());
        int maxOfMin = Math.max(this.getMinBin(), ah.getMinBin());
        int minValCommon = 0;
        int maxValCommon = 0;
        for (int i2 = maxOfMin; i2 < minOfMax; ++i2) {
            minValCommon += Math.min(this.getValue(i2), ah.getValue(i2));
            maxValCommon += Math.max(this.getValue(i2), ah.getValue(i2));
        }
        int underCommon = 0;
        int aboveCommon = 0;
        boolean u1 = false;
        boolean u2 = false;
        boolean a1 = false;
        boolean a2 = false;
        for (i = ah.getMinBin(); i < maxOfMin; ++i) {
            underCommon += ah.getValue(i);
            u1 = true;
        }
        for (i = this.getMinBin(); i < maxOfMin; ++i) {
            underCommon += this.getValue(i);
            u2 = true;
        }
        for (i = ah.getMaxBin(); i < minOfMax; ++i) {
            aboveCommon += ah.getValue(i);
            a1 = true;
        }
        for (i = this.getMaxBin(); i < minOfMax; ++i) {
            aboveCommon += this.getValue(i);
            a2 = true;
        }
        if (u1 && u2) {
            throw new UnsupportedOperationException();
        }
        if (a1 && a2) {
            throw new UnsupportedOperationException();
        }
        if (maxValCommon + underCommon + aboveCommon == 0) {
            System.err.println(this);
            System.err.println("");
            System.err.println(ah);
            throw new UnsupportedOperationException();
        }
        return (double)minValCommon / (double)(maxValCommon + underCommon + aboveCommon);
    }

    public int getType() {
        return this.type;
    }

    public double getBinsize() {
        return this.binsize;
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public boolean isComaparable(AtomicHistogram ah, NodeColor nc) {
        return nc.isSameTypeOrBothShapeLabelled(this.type, ah.getType()) && this.binsize == ah.getBinsize();
    }

    public String toString(NodeColor c) {
        DecimalFormat d = new DecimalFormat("0.00");
        StringBuilder sb = new StringBuilder();
        sb.append(c.typeLabel(this.type)).append("\n");
        for (int i = 0; i < this.histogram.length; ++i) {
            sb.append(d.format((double)(i + this.startMin) * this.binsize)).append(" ").append(this.histogram[i]).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        throw new UnsupportedOperationException("dont use this");
    }
}

