/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionOneFlexibleMol;
import chemaxon.marvin.alignment.MMFF;
import chemaxon.marvin.alignment.Visualizer;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.BitSet;

public class AtropIsomerDetector
implements Licensable {
    private AlignmentMoleculeFactory amf;
    private FlexibleMolecule fm;
    private int realRotatableBondCount = 0;
    private int possibleRotatableBondCount = 0;
    private Molecule resultMolecule;
    private Visualizer vis;
    private int accuracy = Accuracy.NORMAL.getSteps();
    private FunctionOneFlexibleMol f;
    private boolean debug = false;
    private double barrierLimit = 200.0;
    private ArrayList<Atrop> results;
    private int numberOfAtomsAcceptToRotate = 2;
    private boolean methylsRotatable = false;
    private String licenseEnvironment = "";

    final void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Conformation Plugin Group", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Conformation Plugin Group", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public AtropIsomerDetector() throws AlignmentException {
        this.amf = new AlignmentMoleculeFactory();
        this.amf.setAromatize(true);
        this.amf.setDehidrogenize(false);
        this.amf.setCreateRingCenters(false);
        this.amf.setColor(AlignmentProperties.ColoringScheme.SAME);
        try {
            this.amf.setForceFieldPotential(new MMFF());
        }
        catch (MMFF94Exception ex) {
            throw new AlignmentException(ex);
        }
        this.amf.setGenerateDistanceRanges(false);
        this.amf.setNodeType(AlignmentProperties.NodeType.SIMPLE);
        this.amf.setShape(AlignmentProperties.ShapeDescriptorPoints.NOTHING);
    }

    public void setMethylsRotatable(boolean methylsRotatable) {
        this.methylsRotatable = methylsRotatable;
    }

    public void setNumberOfAtomsAcceptToRotate(int numberOfAtomsAcceptToRotate) {
        this.numberOfAtomsAcceptToRotate = numberOfAtomsAcceptToRotate;
    }

    public void setBarrierLimit(double barrierLimit) {
        this.barrierLimit = barrierLimit;
    }

    public void setSamplingAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public void setSamplingAccuracy(Accuracy a) {
        this.accuracy = a.getSteps();
    }

    public void setFlexibleRingRotatableBondCount(int i) {
        this.amf.setFlexibleRingRotatableBondCount(i);
    }

    public void setFlexibleRingSize(int size) {
        this.amf.setFlexibleRingSize(size);
    }

    void setVis(Visualizer vis) {
        this.vis = vis;
    }

    private boolean isMethylCapped(int atom, BitSet toRotate) {
        if (this.resultMolecule.getAtom(atom).getAtno() == 6 && toRotate.cardinality() == 3) {
            int hCount = 0;
            for (int i = 0; i < toRotate.length(); ++i) {
                if (!toRotate.get(i) || this.resultMolecule.getAtom(i).getAtno() != 1) continue;
                ++hCount;
            }
            return hCount == 3;
        }
        return false;
    }

    public void calculate(Molecule m) throws AlignmentException {
        this.checkLicense();
        m.hydrogenize(true);
        if (m.getDim() != 3) {
            m.clean(3, null);
        }
        this.results = new ArrayList(m.getBondCount());
        this.realRotatableBondCount = 0;
        this.possibleRotatableBondCount = 0;
        AlignmentMolecule am = this.amf.generate(0, m, false, true);
        this.resultMolecule = am.getMoleculeOrig();
        if (am.isRigid()) {
            return;
        }
        this.fm = (FlexibleMolecule)am;
        this.fm.setOneSideRotationForAllDihedrals(true);
        this.possibleRotatableBondCount = this.fm.getDihedrals().size();
        this.f = new FunctionOneFlexibleMol(this.fm);
        if (this.vis != null) {
            ArrayList<AlignmentMolecule> v = new ArrayList<AlignmentMolecule>();
            v.add(this.fm);
            this.vis.init(v, null);
            this.f.setVis(this.vis);
        }
        double dt = Math.PI * 2 / (double)this.accuracy;
        for (int i = 0; i < this.fm.getDihedrals().size(); ++i) {
            Dihedral d = this.fm.getDihedrals().get(i);
            if (d.atomsOnBside.cardinality() < this.numberOfAtomsAcceptToRotate || d.atomsOnCside.cardinality() < this.numberOfAtomsAcceptToRotate || !this.methylsRotatable && (this.isMethylCapped(d.nB.getFirstAtomSeq(), d.atomsOnBside) || this.isMethylCapped(d.nC.getFirstAtomSeq(), d.atomsOnCside))) continue;
            d.setEnabled(false);
            double min = -1.0;
            double max = -1.0;
            Atrop at = new Atrop(d);
            for (int j = 0; j < this.accuracy; ++j) {
                d.rotateBy(dt);
                double e = this.getEnergy();
                at.vals[i][0] = d.getAngle();
                at.vals[i][1] = e;
                if (this.debug) {
                    System.err.println(j + " " + d.nB.getFirstAtomSeq() + " " + d.nC.getFirstAtomSeq() + " " + d.getAngle() + " " + e);
                }
                if (j == 0) {
                    min = e;
                    max = e;
                }
                if (e > max) {
                    max = e;
                }
                if (!(e < min)) continue;
                min = e;
            }
            at.setMax(max);
            at.setMin(min);
            double diff = max - min;
            boolean a = true;
            if (diff > this.barrierLimit) {
                this.results.add(at);
            }
            d.setEnabled(true);
        }
        this.realRotatableBondCount = this.possibleRotatableBondCount - this.results.size();
    }

    public int[] getAtropBonds() {
        int[] ret = new int[this.results.size()];
        for (int i = 0; i < ret.length; ++i) {
            int a1 = this.results.get((int)i).d.nB.getFirstAtomSeq();
            int a2 = this.results.get((int)i).d.nC.getFirstAtomSeq();
            ret[i] = this.resultMolecule.getBondTable().getBondIndex(a1, a2);
        }
        return ret;
    }

    private double getEnergy() throws AlignmentException {
        this.f.reset();
        GradientOptimization opt = new GradientOptimization(this.f);
        opt.setMaxStepComponent(0.7853981633974483);
        opt.setGradientRMSLimit(0.01);
        try {
            opt.run();
        }
        catch (GradientOptimization.GradientOptimizationException ex) {
            throw new AlignmentException(ex);
        }
        if (this.vis != null) {
            this.vis.showSteps();
        }
        return this.f.getFunctionValue();
    }

    public int getRealRotatableBondCount() {
        return this.realRotatableBondCount;
    }

    public int getPossibleRotatableBondCount() {
        return this.possibleRotatableBondCount;
    }

    public Molecule getResultMolecule() {
        return this.resultMolecule;
    }

    private class Atrop {
        Dihedral d;
        double min;
        double max;
        double[][] vals;

        public Atrop(Dihedral d) {
            this.d = d;
            this.vals = new double[AtropIsomerDetector.this.accuracy][2];
        }

        public void setMax(double max) {
            this.max = max;
        }

        public void setMin(double min) {
            this.min = min;
        }
    }

    public static enum Accuracy {
        NORMAL(20),
        FAST(10),
        ACCURATE(100);

        private final int steps;

        private Accuracy(int steps) {
            this.steps = steps;
        }

        public int getSteps() {
            return this.steps;
        }
    }
}

