/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;
import java.text.DecimalFormat;

class Constraint<T extends PotentialFunction>
implements Interaction {
    Node node1;
    Node node2;
    T pot;
    double dist = -1.0;

    public Constraint(Node node1, Node node2, T pot) {
        this.node1 = node1;
        this.node2 = node2;
        this.pot = pot;
    }

    @Override
    public Node getNode1() {
        return this.node1;
    }

    @Override
    public Node getNode2() {
        return this.node2;
    }

    @Override
    public double getEnergy() {
        this.calcDist();
        return this.pot.functionValue(this.dist);
    }

    @Override
    public double derivateDividedByDist() {
        this.calcDist();
        return this.pot.functionDerivateDividedByDist(this.dist);
    }

    @Override
    public void update() {
        this.dist = -1.0;
    }

    void calcDist() {
        this.dist = Math.sqrt(this.getDistSQ());
    }

    @Override
    public double getDistSQ() {
        return this.node1.getDistSQ(this.node2);
    }

    public PotentialType getPotentialType() {
        return this.pot.getType();
    }

    public boolean isAssigned() {
        return this.node1 != null && this.node2 != null;
    }

    @Override
    public double getDist() {
        this.calcDist();
        return this.dist;
    }

    public String toString() {
        if (this.dist == -1.0) {
            this.dist = Math.sqrt(this.node1.getDistSQ(this.node2));
        }
        DecimalFormat df = new DecimalFormat("0.000");
        String s = "";
        if (this.node1 != null && this.node2 != null && this.node1.getCrd() != null && this.node2.getCrd() != null) {
            s = s + ((Object)this.node1).toString() + " " + ((Object)this.node2).toString();
            s = s + " Dist: " + df.format(this.dist) + " " + this.getPotentialType().toString();
        }
        return s;
    }

    public boolean equals(Constraint c) {
        return this.node1.equals(c.node1) && this.node2.equals(c.node2) || this.node2.equals(c.node1) && this.node1.equals(c.node2);
    }
}

