/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

final class CubicFunction {
    private static Map<Key, CubicFunction> store = new HashMap<Key, CubicFunction>();
    private final double minR;
    private final double maxR;
    private final double r2;
    private final double r3;
    private final double r1;
    private final double m1;
    private final double r2Scale;
    private final double r3Scale;
    private final double r1Scale;
    private final double df1c;
    private final double df1aC;
    private final double df2c;
    private final double df2aC;
    private final double df2bC;
    private final double df3c;
    private final double f1c;
    private final double f1aC;
    private final double f1bC;
    private final double f2c;
    private final double f2aC;
    private final double f2bC;
    private final double f2dC;
    private final double f3c;

    private CubicFunction(double radius1, double radius2, double r3Scale, double r2Scale, double r1Scale) {
        this.r1Scale = r1Scale;
        this.r2Scale = r2Scale;
        this.r3Scale = r3Scale;
        assert (r1Scale < r2Scale);
        assert (r1Scale < r2Scale);
        this.minR = Math.min(radius1, radius2);
        this.maxR = Math.max(radius1, radius2);
        double rr = this.minR + this.maxR;
        this.r3 = rr * r3Scale;
        this.r2 = rr * r2Scale;
        this.r1 = rr * r1Scale;
        double volume = 4.0 * this.minR * this.minR * this.minR * Math.PI / 3.0;
        this.m1 = 6.0 * volume / ((this.r1 + this.r2) * (this.r1 + this.r2) - this.r2 * this.r3 - this.r3 * this.r3);
        this.df1c = this.m1 / (2.0 * this.r1);
        this.df1aC = this.df1c * (-this.r1 * (this.r1 + this.r2 - this.r3));
        this.df2c = this.m1 / (2.0 * (this.r1 - this.r2));
        this.df2aC = this.df2c * (this.r2 * this.r2 + this.r1 * (this.r2 + this.r3) - this.r2 * this.r3);
        this.df2bC = -2.0 * this.df2c * (this.r1 + this.r2);
        this.df3c = -this.m1 / (2.0 * (this.r2 - this.r3));
        this.f1c = this.m1 / (6.0 * this.r1);
        this.f1aC = this.f1c * this.r1 * this.r2 * (this.r1 + this.r2) + this.f1c * this.r1 * (this.r1 - this.r3) * (this.r1 + this.r2 + this.r3);
        this.f1bC = -3.0 * this.f1c * (this.r1 * (this.r1 - this.r3) + this.r1 * this.r2);
        this.f2c = 1.0 / (6.0 * (this.r1 - this.r2)) * this.m1;
        this.f2aC = this.f2c * this.r2 * this.r3 * (this.r2 + this.r3) - this.f2c * this.r1 * this.r2 * this.r2 - this.f2c * this.r1 * this.r2 * this.r3 - this.f2c * this.r1 * this.r3 * this.r3;
        this.f2bC = 3.0 * this.f2c * (this.r1 * (this.r2 + this.r3) - this.r2 * this.r3);
        this.f2dC = -this.f2c * this.r1 * 3.0;
        this.f3c = this.m1 / (6.0 * (this.r2 - this.r3));
    }

    public double ddf(double x) {
        if ((x = Math.max(0.0, x)) >= 0.0 && x < this.r1) {
            return this.m1 * x / this.r1;
        }
        if (x >= this.r1 && x < this.r2) {
            return -(this.m1 * (this.r1 + this.r2 - 2.0 * x)) / (this.r1 - this.r2);
        }
        if (x >= this.r2 && x < this.r3) {
            return this.m1 * (this.r3 - x) / (this.r2 - this.r3);
        }
        if (x >= this.r3) {
            return 0.0;
        }
        throw new IllegalStateException("invalid x");
    }

    public double df(double x) {
        if ((x = Math.max(0.0, x)) >= 0.0 && x < this.r1) {
            return this.df1aC + this.df1c * x * x;
        }
        if (x >= this.r1 && x < this.r2) {
            return this.df2aC + this.df2bC * x + this.df2c * 2.0 * x * x;
        }
        if (x >= this.r2 && x < this.r3) {
            return this.df3c * (this.r3 - x) * (this.r3 - x);
        }
        if (x >= this.r3) {
            return 0.0;
        }
        throw new IllegalStateException("invalid x");
    }

    public double f(double x) {
        if ((x = Math.max(0.0, x)) >= 0.0 && x < this.r1) {
            return this.f1aC + this.f1bC * x + this.f1c * x * x * x;
        }
        if (x >= this.r1 && x < this.r2) {
            double p = this.r2 - x;
            return this.f2aC + this.f2bC * x + this.f2c * (x * x * x - p * p * p) + this.f2dC * x * x;
        }
        if (x >= this.r2 && x < this.r3) {
            double p = this.r3 - x;
            return this.f3c * p * p * p;
        }
        if (x >= this.r3) {
            return 0.0;
        }
        throw new IllegalStateException("invalid x");
    }

    private double sphereIntersection(double x) {
        return CubicFunction.sphereIntersection(x, this.minR, this.maxR);
    }

    public static double radiusForIntersection(double x, double c1, double c2) {
        return Math.pow(CubicFunction.sphereIntersection(x, c1, c2) / 4.0 * 3.0 / Math.PI, 0.3333333333333333);
    }

    private static double sphereIntersection(double x, double radius1, double radius2) {
        double rmax;
        double rmin = Math.min(radius1, radius2);
        if (x + rmin <= (rmax = Math.max(radius1, radius2))) {
            return 4.0 * rmin * rmin * rmin * Math.PI / 3.0;
        }
        if (x > radius1 + radius2) {
            return 0.0;
        }
        double p1 = -x + rmax + rmin;
        double p2 = rmax - rmin;
        return Math.PI * p1 * p1 * (x * x - 3.0 * p2 * p2 + 2.0 * x * (rmax + rmin)) / (12.0 * x);
    }

    private StringBuilder addExtraPoints(StringBuilder sb, double border, double x, double step) {
        if (x < border && x + step > border) {
            sb.append(border).append(" ").append(this.sphereIntersection(border)).append(" ").append(this.f(border)).append(" ").append(this.df(border)).append(" ").append(this.ddf(border)).append("\n");
        }
        return sb;
    }

    private String chart() {
        StringBuilder sb = new StringBuilder("x sphere f(x) df(x) ddf(x) \n");
        double step = this.r3 * 0.01;
        for (double x = 0.0; x < this.r3 * 1.2; x += step) {
            sb.append(x).append(" ").append(this.sphereIntersection(x)).append(" ").append(this.f(x)).append(" ").append(this.df(x)).append(" ").append(this.ddf(x)).append("\n");
            this.addExtraPoints(sb, this.r1, x, step);
            this.addExtraPoints(sb, this.r2, x, step);
            this.addExtraPoints(sb, this.r3, x, step);
        }
        return sb.toString();
    }

    private double goodness() {
        double step = this.r3 * 0.01;
        double val = 0.0;
        for (double x = 0.0; x < this.r3 * 1.2; x += step) {
            double e = this.f(x) - this.sphereIntersection(x);
            val += e * e;
        }
        return val;
    }

    public final String toString() {
        DecimalFormat df = new DecimalFormat("0.00");
        return "r1Scale: " + df.format(this.r1Scale) + " r2Scale: " + df.format(this.r2Scale) + " r3Scale: " + df.format(this.r3Scale);
    }

    public static synchronized CubicFunction create(double radius1, double radius2) {
        Key key = new Key(radius1, radius2);
        CubicFunction ret = store.get(key);
        if (ret == null) {
            for (double r3 = 0.8; r3 < 1.5; r3 += 0.1) {
                for (double r2 = 0.3; r2 <= r3 - 0.1; r2 += 0.1) {
                    for (double r1 = 0.1; r1 <= r2 - 0.1; r1 += 0.1) {
                        CubicFunction cp = new CubicFunction(radius1, radius2, r3, r2, r1);
                        if (ret != null && !(ret.goodness() > cp.goodness())) continue;
                        ret = cp;
                    }
                }
            }
            store.put(key, ret);
        }
        return ret;
    }

    private static class Key {
        private final int min;
        private final int max;

        public Key(double radius1, double radius2) {
            this.min = (int)(Math.min(radius1, radius2) * 100.0);
            this.max = (int)(Math.max(radius1, radius2) * 100.0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.max == other.max && this.min == other.min;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.min;
            hash = 29 * hash + this.max;
            return hash;
        }
    }
}

