/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class DihedralRotator {
    int[][] ctab;
    Molecule m;
    double[][] crd;
    BitSet visited;
    int visitedCount = 0;
    int[] atomsToRotate;

    public DihedralRotator(Molecule m) {
        this.m = m;
        this.ctab = m.getCtab();
        this.crd = MolGeom.getCoordniates(m);
        this.visited = new BitSet(m.getAtomCount());
        this.atomsToRotate = new int[m.getAtomCount()];
    }

    public Molecule rotateTo(double angle, int a1, int a2, int a3, int a4) {
        try {
            double anCurrent = MolGeom.getDihedral(a1, a2, a3, a4, this.crd, true);
            double diff = MolGeom.dihedralDifference(angle, anCurrent);
            this.rotateBy(diff, a1, a2, a3, a4);
        }
        catch (MolGeom.LinearBondAngleException ex) {
            ex.printStackTrace();
        }
        return this.m;
    }

    public Molecule rotateBy(double angle, int a1, int a2, int a3, int a4) {
        this.getAtomsToRotate(a2, a3);
        int[] rot = new int[this.visitedCount];
        for (int i = 0; i < this.visitedCount; ++i) {
            rot[i] = this.atomsToRotate[i];
        }
        MolGeom.rigidRotateQ(this.crd, rot, angle, a2, a3, new double[3]);
        MolGeom.putCoordinates(this.m, this.crd);
        return this.m;
    }

    private void traverseOnBonds(int atom) {
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int neigh = this.ctab[atom][i];
            if (this.visited.get(neigh)) continue;
            this.atomsToRotate[this.visitedCount++] = neigh;
            this.visited.set(neigh, true);
            this.traverseOnBonds(neigh);
        }
    }

    private void getAtomsToRotate(int atom2, int atom3) {
        this.visitedCount = 0;
        this.visited.clear();
        this.visited.set(atom2);
        this.traverseOnBonds(atom3);
    }
}

