/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;

class DistanceRange {
    private double min;
    private double max;
    private Node node1;
    private Node node2;
    private final NodeColor color;

    public DistanceRange(double min, double max, Node node1, Node node2, NodeColor color) {
        this.min = min;
        this.max = max;
        this.node1 = node1;
        this.node2 = node2;
        this.color = color;
    }

    public DistanceRange(NodeColor c) {
        this.node1 = null;
        this.node2 = null;
        this.color = c;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double tanimoto(DistanceRange d) {
        double denom;
        if (this.min < 0.0 || this.max < 0.0) {
            throw new UnsupportedOperationException();
        }
        if (!(this.color.isSameTypeOrBothShapeLabelled(this.node1.getType(), d.getNode1().getType()) && this.color.isSameTypeOrBothShapeLabelled(this.node2.getType(), d.getNode2().getType()) || this.color.isSameTypeOrBothShapeLabelled(this.node2.getType(), d.getNode1().getType()) && this.color.isSameTypeOrBothShapeLabelled(this.node1.getType(), d.getNode2().getType()))) {
            throw new UnsupportedOperationException("type mismatch");
        }
        double minOfMins = this.min;
        double maxOfMins = d.getMin();
        double minOfMaxs = this.max;
        double maxOfMaxs = d.getMax();
        if (this.min > d.getMin()) {
            maxOfMins = this.min;
            minOfMins = d.getMin();
        }
        if (this.max > d.getMax()) {
            maxOfMaxs = this.max;
            minOfMaxs = d.getMax();
        }
        if ((denom = maxOfMaxs - minOfMins) <= 0.0) {
            throw new UnsupportedOperationException();
        }
        double sim = (minOfMaxs - maxOfMins) / denom;
        if (sim < 0.0) {
            sim = 0.0;
        }
        return sim;
    }

    public static boolean section(DistanceRange d0, DistanceRange d1, DistanceRange result) {
        result.setMin(Math.max(d0.getMin(), d1.getMin()));
        result.setMax(Math.min(d0.getMax(), d1.getMax()));
        return !(result.getMax() < result.getMin());
    }

    public static boolean fulfillsTriangleInequality(DistanceRange d0, DistanceRange d1, DistanceRange d2) {
        if (d0.min > d1.max + d2.max) {
            return false;
        }
        if (d1.min > d0.max + d2.max) {
            return false;
        }
        return !(d2.min > d1.max + d0.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Node getNode1() {
        return this.node1;
    }

    public Node getNode2() {
        return this.node2;
    }

    public void setNode1(Node node1) {
        this.node1 = node1;
    }

    public void setNode2(Node node2) {
        this.node2 = node2;
    }

    public String toString() {
        String s = "";
        if (this.node1 != null && this.node2 != null) {
            s = this.node1.getFirstAtomSeq() + " " + this.color.typeLabel(this.node1.getType());
            s = s + " | " + this.node2.getFirstAtomSeq() + " " + this.color.typeLabel(this.node1.getType()) + "\n";
        }
        return s + " min: " + this.min + "\n max: " + this.max;
    }
}

