/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AtomicHistogram;
import chemaxon.marvin.alignment.DistanceRange;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import java.util.BitSet;

class DistanceRangeStore {
    public static double TOLERANCE = 0.2;
    private NodeColor color;
    private Node[] selected;
    private DistanceRange[] ranges;
    private int[][] index;
    private int[] selectedTypes;
    private double bin = 0.3;
    private AtomicHistogram[][] histograms;

    DistanceRangeStore(double[] mins, double[] maxs, NodeColor color, Node[] selected) {
        int n = selected.length;
        int m = n * (n - 1) / 2;
        if (mins.length != maxs.length || mins.length != m) {
            System.err.println(mins.length + " " + maxs.length + " " + m + " " + n);
            throw new UnsupportedOperationException();
        }
        this.selected = selected;
        this.ranges = new DistanceRange[mins.length];
        this.index = new int[selected.length][selected.length];
        int pos = 0;
        for (int i = 0; i < selected.length - 1; ++i) {
            for (int j = i + 1; j < selected.length; ++j) {
                this.ranges[pos] = new DistanceRange(mins[pos] - TOLERANCE, maxs[pos] + TOLERANCE, selected[i], selected[j], color);
                this.index[i][j] = pos;
                this.index[j][i] = pos++;
            }
        }
        BitSet tmp = new BitSet();
        boolean shape = false;
        for (int i = 0; i < selected.length; ++i) {
            int t = color.withoutShapeLabel(selected[i].getType());
            if (color.isSelected(t)) {
                tmp.set(t, true);
            }
            if (!color.isShapeLabelled(selected[i].getType())) continue;
            shape = true;
        }
        int l = tmp.cardinality();
        if (shape) {
            ++l;
        }
        this.selectedTypes = new int[l];
        int c = 0;
        for (int i = 0; i < tmp.length(); ++i) {
            if (!tmp.get(i)) continue;
            this.selectedTypes[c++] = i;
        }
        if (shape) {
            this.selectedTypes[c] = NodeColor.SHAPE;
        }
        this.color = color;
        this.generateHistograms();
    }

    public Node[] getSelected() {
        return this.selected;
    }

    DistanceRange get(int i, int j) {
        return this.ranges[this.index[i][j]];
    }

    private void generateHistograms() {
        this.histograms = new AtomicHistogram[this.selected.length][];
        for (int i = 0; i < this.selected.length; ++i) {
            this.histograms[i] = this.atomicHistograms(i);
        }
    }

    public AtomicHistogram[] getHistogram(int atomIndex) {
        return this.histograms[atomIndex];
    }

    private AtomicHistogram[] atomicHistograms(int atomIndex) {
        AtomicHistogram[] tmp = new AtomicHistogram[this.selectedTypes.length];
        int c = 0;
        for (int j = 0; j < this.selectedTypes.length; ++j) {
            int startMin = -1;
            int stopMax = -1;
            for (int k = 0; k < this.selected.length; ++k) {
                if (k == atomIndex || !this.color.isSameTypeOrBothShapeLabelled(this.selected[k].getType(), this.selectedTypes[j])) continue;
                DistanceRange r = this.get(atomIndex, k);
                int start = (int)Math.floor(r.getMin() / this.bin);
                int stop = (int)Math.ceil(r.getMax() / this.bin);
                if (startMin == -1 || startMin > start) {
                    startMin = start;
                }
                if (stopMax != -1 && stopMax >= stop) continue;
                stopMax = stop;
            }
            if (stopMax == -1) continue;
            ++c;
            int[] histogram = new int[stopMax - startMin];
            for (int k = 0; k < this.selected.length; ++k) {
                if (k == atomIndex || !this.color.isSameTypeOrBothShapeLabelled(this.selected[k].getType(), this.selectedTypes[j])) continue;
                DistanceRange r = this.get(atomIndex, k);
                int start = (int)Math.floor(r.getMin() / this.bin) - startMin;
                int stop = (int)Math.ceil(r.getMax() / this.bin) - startMin;
                int i = start;
                while (i < stop) {
                    int n = i++;
                    histogram[n] = histogram[n] + 1;
                }
            }
            tmp[j] = new AtomicHistogram(this.selectedTypes[j], histogram, this.bin, startMin);
        }
        AtomicHistogram[] ret = new AtomicHistogram[c];
        c = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            ret[c++] = tmp[i];
        }
        return ret;
    }

    public void setBin(double bin) {
        this.bin = bin;
    }

    public NodeColor getColor() {
        return this.color;
    }
}

