/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class ExpandingPotential
implements PotentialFunction {
    double weight;

    public ExpandingPotential(double weight) {
        this.weight = weight;
    }

    @Override
    public double functionValue(double x) {
        return -x * this.weight;
    }

    @Override
    public PotentialType getType() {
        return PotentialType.EXPANDING;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double getTolerance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isOk(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        if (dist < 1.0E-6) {
            throw new UnsupportedOperationException("distance too small");
        }
        return -1.0 * this.weight / dist;
    }
}

