/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

class FFTest
implements ForceFieldInterface {
    ArrayList<Dihedral> dihedrals;

    FFTest() {
    }

    @Override
    public void init(Molecule m) {
    }

    public void setDihedrals(ArrayList<Dihedral> dihedrals) {
        this.dihedrals = dihedrals;
    }

    @Override
    public double[][] optimize() {
        return null;
    }

    @Override
    public void setCoordinates(double[][] crd) {
    }

    @Override
    public double dihedralEnergy(int a1, int a2) {
        for (int i = 0; i < this.dihedrals.size(); ++i) {
            Dihedral dihedral = this.dihedrals.get(i);
            if (dihedral.nB.getFirstAtomSeq() != a1 || dihedral.nC.getFirstAtomSeq() != a2) continue;
            return Math.cos(dihedral.getAngle());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double longRangeEnergy(int a1, int a2) {
        return 0.0;
    }

    @Override
    public double dihedralGradient(int a1, int a2) {
        for (int i = 0; i < this.dihedrals.size(); ++i) {
            Dihedral dihedral = this.dihedrals.get(i);
            if (dihedral.nB.getFirstAtomSeq() != a1 || dihedral.nC.getFirstAtomSeq() != a2) continue;
            return -Math.sin(dihedral.getAngle());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double longRangeGradient(int a1, int a2) {
        return 0.0;
    }
}

