/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.alignment.Alignment;
import chemaxon.marvin.alignment.Status;
import chemaxon.marvin.alignment.Visualizer;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.internals.ChangeCorrector;
import chemaxon.marvin.modelling.struc.MolGeom;

abstract class Function
implements GradientOptimization.FunctionToMinimize {
    double[] gradient;
    double[] variables;
    private int stepLimit;
    private long startTime = -1L;
    private long timeLimit;
    public MProgressMonitor progressMonitor;
    private int progressBarCounter = 0;
    private int progressBarCounterStart;
    int stepCount = 0;
    Visualizer vis;
    Status statusOpt;
    boolean isInsideNumericGradient = false;

    public Function(int stepLimit, int timeLimit) {
        this.stepLimit = stepLimit;
        this.timeLimit = timeLimit;
        this.statusOpt = new Status();
    }

    public abstract void setGr(GradientOptimization var1);

    public void setProgressMonitor(MProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setProgressBarCounterStart(int progressBarCounter) {
        this.progressBarCounterStart = progressBarCounter;
    }

    public void setProgressBarCounter(int progressBarCounter) {
        this.progressBarCounter = progressBarCounter;
    }

    public int getProgressBarCounter() {
        return this.progressBarCounter;
    }

    @Override
    public boolean isCancelled() {
        this.statusOpt.setStepCount(this.stepCount);
        if (this.progressMonitor != null) {
            if (this.progressBarCounter - this.progressBarCounterStart <= Alignment.STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR) {
                ++this.progressBarCounter;
                this.progressMonitor.setProgressValue(this.progressBarCounter);
            }
            if (this.progressMonitor.isCanceled()) {
                return true;
            }
        }
        if (this.stepCount == this.stepLimit) {
            this.statusOpt.setStepLimitReached(true);
            return true;
        }
        if (this.timeLimit > -1L) {
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            } else {
                long t = System.currentTimeMillis() - this.startTime;
                this.statusOpt.setTime(t);
                if (t > this.timeLimit) {
                    this.statusOpt.setTimeLimitReached(true);
                    return true;
                }
            }
        }
        return false;
    }

    void reset() {
        this.update();
        this.getVariables();
    }

    void resetStepCount() {
        this.stepCount = 0;
        this.statusOpt.setStepLimitReached(false);
        this.statusOpt.setTimeLimitReached(false);
    }

    abstract void update();

    @Override
    public void print() {
    }

    public Status getStatusOpt() {
        return this.statusOpt;
    }

    @Override
    public void print(String comment) {
    }

    void setVis(Visualizer vis) {
        this.vis = vis;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public double[] numericDerivate(double[] ret) {
        this.isInsideNumericGradient = true;
        double small = 1.0E-5;
        for (int i = 0; i < ret.length; ++i) {
            double c = this.variables[i];
            int n = i;
            this.variables[n] = this.variables[n] + small;
            this.setVariables(this.variables);
            double e1 = this.getFunctionValue();
            this.variables[i] = c - small;
            this.setVariables(this.variables);
            double e2 = this.getFunctionValue();
            ret[i] = (e1 - e2) / (2.0 * small);
            this.variables[i] = c;
            this.setVariables(this.variables);
        }
        this.isInsideNumericGradient = false;
        return ret;
    }

    void checkGradient() {
        if (Alignment.DEBUG) {
            double diff;
            int i;
            double[] num = new double[this.gradient.length];
            num = this.numericDerivate(num);
            boolean error = false;
            for (i = 0; i < num.length; ++i) {
                if (Double.isNaN(this.gradient[i]) || Double.isNaN(num[i])) {
                    throw new UnsupportedOperationException(i + "th position of gradient is NAN!!");
                }
                if (Double.isInfinite(this.gradient[i]) || Double.isInfinite(num[i])) {
                    throw new UnsupportedOperationException(i + "th position of gradient is Inf!!");
                }
                diff = MolGeom.doubleEquals(num[i], this.gradient[i]);
                double diff2 = Math.abs(Math.max(num[i], this.gradient[i]) - Math.min(num[i], this.gradient[i]));
                if (!(diff > 0.001) || !(diff2 > 1.0E-6)) continue;
                error = true;
            }
            if (error) {
                System.err.println("pos num    anal    diff");
                for (i = 0; i < num.length; ++i) {
                    diff = MolGeom.doubleEquals(this.gradient[i], num[i]);
                    System.err.println(i + " " + num[i] + " " + this.gradient[i] + " " + diff + " " + this.gradient[i] / num[i] + " " + (this.gradient[i] - num[i]));
                }
                throw new UnsupportedOperationException("Gradient error!!");
            }
        }
    }

    public abstract void fillStatus();

    public ChangeCorrector getChangeCorrector() {
        return new ChangeCorrector(){

            @Override
            public double[] correct(double[] steps) {
                return steps;
            }
        };
    }

    static double angleDiff(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (Math.abs(d) > Math.PI) {
            throw new UnsupportedOperationException("d: " + MolGeom.forHumans(d));
        }
        return d;
    }
}

