/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionOneFlexibleMol;
import chemaxon.marvin.alignment.MinMaxConstraint;

class FunctionMinMax
extends FunctionOneFlexibleMol {
    private MinMaxConstraint span;
    private double last = -1.0;
    private double beforeLast = -1.0;
    private static double DIFF = 0.01;

    FunctionMinMax(FlexibleMolecule fm, int stepLimit, int timeLimit, int countStart, MinMaxConstraint span) throws AlignmentException {
        super(fm, stepLimit, timeLimit, countStart);
        this.span = span;
    }

    @Override
    public double[] getFunctionGradient() {
        if (this.beforeLast == -1.0) {
            this.beforeLast = this.span.getDist();
        } else if (this.last == -1.0) {
            this.last = this.span.getDist();
        } else {
            this.beforeLast = this.last;
            this.last = this.span.getDist();
        }
        return super.getFunctionGradient();
    }

    @Override
    public boolean isCancelled() {
        return super.isCancelled();
    }

    @Override
    void reset() {
        super.reset();
        this.last = -1.0;
        this.beforeLast = -1.0;
    }
}

