/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.Function;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import java.util.List;

class FunctionOneFlexibleMol
extends Function {
    private FlexibleMolecule fm;

    FunctionOneFlexibleMol(int stepLimit, int timeLimit, int countStart) {
        super(stepLimit, timeLimit);
    }

    FunctionOneFlexibleMol(FlexibleMolecule fm) throws AlignmentException {
        this(fm, -1, -1, 0);
    }

    FunctionOneFlexibleMol(FlexibleMolecule fm, int stepLimit, int timeLimit, int countStart) throws AlignmentException {
        super(stepLimit, timeLimit);
        this.statusOpt.addStatusMol(fm.getStatus());
        this.fm = fm;
        this.gradient = new double[fm.getDihedrals().size()];
        this.variables = new double[fm.getDihedrals().size()];
        int pos = 0;
        for (Dihedral d : fm.getDihedrals()) {
            d.setPosition(pos);
            pos += d.getLength();
        }
        fm.setEnableTranslateAndRotate(false);
        fm.setOneSideRotationForAllDihedrals(true);
        this.update();
    }

    @Override
    final void update() {
        this.fm.updateIterator();
        this.fm.updateConstraints();
        this.fm.updateForceFieldPotential();
    }

    @Override
    void reset() {
        this.fm.resetProximities();
        super.reset();
    }

    @Override
    public double getFunctionValue() {
        return this.fm.functionValue();
    }

    @Override
    public double[] getFunctionGradient() {
        ++this.stepCount;
        if (this.vis != null) {
            this.vis.showSteps();
        }
        for (int i = 0; i < this.gradient.length; ++i) {
            this.gradient[i] = 0.0;
        }
        this.fm.gradient(this.gradient, null);
        this.checkGradient();
        return this.gradient;
    }

    @Override
    public boolean setVariables(double[] var) {
        this.fm.setVariables(this.variables);
        this.update();
        return true;
    }

    @Override
    public void setGr(GradientOptimization gr) {
    }

    @Override
    public void fillStatus() {
        double f = 0.0;
        List<MolecularConstraint> w = this.fm.getWishes();
        if (w != null) {
            for (MolecularConstraint internal : w) {
                f += internal.getEnergy();
            }
        }
        this.fm.fillWarningInfo();
        this.statusOpt.setConstraintScore(f);
        this.statusOpt.addStatusMol(this.fm.getStatus());
    }

    @Override
    public final double[] getVariables() {
        return this.fm.getVariables(this.variables);
    }

    void setExpandVolume(boolean b) {
        if (b) {
            this.fm.setVolumeSign(-1.0);
        } else {
            this.fm.setVolumeSign(1.0);
        }
    }
}

