/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.GaussianPotential;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class GaussianPotentialDouble
implements PotentialFunction {
    GaussianPotential g1;
    GaussianPotential g2;
    double magic = 0.2;

    public GaussianPotentialDouble(double weight, double tolerance) {
        this.g1 = new GaussianPotential(weight, tolerance);
        this.g2 = new GaussianPotential(weight * this.magic, tolerance * this.magic);
    }

    @Override
    public double functionValue(double x) {
        return this.g1.functionValue(x) + this.g2.functionValue(x);
    }

    @Override
    public double functionDerivateDividedByDist(double x) {
        return this.g1.functionDerivateDividedByDist(x) + this.g2.functionDerivateDividedByDist(x);
    }

    @Override
    public PotentialType getType() {
        return PotentialType.GAUSSIAN_DOUBLE;
    }

    @Override
    public double getWeight() {
        return this.g1.getWeight();
    }

    @Override
    public double getTolerance() {
        return this.g1.getWeight();
    }

    @Override
    public boolean isOk(double x) {
        return this.g2.isOk(x);
    }
}

