/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.Pharmacophore3D;
import chemaxon.marvin.alignment.Visualizable;
import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.util.ShortestPath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class GaussianSum
extends NodeList<MolecularGaussian>
implements Visualizable {
    private int productLimit;
    private List<int[]> acceptedAtomPairs;
    private float margin = 2.0f;
    private float bin = 0.2f;
    private int realAtomCount = 0;
    static final double EXPONENT = 0.3333333333333333;
    static final double PREFACTOR = 0.7884661817128036;
    static final double SCALE = Math.pow(0.6216789197047679, 0.3333333333333333);
    private int[] differentTypes;
    static final double P = 2.7;
    private int multicenterNodeCount = 0;
    private boolean ringNodeEnabled = false;
    private float scaleVis = 1.0f;
    private boolean visualizeSelectedNodesOnly = false;

    public static GaussianSum create(int molID, Molecule m, double[][] crd, AlignmentProperties.NodeType gc, int[] atomTypes, NodeColor c, int ringSizeForCenters) {
        if (gc == AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST) {
            return GaussianSum.createSimple(molID, m, crd, 2, 2, 2.7, atomTypes, false, c, ringSizeForCenters);
        }
        if (gc == AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FULL) {
            return GaussianSum.createSimple(molID, m, crd, 1, Integer.MAX_VALUE, 2.7, atomTypes, false, c, ringSizeForCenters);
        }
        if (gc == AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_45) {
            GaussianSum gs = GaussianSum.createSimple(molID, m, crd, 4, 5, 2.7, atomTypes, true, c, ringSizeForCenters);
            return gs;
        }
        if (gc == AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_44) {
            GaussianSum gs = GaussianSum.createSimple(molID, m, crd, 4, 4, 2.7, atomTypes, true, c, ringSizeForCenters);
            return gs;
        }
        throw new IllegalStateException();
    }

    @Override
    public void setScaleVis(float scaleVis) {
        this.scaleVis = scaleVis;
    }

    public void setRingNodeEnabled(boolean ringNodeEnabled) {
        this.ringNodeEnabled = ringNodeEnabled;
        this.calcDifferentTypes();
    }

    public boolean isRingNodeEnabled() {
        return this.ringNodeEnabled;
    }

    public boolean isVisualizeSelectedNodesOnly() {
        return this.visualizeSelectedNodesOnly;
    }

    public void setVisualizeSelectedNodesOnly(boolean visualizeSelectedNodesOnly) {
        this.visualizeSelectedNodesOnly = visualizeSelectedNodesOnly;
    }

    public static GaussianSum createSimple(int molID, Molecule m, double[][] crd, int acceptNeighbor, int acceptProduct, double p, int[] atomTypes, boolean hydrogenFilter, NodeColor c, int ringSizeForCenters) {
        ShortestPath sp = new ShortestPath();
        sp.calculate(m);
        Molecule m2 = null;
        if (hydrogenFilter) {
            m2 = m;
        }
        List<int[]> acceptedAtomPairs = GaussianSum.acceptPairs(m.getAtomCount(), sp, acceptNeighbor, m2);
        GaussianSum v = new GaussianSum(acceptProduct, acceptedAtomPairs, c);
        if (atomTypes != null && m.getAtomCount() != atomTypes.length) {
            throw new IllegalStateException();
        }
        double lambda = 1.7671458676442586 * p * p;
        lambda = Math.pow(lambda, 0.3333333333333333);
        for (int j = 0; j < m.getAtomCount(); ++j) {
            double vdw = PeriodicSystem.getVanDerWaalsRadius(m.getAtom(j).getAtno());
            if (m.getAtom(j).getAtno() == 130) {
                vdw = 1.5;
            }
            double alpha = lambda / (vdw * vdw);
            int att = 0;
            if (atomTypes != null) {
                att = atomTypes[j];
            }
            AtomicGaussian a = new AtomicGaussian(p, alpha, crd[j], j, molID, att, m.getAtom(j).getAtno());
            a.setVanDerWaalsRadius(vdw);
            v.add(a);
            v.updateMargin(vdw);
        }
        v.sort();
        v.realAtomCount = m.getAtomCount();
        v.multicenterNodeCount = 0;
        if (ringSizeForCenters > 2) {
            v.addRingCenterNodes(m, ringSizeForCenters);
        }
        v.addSymmetricMulticenterNodes(m);
        return v;
    }

    @Override
    public void initSelectionAndTypes() {
        this.setSelectedNodes();
        this.calcDifferentTypes();
    }

    private void addRingCenterNodes(Molecule m, int ringSize) {
        double p = 2.7;
        double lambda = 1.7671458676442586 * p * p;
        lambda = Math.pow(lambda, 0.3333333333333333);
        double vdw = 1.41;
        double alpha = lambda / (vdw * vdw);
        TopologyAnalyser top = new TopologyAnalyser();
        top.setLicenseEnvironment("3D Alignment");
        top.setMolecule(m, 1);
        int[][] ringAromatic = top.aromaticRings();
        if (ringAromatic != null) {
            for (int i = 0; i < ringAromatic.length; ++i) {
                AtomicGaussian[] ringNodes = new AtomicGaussian[ringAromatic[i].length];
                for (int j = 0; j < ringNodes.length; ++j) {
                    ringNodes[j] = (AtomicGaussian)this.get(ringAromatic[i][j]);
                }
                int ringCenterType = Pharmacophore3D.AROMATIC_RINGCENTER;
                MultiCenterGaussian a = new MultiCenterGaussian(((MolecularGaussian)this.sum.get(0)).getMolID(), p, alpha, ringNodes, ringCenterType, this.sum.size());
                a.setVanDerWaalsRadius(vdw);
                this.sum.add(a);
                ++this.multicenterNodeCount;
            }
        }
        for (int rs = 3; rs < ringSize; ++rs) {
            int[][] ringAliphatic = top.aliphaticRings(rs);
            if (ringAliphatic == null) continue;
            for (int i = 0; i < ringAliphatic.length; ++i) {
                AtomicGaussian[] ringNodes = new AtomicGaussian[ringAliphatic[i].length];
                for (int j = 0; j < ringNodes.length; ++j) {
                    ringNodes[j] = (AtomicGaussian)this.get(ringAliphatic[i][j]);
                }
                int ringCenterType = Pharmacophore3D.ALIPHATIC_RINGCENTER;
                MultiCenterGaussian a = new MultiCenterGaussian(((MolecularGaussian)this.sum.get(0)).getMolID(), p, alpha, ringNodes, ringCenterType, this.sum.size());
                a.setVanDerWaalsRadius(vdw);
                this.sum.add(a);
                ++this.multicenterNodeCount;
            }
        }
    }

    private void addSymmetricMulticenterNodes(Molecule m) {
        int[][] ctab = m.getCtab();
        for (int i = 0; i < this.realAtomCount; ++i) {
            int j;
            if (ctab[i].length <= 1) continue;
            int max = 0;
            ArrayList<TypeCount> tc = new ArrayList<TypeCount>();
            for (j = 0; j < ctab[i].length; ++j) {
                AtomicGaussian aj = (AtomicGaussian)this.sum.get(ctab[i][j]);
                int type = this.color.withoutShapeLabel(aj.getType());
                if (!this.color.isSelected(type)) continue;
                boolean added = false;
                for (int k = 0; k < tc.size() && !added; ++k) {
                    TypeCount typeCount = (TypeCount)tc.get(k);
                    if (typeCount.type != type) continue;
                    added = true;
                    ++typeCount.count;
                    if (max >= typeCount.count) continue;
                    max = typeCount.count;
                }
                if (added) continue;
                tc.add(new TypeCount(type));
            }
            if (max <= true) continue;
            for (j = 0; j < tc.size(); ++j) {
                TypeCount typeCount = (TypeCount)tc.get(j);
                if (typeCount.count <= 1) continue;
                AtomicGaussian[] ags = new AtomicGaussian[typeCount.count];
                int pos = 0;
                double alpha = 0.0;
                int type = 0;
                int orig = 0;
                double vdw = 0.0;
                for (int k = 0; k < ctab[i].length; ++k) {
                    AtomicGaussian agk = (AtomicGaussian)this.sum.get(ctab[i][k]);
                    int typeK = this.color.withoutShapeLabel(agk.getType());
                    if (typeK != typeCount.type) continue;
                    ags[pos++] = agk;
                    alpha = agk.a;
                    type = typeK;
                    orig = agk.getOriginalAtomType();
                    vdw = agk.getVanDerWaalsRadius();
                }
                MultiCenterGaussian mu = new MultiCenterGaussian(((MolecularGaussian)this.sum.get((int)0)).molID, 2.7, alpha, ags, type, this.sum.size());
                mu.setOriginalAtomType(orig);
                mu.setVanDerWaalsRadius(vdw);
                this.sum.add(mu);
                ++this.multicenterNodeCount;
            }
        }
    }

    private void setSelectedNodes() {
        for (int i = 0; i < this.realAtomCount; ++i) {
            AtomicGaussian ag = (AtomicGaussian)this.sum.get(i);
            ag.setSelected(this.color.isSelected(ag.getType()));
        }
        for (int j = this.sum.size() - this.multicenterNodeCount; j < this.sum.size(); ++j) {
            MultiCenterGaussian a1 = (MultiCenterGaussian)this.sum.get(j);
            if (this.color.isSameType(a1.getType(), Pharmacophore3D.ALIPHATIC_RINGCENTER) || this.color.isSameType(a1.getType(), Pharmacophore3D.AROMATIC_RINGCENTER)) continue;
            for (AtomicGaussian a : a1.getMembers()) {
                a.setSelected(false);
            }
        }
    }

    public void bigSoft(boolean b) {
        for (int i = 0; i < this.sum.size(); ++i) {
            MolecularGaussian mg = (MolecularGaussian)this.sum.get(i);
            mg.bigAndSoft(b);
        }
    }

    @Override
    public int getRealAtomCount() {
        return this.realAtomCount;
    }

    public int getMulticenterNodeCount() {
        return this.multicenterNodeCount;
    }

    private void makeTripleCorrection() {
        int stop = this.sum.size();
        BitSet iBits = new BitSet();
        BitSet jBits = new BitSet();
        for (int i = 0; i < stop - 1; ++i) {
            if (((MolecularGaussian)this.sum.get(i)).getMemberCount() != 2) continue;
            for (int j = i + 1; j < stop; ++j) {
                if (((MolecularGaussian)this.sum.get(i)).getMemberCount() != 2) continue;
                MolecularGaussianProduct mi = (MolecularGaussianProduct)this.sum.get(i);
                MolecularGaussianProduct mj = (MolecularGaussianProduct)this.sum.get(j);
                iBits.clear();
                jBits.clear();
                mi.markAtoms(iBits);
                mj.markAtoms(jBits);
                iBits.and(jBits);
                if (iBits.cardinality() != 1) continue;
                jBits.xor(iBits);
                AtomicGaussian a = (AtomicGaussian)this.get(jBits);
                MolecularGaussianProduct prod = MolecularGaussianProduct.create(a, mi);
                if (prod == null) continue;
                this.sum.add(prod);
            }
        }
    }

    @Override
    public int[] getDifferentTypes() {
        return this.differentTypes;
    }

    private void calcDifferentTypes() {
        if (this.getRealAtomCount() == 0) {
            throw new IllegalStateException();
        }
        BitSet singleTypes = new BitSet();
        for (int i = 0; i < this.getRealAtomCount(); ++i) {
            this.color.markSingleTypes(singleTypes, ((MolecularGaussian)this.sum.get(i)).getType());
        }
        boolean arom = false;
        boolean aliph = false;
        for (int i = this.sum.size() - this.multicenterNodeCount; i < this.sum.size(); ++i) {
            MultiCenterGaussian mu = (MultiCenterGaussian)this.sum.get(i);
            if (NodeColor.isAliphaticRingCenter(mu.getType())) {
                aliph = true;
            }
            if (!NodeColor.isAromaticRingCenter(mu.getType())) continue;
            arom = true;
        }
        int typeCount = singleTypes.cardinality();
        if (arom) {
            ++typeCount;
        }
        if (aliph) {
            ++typeCount;
        }
        this.differentTypes = new int[typeCount];
        typeCount = 0;
        for (int i = 0; i < singleTypes.length(); ++i) {
            if (!singleTypes.get(i)) continue;
            this.differentTypes[typeCount++] = i;
        }
        if (arom) {
            this.differentTypes[typeCount++] = Pharmacophore3D.AROMATIC_RINGCENTER;
        }
        if (aliph) {
            this.differentTypes[typeCount++] = Pharmacophore3D.ALIPHATIC_RINGCENTER;
        }
        for (MolecularGaussian mg : this.sum) {
            if (!(mg instanceof MolecularGaussianProduct)) continue;
            MolecularGaussianProduct p = (MolecularGaussianProduct)mg;
            double[] typeScales = new double[this.differentTypes.length];
            for (int j = 0; j < this.differentTypes.length; ++j) {
                typeCount = 0;
                for (int i = 0; i < p.members.length(); ++i) {
                    if (!p.members.get(i)) continue;
                    AtomicGaussian ag = (AtomicGaussian)this.sum.get(i);
                    if (ag.getMolID() != p.getMolID()) {
                        throw new IllegalStateException();
                    }
                    if (!this.color.isSameType(ag.getType(), this.differentTypes[j])) continue;
                    ++typeCount;
                }
                typeScales[j] = (double)typeCount / (double)p.members.cardinality();
            }
            p.setPossibleTypes(this.differentTypes);
            p.setTypeScales(typeScales);
        }
    }

    private static boolean acceptCriteriumHydrogen(Molecule m, int i, int j) {
        if (m.getAtom(i).getAtno() == 1 || m.getAtom(j).getAtno() == 1) {
            int hIndex = -1;
            int other = -1;
            if (m.getAtom(i).getAtno() == 1) {
                hIndex = i;
                other = j;
            }
            if (m.getAtom(j).getAtno() == 1) {
                hIndex = j;
                other = i;
            }
            return m.getCtab()[hIndex][0] == other;
        }
        return true;
    }

    private static List<int[]> acceptPairs(int atomCount, ShortestPath sp, int acceptLimit, Molecule m) {
        if (acceptLimit == 1) {
            return null;
        }
        ArrayList<int[]> acceptedAtomPairs = new ArrayList<int[]>();
        for (int i = 0; i < atomCount - 1; ++i) {
            for (int j = i + 1; j < atomCount; ++j) {
                int n;
                boolean hAcc = true;
                if (m != null && !GaussianSum.acceptCriteriumHydrogen(m, i, j)) {
                    hAcc = false;
                }
                if (!hAcc || (n = sp.minDist(i, j)) >= acceptLimit) continue;
                acceptedAtomPairs.add(new int[]{i, j});
            }
        }
        return acceptedAtomPairs;
    }

    private GaussianSum(int evalLimit, List<int[]> acceptedAtomPairs, NodeColor c) {
        super(c);
        this.productLimit = evalLimit;
        this.acceptedAtomPairs = acceptedAtomPairs;
        this.sum = new ArrayList();
    }

    public String toString() {
        String s = "";
        for (MolecularGaussian g : this.sum) {
            s = s + g.toString() + "\n";
        }
        return s;
    }

    public void updateMargin(double vdw) {
        if ((double)this.margin < vdw) {
            this.margin = (float)(vdw + 0.1);
        }
    }

    @Override
    public void add(AtomicGaussian g) {
        if ((double)this.margin < g.getA()) {
            this.margin = (float)(g.getA() + 0.1);
        }
        int count = 0;
        int max = this.sum.size();
        while (count < max) {
            MolecularGaussianProduct prod;
            MolecularGaussian gs;
            if ((gs = (MolecularGaussian)this.sum.get(count++)).getMemberCount() >= this.productLimit || !this.isAcceptable(g, gs) || (prod = MolecularGaussianProduct.create(g, gs)) == null) continue;
            this.sum.add(prod);
        }
        this.sum.add(g);
        ++this.realAtomCount;
    }

    public void sort() {
        Collections.sort(this.sum, new SumComparator());
    }

    private boolean isAcceptable(AtomicGaussian ga, MolecularGaussian mg) {
        if (this.acceptedAtomPairs == null) {
            return true;
        }
        int a2 = ga.getFirstAtomSeq();
        int a1 = mg.getFirstAtomSeq();
        int c = 0;
        while (a1 != -1) {
            for (int i = 0; i < this.acceptedAtomPairs.size(); ++i) {
                int[] a = this.acceptedAtomPairs.get(i);
                if (a[0] == a1 && a[1] == a2) {
                    ++c;
                }
                if (a[1] != a1 || a[0] != a2) continue;
                ++c;
            }
            a1 = mg.getNextAtomSeq();
        }
        return c == mg.getMemberCount();
    }

    public double integral() {
        double integral = 0.0;
        for (MolecularGaussian g : this.sum) {
            if (g instanceof MultiCenterGaussian && !this.ringNodeEnabled) continue;
            integral += g.integral();
        }
        return integral;
    }

    public double integral(int type) {
        double integral = 0.0;
        for (MolecularGaussian g : this.sum) {
            if (g instanceof MultiCenterGaussian && !this.ringNodeEnabled) continue;
            double tw = g.getTypeScale(type, this.color);
            integral += g.integral() * tw;
        }
        return integral;
    }

    public double value(double[] crdPos) {
        double val = 0.0;
        for (MolecularGaussian g : this.sum) {
            if (!this.visualizeSelectedNodesOnly) {
                if (g instanceof MultiCenterGaussian && !this.ringNodeEnabled) continue;
                val += g.getValue(crdPos) * (double)this.scaleVis;
                continue;
            }
            if (!g.isSelected()) continue;
            val += g.getValue(crdPos) * (double)this.scaleVis;
        }
        return val;
    }

    public void updateGaussianProducts() {
        for (int i = this.realAtomCount; i < this.sum.size() - this.multicenterNodeCount; ++i) {
            MolecularGaussianProduct p = (MolecularGaussianProduct)this.sum.get(i);
            p.update();
        }
    }

    public void updateRingCenters() {
        for (int i = this.sum.size() - this.multicenterNodeCount; i < this.sum.size(); ++i) {
            MultiCenterGaussian p = (MultiCenterGaussian)this.sum.get(i);
            p.update();
        }
    }

    public double value(double[] crdPos, int type, NodeColor c) {
        double val = 0.0;
        for (MolecularGaussian g : this.sum) {
            if (!this.visualizeSelectedNodesOnly) {
                if (g instanceof MultiCenterGaussian && !this.ringNodeEnabled) continue;
                if (g.isRealAtom() && c.isSameType(type, g.getType())) {
                    val += g.getValue(crdPos) * (double)this.scaleVis;
                }
                if (g.isRealAtom()) continue;
                MolecularGaussianProduct p = (MolecularGaussianProduct)g;
                double scale = g.getTypeScale(type, c);
                if (!(scale > 0.0)) continue;
                val += g.getValue(crdPos) * scale * (double)this.scaleVis;
                continue;
            }
            if (!g.isSelected() || !c.isSameType(type, g.getType())) continue;
            val += g.getValue(crdPos) * (double)this.scaleVis;
        }
        return val;
    }

    @Override
    public void setBin(float bin) {
        this.bin = bin;
    }

    @Override
    public void setMargin(float margin) {
        this.margin = margin;
    }

    @Override
    public VolumetricData volData(int type) {
        double[] crdPos = new double[3];
        float[] step = new float[]{this.bin, this.bin, this.bin};
        float[][] axes = new float[][]{{this.bin, 0.0f, 0.0f}, {0.0f, this.bin, 0.0f}, {0.0f, 0.0f, this.bin}};
        float[] origo = new float[3];
        origo[0] = (float)(this.getMinMax(0, false, type) - (double)this.margin);
        double maxX = this.getMinMax(0, true, type) + (double)this.margin;
        origo[1] = (float)(this.getMinMax(1, false, type) - (double)this.margin);
        double maxY = this.getMinMax(1, true, type) + (double)this.margin;
        origo[2] = (float)(this.getMinMax(2, false, type) - (double)this.margin);
        double maxZ = this.getMinMax(2, true, type) + (double)this.margin;
        int sizeX = (int)((maxX - (double)origo[0]) / (double)this.bin);
        int sizeY = (int)((maxY - (double)origo[1]) / (double)this.bin);
        int sizeZ = (int)((maxZ - (double)origo[2]) / (double)this.bin);
        int tot = sizeZ * sizeY * sizeX;
        System.err.println("total gridpoint : " + tot);
        System.err.println("Color: " + this.color.typeLabel(type));
        int c = 0;
        float[][][] grid = new float[sizeZ][sizeY][sizeX];
        double last = Double.MAX_VALUE;
        DecimalFormat d = new DecimalFormat("0.");
        for (int ix = 0; ix < sizeX; ++ix) {
            crdPos[0] = origo[0] + (float)ix * this.bin;
            for (int iy = 0; iy < sizeY; ++iy) {
                crdPos[1] = origo[1] + (float)iy * this.bin;
                for (int iz = 0; iz < sizeZ; ++iz) {
                    crdPos[2] = origo[2] + (float)iz * this.bin;
                    if (type != -1) {
                        double v = this.value(crdPos, type, this.color);
                        grid[iz][iy][ix] = (float)v;
                    } else {
                        grid[iz][iy][ix] = (float)this.value(crdPos);
                    }
                    double per = (double)(++c) / (double)tot * 100.0;
                    if (per % 10.0 < last) {
                        System.err.println(d.format(per) + "%");
                    }
                    last = per % 10.0;
                }
            }
        }
        crdPos = null;
        VolumetricData g = new VolumetricData(axes, step, origo, grid);
        return g;
    }

    @Override
    boolean isAssigned(int i) {
        if (i < this.realAtomCount) {
            return this.assigned.get(i);
        }
        MolecularGaussianProduct p = (MolecularGaussianProduct)this.sum.get(i);
        BitSet tmp = new BitSet();
        tmp.or(p.members);
        tmp.and(this.assigned);
        return tmp.cardinality() > 0;
    }

    @Override
    public MolecularGaussian get(BitSet b) {
        if (b.cardinality() == 0) {
            throw new IllegalStateException();
        }
        if (b.cardinality() == 1) {
            AtomicGaussian a = (AtomicGaussian)this.sum.get(b.length() - 1);
            if (a.getFirstAtomSeq() != b.length() - 1) {
                throw new IllegalStateException();
            }
            return a;
        }
        for (int i = this.realAtomCount; i < this.sum.size(); ++i) {
            MolecularGaussianProduct p = (MolecularGaussianProduct)this.sum.get(i);
            if (!b.equals(p.members)) continue;
            return p;
        }
        return null;
    }

    private static class SumComparator
    implements Comparator<MolecularGaussian> {
        private SumComparator() {
        }

        @Override
        public int compare(MolecularGaussian o1, MolecularGaussian o2) {
            if (o1.getMemberCount() < o2.getMemberCount()) {
                return -1;
            }
            if (o1.getMemberCount() > o2.getMemberCount()) {
                return 1;
            }
            if (o1.isRealAtom() && o2.isRealAtom()) {
                int a2;
                int a1 = o1.getFirstAtomSeq();
                if (a1 < (a2 = o2.getFirstAtomSeq())) {
                    return -1;
                }
                if (a1 > a2) {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class TypeCount {
        int type;
        int count = 1;

        public TypeCount(int type) {
            this.type = type;
        }

        public String toString() {
            return GaussianSum.this.color.typeLabel(this.type) + " count: " + this.count;
        }
    }
}

