/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AtomicHistogram;
import chemaxon.marvin.alignment.DistanceRangeStore;
import chemaxon.marvin.alignment.Node;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class HistogramPlotter {
    public static final String GNUPLOT_LOCATION = "C:\\cygwin\\bin\\gnuplot.exe";
    private int sizeX = 1600;
    private int sizeY = 500;
    private boolean nonZeroOnly = false;
    private int fontSize = 20;
    private final String HEADER = "set key under nobox\nset auto x\n#set tics font \"Arial," + this.fontSize + "\"\n" + "set grid y\n" + "set boxwidth 2 relative\n" + "set style data histograms\n" + "set style fill solid noborder\n" + "set xlabel \"Distance range bins \"\n" + "set ylabel \"Frequency\"\n";
    private AtomicHistogram[] histograms;
    private DistanceRangeStore ds;
    private int maxValue = -1;
    private int minmin = -1;
    private int maxmax = -1;

    HistogramPlotter(DistanceRangeStore ds) {
        this.ds = ds;
        Node[] s = ds.getSelected();
        for (int ni = 0; ni < s.length; ++ni) {
            AtomicHistogram[] ah = ds.getHistogram(ni);
            for (int i = 0; i < ah.length; ++i) {
                AtomicHistogram a = ah[i];
                if (this.minmin == -1 || a.getMinBin() < this.minmin) {
                    this.minmin = a.getMinBin();
                }
                if (this.maxmax == -1 || a.getMaxBin() > this.maxmax) {
                    this.maxmax = a.getMaxBin();
                }
                for (int bin = a.getMinBin(); bin < a.getMaxBin(); ++bin) {
                    int v = ah[i].getValue(bin);
                    if (this.maxValue != -1 && this.maxValue >= v) continue;
                    this.maxValue = v;
                }
            }
        }
        ++this.maxValue;
    }

    private boolean isNonZeroOnly() {
        return this.nonZeroOnly;
    }

    private void setNonZeroOnly(boolean nonZeroOnly) {
        this.nonZeroOnly = nonZeroOnly;
    }

    private String createGNUPlotScript() {
        return this.createGNUPlotScript(null);
    }

    private String createGNUPlotScript(String filename) {
        int i;
        StringBuilder sb = new StringBuilder(this.HEADER);
        AtomicHistogram[] ah = this.ds.getHistogram(0);
        if (filename != null) {
            String[] a = filename.split("[.]");
            String ext = a[a.length - 1];
            String terminal = "postscript";
            terminal = ext;
            sb.append("set terminal ").append(terminal).append(" transparent size ");
            sb.append(this.sizeX).append(",").append(this.sizeY).append("\nset output '");
            sb.append(filename).append("'\n");
        }
        for (int i2 = 0; i2 < ah.length; ++i2) {
            AtomicHistogram a = ah[i2];
            if (this.minmin == -1 || a.getMinBin() < this.minmin) {
                this.minmin = a.getMinBin();
            }
            if (this.maxmax != -1 && a.getMaxBin() <= this.maxmax) continue;
            this.maxmax = a.getMaxBin();
        }
        boolean c = false;
        for (i = 0; i < ah.length; ++i) {
            DecimalFormat df = new DecimalFormat("0.0");
            for (int bin = this.minmin; bin < this.maxmax; ++bin) {
                int v = ah[i].getValue(bin);
                if (this.maxValue == -1 || this.maxValue < v) {
                    this.maxValue = v;
                }
                String dist = df.format(ah[i].getBinsize() * (double)bin);
                if (i == ah.length - 1 && bin != ah[i].getMaxBin() - 1) continue;
            }
        }
        ++this.maxValue;
        sb.append("set yrange [0:").append(this.maxValue).append("]\n");
        sb.append("plot \\\n");
        for (i = 0; i < ah.length; ++i) {
            String title = this.ds.getColor().typeLabel(ah[i].getType());
            sb.append("newhistogram \"\", '-' ti \"").append(title).append("\"");
            if (i < ah.length - 1) {
                sb.append(",\\\n");
                continue;
            }
            sb.append("\n");
        }
        for (i = 0; i < ah.length; ++i) {
            AtomicHistogram a = ah[i];
            for (int j = this.minmin; j < this.maxmax; ++j) {
                sb.append(a.getValue(j)).append("\n");
            }
            sb.append("e\n");
        }
        if (filename != null) {
            String gnu = filename.split("[.]")[0] + ".gp";
            HistogramPlotter.write(gnu, sb.toString());
        }
        return sb.toString();
    }

    public String createGNUPlotScript2(int atom, String basename) {
        AtomicHistogram a;
        int i;
        AtomicHistogram[] ah = this.ds.getHistogram(atom);
        StringBuilder sb = new StringBuilder();
        String ext = "emf";
        if (basename != null) {
            sb.append("set term emf font 'Arial,").append(this.fontSize).append("\"\n");
            sb.append("set output '").append(basename).append(".").append(ext).append("'\n");
        }
        sb.append("set tmargin 0\n");
        sb.append("set bmargin 0\n");
        sb.append("set lmargin 8\n");
        sb.append("set rmargin 1\n");
        sb.append("unset xtics\n");
        sb.append("set ytics nomirror\n");
        sb.append("set key autotitle column nobox samplen 1\n");
        sb.append("set style data boxes\n");
        sb.append("set style fill solid\n");
        sb.append("set ytics font \"Arial,").append(this.fontSize).append("\"\n");
        Node n = this.ds.getSelected()[atom];
        String atomInfo = "Atom: " + n.getFirstAtomSeq() + " type: " + this.ds.getColor().typeLabel(n.getType());
        System.err.println(atomInfo);
        for (i = 0; i < ah.length; ++i) {
            a = ah[i];
            if (this.minmin == -1 || a.getMinBin() < this.minmin) {
                this.minmin = a.getMinBin();
            }
            if (this.maxmax == -1 || a.getMaxBin() > this.maxmax) {
                this.maxmax = a.getMaxBin();
            }
            for (int bin = a.getMinBin(); bin < a.getMaxBin(); ++bin) {
                int v = ah[i].getValue(bin);
                if (this.maxValue != -1 && this.maxValue >= v) continue;
                this.maxValue = v;
            }
        }
        sb.append("set ytics 0, 1, ").append(this.maxValue - 1).append("\n");
        sb.append("set yrange [0:").append(this.maxValue).append("]\n");
        sb.append("set multiplot layout ").append(ah.length + 2).append(", 1 title \"" + atomInfo + "\"\n");
        for (i = 0; i < ah.length; ++i) {
            if (i == (int)((double)(ah.length - 1) / 2.0)) {
                sb.append("set ylabel \"Frequency\"\n");
            } else {
                sb.append("unset ylabel \n");
            }
            if (i == ah.length - 1) {
                sb.append("set xtics font \"Arial,").append(this.fontSize).append("\"\n");
                sb.append("set xtics nomirror out\n");
                sb.append("set xlabel \"Distance ranges (Angstrom) \"\n");
            }
            a = ah[i];
            sb.append("set style fill solid ").append(a.getType()).append(" \n");
            String key = this.ds.getColor().typeLabel(a.getType());
            sb.append("plot '-' lt ").append(a.getType() - 1).append("  \n");
            sb.append("key ").append(key).append("\n");
            for (int j = this.minmin; j < this.maxmax; ++j) {
                sb.append((double)j * a.getBinsize()).append(" ").append(a.getValue(j)).append("\n");
            }
            sb.append("e\n");
        }
        if (basename != null) {
            String gnu = basename + ".gp";
            HistogramPlotter.write(gnu, sb.toString());
            try {
                HistogramPlotter.callGnuPlot(gnu);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        sb.append("unset multiplot\n");
        return sb.toString();
    }

    public static void callGnuPlot(String filename) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("C:\\cygwin\\bin\\gnuplot.exe " + filename);
        process.waitFor();
        OutputStream stdin = process.getOutputStream();
        InputStream stderr = process.getErrorStream();
        InputStream stdout = process.getInputStream();
        String line = null;
        BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(stderr));
        while ((line = brCleanUp.readLine()) != null) {
            System.out.println("[Stderr] " + line);
        }
        brCleanUp.close();
    }

    public static void write(String filename, String content) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write(content);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ShowPNG
    extends JFrame {
        ShowPNG(String arg) {
            JPanel panel = new JPanel();
            panel.setSize(500, 640);
            this.setDefaultCloseOperation(2);
            ImageIcon icon = new ImageIcon(arg);
            JLabel label = new JLabel();
            label.setIcon(icon);
            panel.add(label);
            this.getContentPane().add(panel);
            this.pack();
            this.setVisible(true);
        }
    }
}

