/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.InternalBowlPotential;
import chemaxon.marvin.alignment.Mappable;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.QuadraticPotential;
import java.text.DecimalFormat;

class IntraMolDistanceConstraint
extends MolecularConstraint
implements Mappable {
    private int p1ID;
    private int p2ID;
    boolean disabledByRing = false;

    public IntraMolDistanceConstraint(int p1ID, int p2ID, PotentialFunction pot) {
        super((Node)null, (Node)null, pot);
        this.p1ID = p1ID;
        this.p2ID = p2ID;
    }

    public int getP1ID() {
        return this.p1ID;
    }

    public int getP2ID() {
        return this.p2ID;
    }

    @Override
    public String toString() {
        DecimalFormat df = new DecimalFormat("0.000");
        return super.toString() + " Tolerance: " + this.getTolerance() + " Disabled:" + this.disabledByRing;
    }

    public double getMSDComponent() {
        double dist0 = 0.0;
        if (this.pot instanceof QuadraticPotential) {
            QuadraticPotential q = (QuadraticPotential)this.pot;
            dist0 = q.getR0();
        }
        if (this.pot instanceof InternalBowlPotential) {
            InternalBowlPotential b = (InternalBowlPotential)this.pot;
            dist0 = b.getDist0();
        }
        this.calcDist();
        double x = this.dist - dist0;
        return x * x;
    }

    public boolean couldFind(int id1, int id2) {
        return id1 == this.p1ID && id2 == this.p2ID || id2 == this.p1ID && id1 == this.p2ID;
    }

    @Override
    public boolean tryToMap(Node aa, int pID) throws AlignmentException {
        if (!aa.isRealAtom()) {
            throw new AlignmentException("Map real atoms only.");
        }
        if (pID == this.p1ID) {
            this.node1 = aa;
            if (this.node2 != null && this.node2.getMolID() != this.node1.getMolID()) {
                throw new AlignmentException("MolId of the two endponints of the intermolecular distace must be equal");
            }
            return true;
        }
        if (pID == this.p2ID) {
            this.node2 = aa;
            if (this.node1 != null && this.node2.getMolID() != this.node1.getMolID()) {
                throw new AlignmentException("MolId of the two endponints of the intermolecular distace must be equal");
            }
            return true;
        }
        return false;
    }

    public double getTolerance() {
        return this.pot.getTolerance();
    }

    @Override
    public double getEnergy() {
        if (this.disabledByRing) {
            return 0.0;
        }
        return super.getEnergy();
    }

    @Override
    public double derivateDividedByDist() {
        if (this.disabledByRing) {
            return 0.0;
        }
        return super.derivateDividedByDist();
    }

    public void setDisabledByRing(boolean disabledByRing) {
        this.disabledByRing = disabledByRing;
    }

    public boolean isDisabledByRing() {
        return this.disabledByRing;
    }

    @Override
    public void reset() {
        this.node1 = null;
        this.node2 = null;
        this.update();
    }
}

