/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.ExpandingPotential;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.QuadraticPotential;

class MinMaxConstraint
extends MolecularConstraint {
    private QuadraticPotential qp;
    private ExpandingPotential ep;

    public MinMaxConstraint(double vdw) {
        double weight = 1.0;
        this.qp = new QuadraticPotential(vdw, weight, 0.0);
        this.ep = new ExpandingPotential(weight);
        this.pot = this.ep;
    }

    public void setDist0(double dist0) {
        if (dist0 == -1.0) {
            this.pot = this.ep;
        } else {
            this.qp.setR0(dist0);
            this.pot = this.qp;
        }
    }

    public boolean isExtend() {
        return this.getPotentialType() == PotentialType.EXPANDING;
    }

    @Override
    public String toString() {
        return super.toString() + " isExtend: " + this.isExtend() + " weight : " + this.pot.getWeight();
    }

    public void setAtom1(Node atom) {
        this.node1 = atom;
    }

    public void setAtom2(Node atom) {
        this.node2 = atom;
    }

    public void resetNodes() {
        this.node1 = null;
        this.node2 = null;
    }
}

