/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import java.text.DecimalFormat;

class MinmaxMatrix {
    private String[][] a;
    private DecimalFormat df = new DecimalFormat("0.00");

    MinmaxMatrix(String[] headers) {
        int count = headers.length + 1;
        this.a = new String[count][count];
        for (int i = 1; i < count; ++i) {
            this.a[0][i] = headers[i - 1];
            this.a[i][0] = headers[i - 1];
        }
    }

    void add(int i, int j, double min, double max) {
        if (i != j) {
            String s;
            this.a[i + 1][j + 1] = s = this.df.format(min) + ";" + this.df.format(max);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.a.length; ++i) {
            for (int j = 0; j < this.a[i].length; ++j) {
                String s = this.a[i][j];
                sb.append(s).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

