/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Gaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.modelling.struc.MolGeom;

abstract class MolecularGaussian
extends Gaussian
implements Node {
    public static final double BLUR = 10.0;
    int molID;
    private boolean centeringMember = false;

    MolecularGaussian(int molID, double p, double alpha, double[] crd) {
        super(p, alpha, crd);
        this.molID = molID;
    }

    MolecularGaussian(int molID) {
        this.molID = molID;
    }

    public abstract int getMemberCount();

    public abstract double getTypeScale(int var1, NodeColor var2);

    @Override
    public double getDistSQ(Node n) {
        return MolGeom.getDistSq(this.crd, n.getCrd());
    }

    @Override
    public int getMolID() {
        return this.molID;
    }

    @Override
    public void setMolID(int molID) {
        this.molID = molID;
    }

    @Override
    public void setCenteringMember(boolean center) {
        this.centeringMember = center;
    }

    @Override
    public boolean isCenteringMembers() {
        return this.centeringMember;
    }

    public abstract boolean equalsForDisabling(Node var1);

    public void bigAndSoft(boolean b) {
        if (b) {
            this.p /= 10.0;
            this.a /= 10.0;
        } else {
            this.p *= 10.0;
            this.a *= 10.0;
        }
    }
}

