/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import java.util.BitSet;

class MolecularGaussianProduct
extends MolecularGaussian
implements Interaction {
    MolecularGaussian node1;
    MolecularGaussian node2;
    private int memberIndex = 0;
    BitSet members;
    double signedIntegral = 0.0;
    double derivateDivDist = 0.0;
    double dist;
    double mmsign = 1.0;
    double[] typeScales;
    int[] possibleTypes;

    public static MolecularGaussianProduct create(MolecularGaussian g1, MolecularGaussian g2) {
        MolecularGaussianProduct prod;
        if (g1.getMolID() != g2.getMolID()) {
            throw new UnsupportedOperationException();
        }
        BitSet members = new BitSet();
        if (g1 instanceof AtomicGaussian) {
            members.set(g1.getFirstAtomSeq(), true);
        } else {
            prod = (MolecularGaussianProduct)g1;
            members.or(prod.members);
        }
        if (g2 instanceof AtomicGaussian) {
            members.set(g2.getFirstAtomSeq(), true);
        } else {
            prod = (MolecularGaussianProduct)g2;
            members.or(prod.members);
        }
        if (members.cardinality() == 1) {
            return null;
        }
        return new MolecularGaussianProduct(g1, g2, members);
    }

    MolecularGaussianProduct(MolecularGaussian g1, MolecularGaussian g2, BitSet members) {
        super(g1.getMolID());
        this.node1 = g1;
        this.node2 = g2;
        this.members = members;
        this.update();
    }

    @Override
    public double getDistSQ() {
        return this.node1.getDistSQ(this.node2);
    }

    public double sign() {
        double sign = 1.0;
        if ((this.node1.getMemberCount() + this.node2.getMemberCount()) % 2 == 0) {
            sign = -1.0;
        }
        return sign;
    }

    @Override
    public final void update() {
        this.dist = Math.sqrt(MolecularGaussianProduct.productOf(this.node1, this.node2, this));
        double sign = this.sign();
        double x = Math.PI / this.a;
        x = Math.sqrt(x * x * x);
        this.derivateDivDist = -2.0 * (this.node1.a * this.node2.a / this.a) * this.p * x * sign * this.mmsign;
        this.signedIntegral = super.integral() * sign * this.mmsign;
    }

    @Override
    public int getMemberCount() {
        return this.members.cardinality();
    }

    public void setPossibleTypes(int[] possibleTypes) {
        this.possibleTypes = possibleTypes;
    }

    public void setTypeScales(double[] typeScales) {
        this.typeScales = typeScales;
    }

    public void printTypes(NodeColor c) {
        for (int i = 0; i < this.typeScales.length; ++i) {
            System.err.println(c.typeLabel(this.possibleTypes[i]) + " " + this.typeScales[i]);
        }
    }

    @Override
    public double getTypeScale(int type, NodeColor c) {
        for (int i = 0; i < this.possibleTypes.length; ++i) {
            if (!c.isSameType(type, this.possibleTypes[i])) continue;
            return this.typeScales[i];
        }
        throw new UnsupportedOperationException("type scale error");
    }

    @Override
    public String toString() {
        String s = "MolecularGaussianProduct MolID: " + this.molID;
        if (this.members != null) {
            s = s + " members: " + this.members.toString();
        }
        return s;
    }

    @Override
    public boolean equals(Node al) {
        if (!(al instanceof MolecularGaussianProduct)) {
            return false;
        }
        if (al.getMolID() != this.molID) {
            return false;
        }
        MolecularGaussianProduct other = (MolecularGaussianProduct)al;
        return other.members.equals(this.members);
    }

    private int getAtomSeqs() {
        if (this.members == null) {
            return -1;
        }
        while (this.memberIndex < this.members.length()) {
            if (this.members.get(this.memberIndex)) {
                return this.memberIndex++;
            }
            ++this.memberIndex;
        }
        return -1;
    }

    @Override
    public boolean isRealAtom() {
        return false;
    }

    @Override
    public int getFirstAtomSeq() {
        this.memberIndex = 0;
        return this.getAtomSeqs();
    }

    @Override
    public int getNextAtomSeq() {
        return this.getAtomSeqs();
    }

    @Override
    public double getDist() {
        return this.dist;
    }

    @Override
    public double derivateDividedByDist() {
        return this.derivateDivDist;
    }

    @Override
    public double getValue(double rSquare) {
        double sign = 1.0;
        if ((this.node1.getMemberCount() + this.node2.getMemberCount()) % 2 == 0) {
            sign = -1.0;
        }
        return super.getValue(rSquare) * sign;
    }

    @Override
    public double getEnergy() {
        return this.signedIntegral;
    }

    @Override
    public Node getNode1() {
        return this.node1;
    }

    @Override
    public Node getNode2() {
        return this.node2;
    }

    @Override
    public BitSet markAtoms(BitSet b) {
        b.clear();
        b.or(this.members);
        return b;
    }

    @Override
    public boolean hasCommonMember(Node node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public double integral() {
        return this.signedIntegral;
    }

    public void setMmsign(double mmsign) {
        this.mmsign = mmsign;
    }

    @Override
    public void setType(int t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getOriginalAtomType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean equalsForDisabling(Node al) {
        if (!(al instanceof MolecularGaussianProduct)) {
            return false;
        }
        if (al.getMolID() != this.molID) {
            return false;
        }
        MolecularGaussianProduct other = (MolecularGaussianProduct)al;
        BitSet tmp = new BitSet();
        other.markAtoms(tmp);
        tmp.and(this.members);
        return this.members.cardinality() > 0;
    }
}

