/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentBase;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionOneFlexibleMol;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;

class MolecularVolumeGauss
extends AlignmentBase {
    private VolumeQuality quality = VolumeQuality.ACCURATE;
    private VolumeCalculationMode mode = VolumeCalculationMode.AS_IN_INPUT;
    private Molecule molecule;
    private String generate3Dopts = "";
    private double volume = 0.0;
    private int tryCount = 3;
    private double p = 2.7;
    private int acceptNeighbour = 2;
    private int acceptProduct = 2;

    public MolecularVolumeGauss() {
        this.checkLicense();
        this.setProperty(AlignmentProperties.GAUSS_44_SAME);
        this.factory.setAromatize(false);
        this.factory.setDehidrogenize(false);
        this.factory.setCreateRingCenters(false);
    }

    public Molecule getMolecule() {
        if (this.mode == VolumeCalculationMode.AS_IN_INPUT) {
            return this.molecule;
        }
        return this.getMoleculeWithAlignedCoordinates(0);
    }

    public void setMolecule(Molecule molecule) throws AlignmentException {
        this.removeAllMolecules();
        if (molecule.getDim() != 3) {
            molecule.clean(3, this.generate3Dopts);
        }
        this.addMolecule(molecule, true, false);
        this.molecule = ((AlignmentMolecule)this.molecules.get(0)).getAlignedMolecule();
    }

    public VolumeQuality getVolumeQuality() {
        return this.quality;
    }

    public void setAcceptNeighbour(int acceptNeighbour) {
        this.acceptNeighbour = acceptNeighbour;
    }

    public void setAcceptProduct(int acceptProduct) {
        this.acceptProduct = acceptProduct;
    }

    public void setP(double p) {
        this.p = p;
    }

    public void setVolumeCalculationMode(VolumeCalculationMode mode) {
        this.mode = mode;
    }

    double getP() {
        return this.p;
    }

    int getAcceptProduct() {
        return this.acceptProduct;
    }

    int getAcceptNeighbour() {
        return this.acceptNeighbour;
    }

    int getSize() {
        GaussianSum v = (GaussianSum)((AlignmentMolecule)this.molecules.get((int)0)).nodes;
        if (v == null) {
            return 0;
        }
        return v.size();
    }

    public void setGenerate3Dopts(String generate3Dopts) {
        this.generate3Dopts = generate3Dopts;
    }

    public void setVolumeQuality(VolumeQuality quality) {
        this.quality = quality;
        this.factory.setNodeType(quality.getNode());
    }

    public void run() throws AlignmentException {
        AlignmentMolecule am = (AlignmentMolecule)this.molecules.get(0);
        if (this.mode == VolumeCalculationMode.AS_IN_INPUT || am.isRigid()) {
            GaussianSum v = (GaussianSum)((AlignmentMolecule)this.molecules.get((int)0)).nodes;
            v.updateGaussianProducts();
            v.setRingNodeEnabled(false);
            this.volume = v.integral();
            return;
        }
        if (!this.quality.isOptimizable()) {
            throw new AlignmentException("To swell or shrink the molecule select another VolumeQuality.");
        }
        FunctionOneFlexibleMol f = new FunctionOneFlexibleMol((FlexibleMolecule)am, this.stepLimit, this.timeLimit, 0);
        if (this.mode == VolumeCalculationMode.MINIMIZE) {
            f.setExpandVolume(false);
        }
        if (this.mode == VolumeCalculationMode.MAXIMIZE) {
            f.setExpandVolume(true);
        }
        this.function = f;
        if (this.vis != null) {
            this.vis.setShowExtraNodes(true);
            this.vis.init(this.molecules, null);
            f.setVis(this.vis);
        }
        int c = 0;
        this.volume = -1.0;
        double my = 0.0;
        double[][] crdMy = null;
        while (c++ < this.tryCount) {
            this.optimization();
            if (this.mode == VolumeCalculationMode.MAXIMIZE) {
                f.setExpandVolume(false);
            }
            f.update();
            my = ((GaussianSum)am.nodes).integral();
            if (this.mode == VolumeCalculationMode.MAXIMIZE) {
                f.setExpandVolume(true);
            }
            if (this.volume == -1.0) {
                this.volume = my;
                crdMy = MolGeom.arrayCopy(am.getAllCrd());
            }
            if (this.mode == VolumeCalculationMode.MINIMIZE && my < this.volume || this.mode == VolumeCalculationMode.MAXIMIZE && my > this.volume) {
                this.volume = my;
                MolGeom.arrayCopy(am.getAllCrd(), crdMy);
            }
            if (c >= this.tryCount) continue;
            this.randomizeDihedrals();
        }
        am.copyAllCrd(crdMy);
    }

    void calcVolumeGrid() {
        GaussianSum v = (GaussianSum)((AlignmentMolecule)this.molecules.get((int)0)).nodes;
        v.updateGaussianProducts();
        this.molecule.properties().set("VOLUMETRIC_DATA: allVolume", v.volData(-1));
    }

    public double getVolume() {
        return this.volume;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public static enum VolumeQuality {
        FAST(false, AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST),
        FULL_ACCURACY(true, AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FULL),
        ACCURATE(true, AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_44),
        MORE_ACCURATE(true, AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_45);

        private final boolean optimizable;
        private final AlignmentProperties.NodeType node;

        private VolumeQuality(boolean optimizable, AlignmentProperties.NodeType nt) {
            this.optimizable = optimizable;
            this.node = nt;
        }

        public boolean isOptimizable() {
            return this.optimizable;
        }

        public AlignmentProperties.NodeType getNode() {
            return this.node;
        }
    }

    public static enum VolumeCalculationMode {
        AS_IN_INPUT,
        MINIMIZE,
        MAXIMIZE;

    }
}

