/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

class MolecularVolumeGrid {
    private float margin = 2.5f;
    private float bin = 0.01f;
    private Sphere[] sphere;

    public MolecularVolumeGrid(Molecule m) {
        double[][] crd = MolGeom.getCoordniates(m);
        this.sphere = new Sphere[m.getAtomCount()];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            double r = PeriodicSystem.getVanDerWaalsRadius(a.getAtno());
            if ((double)this.margin < r) {
                this.margin = (float)r;
            }
            this.sphere[i] = new Sphere(crd[i], r);
        }
    }

    private double getMinMax(int i, boolean max) {
        double val = Double.NEGATIVE_INFINITY;
        boolean first = true;
        int count = 0;
        for (Sphere s : this.sphere) {
            double c = s.center[i];
            if (first) {
                val = c;
                first = false;
            }
            if (max) {
                if (c > val) {
                    val = c;
                }
            } else if (c < val) {
                val = c;
            }
            ++count;
        }
        return val;
    }

    public double volume() {
        double v = 0.0;
        double[] crdPos = new double[3];
        float[] origo = new float[3];
        origo[0] = (float)(this.getMinMax(0, false) - (double)this.margin);
        double maxX = this.getMinMax(0, true) + (double)this.margin;
        origo[1] = (float)(this.getMinMax(1, false) - (double)this.margin);
        double maxY = this.getMinMax(1, true) + (double)this.margin;
        origo[2] = (float)(this.getMinMax(2, false) - (double)this.margin);
        double maxZ = this.getMinMax(2, true) + (double)this.margin;
        int sizeX = (int)((maxX - (double)origo[0]) / (double)this.bin);
        int sizeY = (int)((maxY - (double)origo[1]) / (double)this.bin);
        int sizeZ = (int)((maxZ - (double)origo[2]) / (double)this.bin);
        int tot = sizeZ * sizeY * sizeX;
        int c = 0;
        for (int ix = 0; ix < sizeX; ++ix) {
            crdPos[0] = origo[0] + (float)ix * this.bin;
            for (int iy = 0; iy < sizeY; ++iy) {
                crdPos[1] = origo[1] + (float)iy * this.bin;
                for (int iz = 0; iz < sizeZ; ++iz) {
                    crdPos[2] = origo[2] + (float)iz * this.bin;
                    v += this.getFunctionValue(crdPos);
                    ++c;
                }
            }
        }
        return v;
    }

    private double getFunctionValue(double[] crdPos) {
        for (Sphere s : this.sphere) {
            if (!s.isIn(crdPos)) continue;
            return this.bin * this.bin * this.bin;
        }
        return 0.0;
    }

    private static class Sphere {
        double[] center;
        double radius;

        public Sphere(double[] center, double radius) {
            this.center = center;
            this.radius = radius;
        }

        public boolean isIn(double[] crdPos) {
            double r = MolGeom.getLength(this.center, crdPos);
            return r < this.radius;
        }
    }
}

