/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.Pharmacophore3D;
import chemaxon.marvin.modelling.mm.Dreiding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public abstract class NodeColor
implements Serializable {
    private List<UserAdded> user;
    private AlignmentProperties.ColorNotSpecifiedCase notSpec = AlignmentProperties.ColorNotSpecifiedCase.ACCEPT_ONLY_SAME;
    private AlignmentProperties.ColoringScheme scheme;
    public static final int SHAPE = Pharmacophore3D.SHAPE;

    private NodeColor(AlignmentProperties.ColoringScheme s) {
        this.scheme = s;
        if (61 >= Pharmacophore3D.AROMATIC_RINGCENTER || 61 >= Pharmacophore3D.ALIPHATIC_RINGCENTER || 61 >= Pharmacophore3D.SHAPE) {
            throw new IllegalStateException("Extended atomtype conflicts with RingCenters or shape types");
        }
    }

    public static NodeColor create(AlignmentProperties.ColoringScheme s) {
        if (s == AlignmentProperties.ColoringScheme.ATOM_TYPES) {
            return new AtomTypeColoring(s);
        }
        if (s == AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES) {
            return new ExtendedAtomColoring(s);
        }
        if (s == AlignmentProperties.ColoringScheme.PHARMACOPHORE) {
            return new PharmacophoreColoring(s);
        }
        if (s == AlignmentProperties.ColoringScheme.SAME) {
            return new SameColoring(s);
        }
        throw new IllegalArgumentException("Invalid ColoringScheme.");
    }

    public AlignmentProperties.ColoringScheme getScheme() {
        return this.scheme;
    }

    int labelWithShape(int type) {
        return type + SHAPE;
    }

    public void addWeight(int type1, int type2, double w) {
        if (this.user == null) {
            this.user = new ArrayList<UserAdded>();
        }
        this.user.add(new UserAdded(type1, type2, w));
    }

    public void setNotSpec(AlignmentProperties.ColorNotSpecifiedCase notSpec) {
        this.notSpec = notSpec;
    }

    public double getWeight(int t1, int t2) throws AlignmentException {
        if (this.notSpec == AlignmentProperties.ColorNotSpecifiedCase.DENY_IF_NOT_SPECIFIED && this.user == null) {
            throw new AlignmentException();
        }
        if (this.notSpec == AlignmentProperties.ColorNotSpecifiedCase.EVERY_WEIGHT_IS_ONE) {
            if (NodeColor.isAliphaticRingCenter(t1) || NodeColor.isAromaticRingCenter(t1)) {
                return 0.0;
            }
            if (NodeColor.isAliphaticRingCenter(t2) || NodeColor.isAromaticRingCenter(t2)) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.user != null) {
            for (UserAdded u : this.user) {
                if (!this.isSameType(u.type1, t1) || !this.isSameType(u.type2, t2)) continue;
                return u.weight;
            }
        }
        if (this.notSpec == AlignmentProperties.ColorNotSpecifiedCase.ACCEPT_ONLY_SAME && this.isSameType(t1, t2)) {
            return 1.0;
        }
        return 0.0;
    }

    abstract BitSet markSingleTypes(BitSet var1, int var2);

    public abstract boolean isSelected(int var1);

    public abstract boolean isSameType(int var1, int var2);

    public abstract String getLabel();

    public boolean isSameTypeOrBothShapeLabelled(int t1, int t2) {
        return this.isSameType(t1, t2) || this.isShapeLabelled(t1) && this.isShapeLabelled(t2);
    }

    public abstract String typeLabel(int var1);

    public boolean isShapeLabelled(int type) {
        int c = type - SHAPE;
        return c >= 0 && c < SHAPE;
    }

    public static boolean isAromaticRingCenter(int type) {
        return type == Pharmacophore3D.AROMATIC_RINGCENTER;
    }

    public static boolean isAliphaticRingCenter(int type) {
        return type == Pharmacophore3D.ALIPHATIC_RINGCENTER;
    }

    public int withoutShapeLabel(int type) {
        if (!this.isShapeLabelled(type)) {
            return type;
        }
        return type - SHAPE;
    }

    public static class SameColoring
    extends NodeColor {
        public SameColoring(AlignmentProperties.ColoringScheme s) {
            super(s);
        }

        @Override
        public boolean isSelected(int t) {
            return this.isShapeLabelled(t) || SameColoring.isAliphaticRingCenter(t) || SameColoring.isAromaticRingCenter(t);
        }

        @Override
        public boolean isSameType(int type1, int type2) {
            if (this.isShapeLabelled(type1)) {
                type1 -= SHAPE;
            }
            if (this.isShapeLabelled(type2)) {
                type2 -= SHAPE;
            }
            return type1 == type2;
        }

        @Override
        BitSet markSingleTypes(BitSet b, int t) {
            if (this.isShapeLabelled(t)) {
                t -= SHAPE;
            }
            b.set(t, true);
            return b;
        }

        @Override
        public String typeLabel(int t) {
            if (SameColoring.isAliphaticRingCenter(t)) {
                return "ALIPHRINGC";
            }
            if (SameColoring.isAromaticRingCenter(t)) {
                return "AROMRINGC";
            }
            int tl = this.withoutShapeLabel(t);
            String s = "T:" + tl;
            if (this.isShapeLabelled(t)) {
                s = s + ";SHAPE";
            }
            return s;
        }

        @Override
        public String getLabel() {
            return "same";
        }
    }

    public static class PharmacophoreColoring
    extends NodeColor {
        public PharmacophoreColoring(AlignmentProperties.ColoringScheme s) {
            super(s);
        }

        @Override
        int labelWithShape(int type) {
            return Pharmacophore3D.labelWithShape(type);
        }

        @Override
        public boolean isShapeLabelled(int type) {
            return Pharmacophore3D.isShape(type);
        }

        @Override
        public int withoutShapeLabel(int type) {
            return Pharmacophore3D.withoutType(type, Pharmacophore3D.SHAPE);
        }

        @Override
        public boolean isSelected(int t) {
            if (t == -1) {
                return false;
            }
            if (this.isShapeLabelled(t) || PharmacophoreColoring.isAliphaticRingCenter(t) || PharmacophoreColoring.isAromaticRingCenter(t)) {
                return true;
            }
            return (t & Pharmacophore3D.DONR) == Pharmacophore3D.DONR || (t & Pharmacophore3D.ACCP) == Pharmacophore3D.ACCP || (t & Pharmacophore3D.POS) == Pharmacophore3D.POS || (t & Pharmacophore3D.NEG) == Pharmacophore3D.NEG || (t & Pharmacophore3D.LP) == Pharmacophore3D.LP;
        }

        @Override
        public boolean isSameType(int type1, int type2) {
            int t2;
            int t1 = Pharmacophore3D.withoutType(type1, Pharmacophore3D.SHAPE);
            return (t1 & (t2 = Pharmacophore3D.withoutType(type2, Pharmacophore3D.SHAPE))) > 0;
        }

        @Override
        BitSet markSingleTypes(BitSet b, int t) {
            t = Pharmacophore3D.withoutType(t, Pharmacophore3D.SHAPE);
            this.mark(Pharmacophore3D.ACCP, t, b);
            this.mark(Pharmacophore3D.AROMATIC_ATOM, t, b);
            this.mark(Pharmacophore3D.DONR, t, b);
            this.mark(Pharmacophore3D.H, t, b);
            this.mark(Pharmacophore3D.HYDR, t, b);
            this.mark(Pharmacophore3D.LP, t, b);
            this.mark(Pharmacophore3D.NEG, t, b);
            this.mark(Pharmacophore3D.POS, t, b);
            return b;
        }

        private void mark(int phtype, int currentType, BitSet b) {
            if ((currentType & phtype) == phtype) {
                b.set(phtype, true);
            }
        }

        @Override
        public String typeLabel(int t) {
            String s = Pharmacophore3D.typeLabel(t);
            if (this.isShapeLabelled(t)) {
                s = s + ";SHAPE";
            }
            return s;
        }

        @Override
        public String getLabel() {
            return "pharmacophore types";
        }
    }

    public static class AtomTypeColoring
    extends NodeColor {
        public AtomTypeColoring(AlignmentProperties.ColoringScheme s) {
            super(s);
        }

        @Override
        public boolean isSelected(int t) {
            if (this.isShapeLabelled(t) || AtomTypeColoring.isAliphaticRingCenter(t) || AtomTypeColoring.isAromaticRingCenter(t)) {
                return true;
            }
            return t == 7 || t == 8 || t == 9 || t == 17 || t == 15 || t == 16;
        }

        @Override
        public boolean isSameType(int type1, int type2) {
            if (this.isShapeLabelled(type1)) {
                type1 -= SHAPE;
            }
            if (this.isShapeLabelled(type2)) {
                type2 -= SHAPE;
            }
            return type1 == type2;
        }

        @Override
        BitSet markSingleTypes(BitSet b, int t) {
            if (this.isShapeLabelled(t)) {
                t -= SHAPE;
            }
            b.set(t, true);
            return b;
        }

        @Override
        public String typeLabel(int t) {
            String s = "";
            switch (t) {
                case 7: {
                    s = "N";
                    break;
                }
                case 8: {
                    s = "O";
                    break;
                }
                case 9: {
                    s = "F";
                    break;
                }
                case 17: {
                    s = "Cl";
                    break;
                }
                case 15: {
                    s = "P";
                    break;
                }
                case 16: {
                    s = "S";
                }
            }
            if (this.isShapeLabelled(t)) {
                s = s + ";SHAPE";
            }
            return s;
        }

        @Override
        public String getLabel() {
            return "atom types";
        }
    }

    public static class ExtendedAtomColoring
    extends NodeColor {
        public static final int OFFSET = 1;

        public ExtendedAtomColoring(AlignmentProperties.ColoringScheme s) {
            super(s);
        }

        @Override
        public boolean isSelected(int t) {
            if (--t == -1) {
                return false;
            }
            if (this.isShapeLabelled(t) || ExtendedAtomColoring.isAliphaticRingCenter(t) || ExtendedAtomColoring.isAromaticRingCenter(t)) {
                return true;
            }
            if (t == 12 || t == 11 || t == 9 || t == 10) {
                return true;
            }
            if (t == 16 || t == 15 || t == 13 || t == 14 || t == 59) {
                return true;
            }
            if (t == 20 || t == 56) {
                return true;
            }
            if (t == 21 || t == 43) {
                return true;
            }
            return t == 17 || t == 22;
        }

        @Override
        public boolean isSameType(int type1, int type2) {
            if (this.isShapeLabelled(type1)) {
                type1 -= SHAPE;
            }
            if (this.isShapeLabelled(type2)) {
                type2 -= SHAPE;
            }
            return type1 == type2;
        }

        int getTypeWithoutShapeLabel(Node n) {
            int ret = n.getType();
            if (this.isShapeLabelled(ret)) {
                ret -= SHAPE;
            }
            return ret;
        }

        @Override
        BitSet markSingleTypes(BitSet b, int t) {
            if (this.isShapeLabelled(t)) {
                t -= SHAPE;
            }
            b.set(t, true);
            return b;
        }

        @Override
        public String typeLabel(int t) {
            if (ExtendedAtomColoring.isAliphaticRingCenter(t)) {
                return "ALIPHRC";
            }
            if (ExtendedAtomColoring.isAromaticRingCenter(t)) {
                return "AROMRC";
            }
            int tl = this.withoutShapeLabel(t);
            if (tl == 0 && this.isShapeLabelled(t)) {
                return "SHAPE";
            }
            String s = Dreiding.getDreidingAtomTypeLabel(--tl);
            s = s.replace("_", "");
            if (this.isShapeLabelled(t)) {
                s = s + ";SHAPE";
            }
            return s;
        }

        @Override
        public String getLabel() {
            return "extended atom types";
        }
    }

    private static class UserAdded {
        int type1;
        int type2;
        double weight;

        UserAdded(int type1, int type2, double weight) {
            this.type1 = type1;
            this.type2 = type2;
            this.weight = weight;
        }
    }
}

