/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

class NodeList<T extends Node>
implements Iterable<T>,
Serializable {
    List<T> sum = new ArrayList<T>();
    BitSet assigned = new BitSet();
    NodeColor color;

    public NodeList(NodeColor nc) {
        this.color = nc;
    }

    Node[] getShapeNodes() {
        int count = 0;
        for (int i = 0; i < this.getRealAtomCount(); ++i) {
            Node n = (Node)this.sum.get(i);
            if (!this.color.isShapeLabelled(n.getType())) continue;
            ++count;
        }
        Node[] selected = new Node[count];
        count = 0;
        for (int i = 0; i < this.getRealAtomCount(); ++i) {
            Node n = (Node)this.sum.get(i);
            if (!this.color.isShapeLabelled(n.getType())) continue;
            selected[count++] = n;
        }
        return selected;
    }

    Node[] getSelectedNodes() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Node n = (Node)this.sum.get(i);
            if (!n.isSelected()) continue;
            ++count;
        }
        Node[] selected = new Node[count];
        count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Node n = (Node)this.sum.get(i);
            if (!n.isSelected()) continue;
            selected[count++] = n;
        }
        return selected;
    }

    public void initSelectionAndTypes() {
    }

    double getMinMax(int i, boolean max, int t) {
        double val = Double.NEGATIVE_INFINITY;
        boolean first = true;
        for (Node a : this.sum) {
            if (a.isRealAtom() && !this.color.isSameType(t, a.getType()) || !a.isRealAtom()) continue;
            double c = a.getCrd()[i];
            if (first) {
                val = c;
                first = false;
            }
            if (max) {
                if (!(c > val)) continue;
                val = c;
                continue;
            }
            if (!(c < val)) continue;
            val = c;
        }
        return val;
    }

    public void setAssigned(int i, boolean b) {
        this.assigned.set(i, b);
    }

    @Override
    public Iterator<T> iterator() {
        return this.sum.iterator();
    }

    public void add(T t) {
        this.sum.add(t);
    }

    public T get(int index) {
        return (T)((Node)this.sum.get(index));
    }

    public int size() {
        return this.sum.size();
    }

    public int getRealAtomCount() {
        return this.size();
    }

    boolean isAssigned(int i) {
        return this.assigned.get(i);
    }

    public void clearAssigned() {
        this.assigned.clear();
    }

    public T get(BitSet b) {
        BitSet tmp = new BitSet();
        for (Node node : this.sum) {
            tmp = node.markAtoms(tmp);
            if (!b.equals(tmp)) continue;
            return (T)node;
        }
        return null;
    }
}

