/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.NoMCSException;
import chemaxon.marvin.alignment.Orientation;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.modules.MCS;

class OrientationByMCS
extends Orientation {
    MCS mcs;
    int seq = 0;
    int tryCountMax = -1;
    int maxMCSSize = -1;
    int maxCount = 0;

    public OrientationByMCS(AlignmentMolecule am1, AlignmentMolecule am2, int minimumCommonSize) throws NoMCSException, AlignmentException {
        super(am1, am2);
        int[] color1 = am1.getTypesAsArray();
        int[] color2 = am2.getTypesAsArray();
        this.mcs = new MCS();
        this.mcs.setMolecules(am1.getMoleculeOrig(), color1, am2.getMoleculeOrig(), color2);
        this.mcs.setAllCS(true);
        this.mcs.setMode(3);
        this.mcs.setDontBreakRingBonds(false);
        this.mcs.setMinimumCommonSize(minimumCommonSize);
        if (!this.mcs.findFirst()) {
            throw new NoMCSException(minimumCommonSize);
        }
        this.maxMCSSize = this.mcs.getCSSize(this.seq);
        while (this.seq != this.tryCountMax && this.seq != this.mcs.getCSCount() && this.maxMCSSize == this.mcs.getCSSize(this.seq)) {
            ++this.seq;
        }
        this.maxCount = this.seq;
        this.seq = 0;
    }

    @Override
    public boolean addConstraints() throws AlignmentException {
        if (this.seq == this.tryCountMax || this.seq == this.mcs.getCSCount() || this.maxMCSSize > this.mcs.getCSSize(this.seq)) {
            return false;
        }
        int[] csMap = this.mcs.getCS(this.seq++);
        int c = 0;
        for (int j = 0; j < csMap.length; ++j) {
            if (csMap[j] == -1) continue;
            if (!this.am1.isAssigned(j) && !this.am2.isAssigned(csMap[j])) {
                this.constr.add(new AlignmentConstraint(this.am1.getAtom(j), this.am2.getAtom(csMap[j]), WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
            ++c;
        }
        return true;
    }

    @Override
    public void reset() {
        this.seq = 0;
    }

    @Override
    public boolean areConstraintsAddable() {
        return true;
    }

    @Override
    public int getOrientationCount() {
        return this.maxCount;
    }
}

