/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.Orientation;
import chemaxon.marvin.alignment.PotentialType;

class OrientationSimple
extends Orientation {
    private int count;
    private Node[] shapeNodes1;
    private Node[] shapeNodes2;

    public OrientationSimple(AlignmentMolecule am1, AlignmentMolecule am2) throws AlignmentException {
        super(am1, am2);
        this.shapeNodes1 = am1.getShapeNodes();
        this.shapeNodes2 = am2.getShapeNodes();
        if (this.shapeNodes1.length > 3 || this.shapeNodes2.length > 3) {
            throw new AlignmentException("Simple orientation is only for or three two selected atoms " + this.shapeNodes1.length + " " + this.shapeNodes2.length);
        }
        if (this.shapeNodes1.length < 1 || this.shapeNodes2.length < 1) {
            throw new AlignmentException("Simple orientation is only for or three two selected atoms " + this.shapeNodes1.length + " " + this.shapeNodes2.length);
        }
        this.count = 0;
    }

    @Override
    public boolean addConstraints() throws AlignmentException {
        int l1 = this.shapeNodes1.length;
        int l2 = this.shapeNodes2.length;
        if (this.count == 0) {
            this.constr.add(new AlignmentConstraint(this.shapeNodes2[0], this.shapeNodes1[0], WEIGHT, 0.0, PotentialType.QUADRATIC));
            if (l1 > 1 && l2 > 1) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[1], this.shapeNodes1[1], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
            if (l1 == 3 && l2 == 3) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[2], this.shapeNodes1[2], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
        } else if (this.count == 1) {
            if (l1 == 1 && l2 == 1) {
                return false;
            }
            if (l1 == 1 && l2 != 1) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[1], this.shapeNodes1[0], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
            if (l1 != 1 && l2 == 1) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes1[1], this.shapeNodes2[0], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
            if (l1 > 1 && l2 > 1) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[0], this.shapeNodes1[1], WEIGHT, 0.0, PotentialType.QUADRATIC));
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[1], this.shapeNodes1[0], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
            if (l1 == 3 && l2 == 3) {
                this.constr.add(new AlignmentConstraint(this.shapeNodes2[2], this.shapeNodes1[2], WEIGHT, 0.0, PotentialType.QUADRATIC));
            }
        } else {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public boolean areConstraintsAddable() {
        return false;
    }

    @Override
    public int getOrientationCount() {
        return 2;
    }
}

