/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.alignment.Alignment;
import chemaxon.marvin.alignment.AlignmentAccuracyMode;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.PairwiseComparison;
import chemaxon.marvin.alignment.Visualizer;
import chemaxon.struc.Molecule;

public class PairwiseAlignment
implements PairwiseComparison {
    private Alignment al;
    private boolean queryRigid = true;
    private boolean targetRigid = false;

    public PairwiseAlignment(AlignmentProperties ap) {
        this.al = new Alignment(ap);
    }

    public PairwiseAlignment() {
        this(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE);
    }

    @Override
    public void addNodeColorWeight(int t1, int t2, double w) {
        this.al.addNodeColorWeight(t1, t2, w);
    }

    @Override
    public void removeAllMolecules() {
        this.al.removeAllMolecules();
        this.al.removeAllConstraints();
    }

    @Override
    public void setQuery(Molecule m) throws AlignmentException {
        AlignmentMolecule am = this.al.factory.generate(0, m, !this.queryRigid, !this.queryRigid);
        this.setQuery(am);
    }

    @Override
    public void setQuery(AlignmentMolecule m) throws AlignmentException {
        System.err.println("queryRigid: " + this.queryRigid);
        if (this.al.molecules.isEmpty()) {
            this.al.addMol(m);
        } else {
            this.al.molecules.set(0, m);
        }
        m.setMolID(0);
        boolean enableTranslateAndRotate = m instanceof FlexibleMolecule && !this.queryRigid;
        m.initVariables(enableTranslateAndRotate);
        if (m instanceof FlexibleMolecule && this.queryRigid) {
            FlexibleMolecule f = (FlexibleMolecule)m;
            f.setRigidMol();
        } else {
            m.createDFIterator();
        }
    }

    public void setMode(AlignmentAccuracyMode mode) {
        this.al.setMode(mode);
    }

    @Override
    public double similarity(Molecule m) throws AlignmentException {
        AlignmentMolecule am = this.al.factory.generate(1, m, true, !this.targetRigid);
        return this.similarity(am);
    }

    @Override
    public double similarity(AlignmentMolecule am) throws AlignmentException {
        am.setMolID(1);
        am.initVariables(true);
        am.createDFIterator();
        if (this.al.molecules.size() != 1 && this.al.molecules.size() != 2) {
            throw new AlignmentException("Size mismatch.");
        }
        if (this.al.molecules.size() == 1) {
            this.al.addMol(am);
        } else {
            this.al.molecules.set(1, am);
        }
        this.al.align();
        return this.al.getVolumeScore();
    }

    @Override
    public void setCount(int count) {
        this.al.setConformerCount(count);
    }

    void setVis(Visualizer vis) {
        this.al.setVis(vis);
    }

    @Override
    public Molecule getAlignedMoleculesAsFragments() {
        return this.al.getAlignedMoleculesAsFragments();
    }

    @Override
    public double getShapeTanimoto() throws AlignmentException {
        return this.al.tanimoto();
    }

    @Override
    public void setProgressBar(AlignmentMoleculeFactory.ProgressBarInterface c) {
    }

    public void setProgressMonitor(MProgressMonitor mp) {
        this.al.setProgressMonitor(mp);
    }

    @Override
    public Molecule getAlignedTarget() {
        return this.al.getMoleculeWithAlignedCoordinates(1);
    }

    @Override
    public Molecule getAlignedQuery() {
        return this.al.getMoleculeWithAlignedCoordinates(0);
    }

    @Override
    public void setQueryRigidForced(boolean forced) {
        this.queryRigid = forced;
    }

    @Override
    public void setTargetRigidForced(boolean targetRigid) {
        this.targetRigid = targetRigid;
    }

    public void setMinimumCommonSize(int mcs) {
        this.al.setMinimumCommonSize(mcs);
    }

    public void setFlexibleRingSize(int s) {
        this.al.setFlexibleRingSize(s);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.al.setLicenseEnvironment(env);
    }
}

