/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.PairwiseComparison;
import chemaxon.marvin.alignment.Similarity3D;
import chemaxon.struc.Molecule;

public class PairwiseSimilarity3D
implements PairwiseComparison {
    private Similarity3D similarity3D;
    private AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
    private boolean queryRigid = true;
    private boolean targetRigid = false;

    public PairwiseSimilarity3D() {
        this.amf.setColor(AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES);
        this.amf.setDehidrogenize(true);
        this.amf.setAromatize(true);
        this.amf.setGenerateDistanceRanges(true);
        this.amf.setNodeType(AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST);
        this.amf.setShape(AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER);
        this.amf.setCreateRingCenters(true);
    }

    @Override
    public void removeAllMolecules() {
        this.similarity3D = null;
    }

    @Override
    public void setQuery(Molecule m) throws AlignmentException {
        AlignmentMolecule q = this.amf.generate(0, m, false, !this.queryRigid);
        this.setQuery(q);
    }

    @Override
    public void setQuery(AlignmentMolecule query) throws AlignmentException {
        this.similarity3D = new Similarity3D(query);
    }

    @Override
    public void setProgressBar(AlignmentMoleculeFactory.ProgressBarInterface bar) {
        this.amf.setProgressBar(bar);
    }

    @Override
    public double similarity(Molecule target) throws AlignmentException {
        AlignmentMolecule tam = this.amf.generate(1, target, true, !this.targetRigid);
        return this.similarity(tam);
    }

    @Override
    public double similarity(AlignmentMolecule target) throws AlignmentException {
        if (this.similarity3D == null) {
            throw new AlignmentException("Add the query first");
        }
        return this.similarity3D.similarity(target);
    }

    @Override
    public Molecule getAlignedMoleculesAsFragments() {
        Molecule ret = null;
        try {
            ret = this.similarity3D.getAlignedMoleculesAsFragments();
        }
        catch (AlignmentException e) {
            throw new UnsupportedOperationException(e);
        }
        return ret;
    }

    @Override
    public Molecule getAlignedTarget() {
        return this.similarity3D.getAlignedTarget();
    }

    @Override
    public Molecule getAlignedQuery() {
        return this.similarity3D.getAlignedQuery();
    }

    @Override
    public void setQueryRigidForced(boolean forced) {
        this.queryRigid = forced;
    }

    @Override
    public void setTargetRigidForced(boolean targetRigid) {
        this.targetRigid = targetRigid;
    }

    @Override
    public void addNodeColorWeight(int t1, int t2, double w) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getShapeTanimoto() throws AlignmentException {
        return this.similarity3D.getBestTanimoto();
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.similarity3D.setLicenseEnvironment(env);
    }

    @Override
    public void setCount(int count) {
        this.similarity3D.setPairResultArraySizeLimit(count);
    }
}

