/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.BowlFunction;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.ProximityPotential;

class ProximityPotentialComplex
implements ProximityPotential {
    BowlFunction b;
    double r0;

    public ProximityPotentialComplex() {
        double weight = 1.0;
        this.b = new BowlFunction(weight, weight * 0.5);
    }

    @Override
    public double functionValue(double x) {
        return this.b.function(x, this.r0, false);
    }

    @Override
    public PotentialType getType() {
        return PotentialType.PROX_COMPLEX;
    }

    @Override
    public double getWeight() {
        return 1.0;
    }

    @Override
    public double getTolerance() {
        return this.r0;
    }

    @Override
    public boolean isOk(double dist) {
        return dist > this.r0;
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        return this.b.functionDeriv(dist, this.r0, false) / dist;
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.r0;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.r0 = radius;
    }
}

