/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.ProximityPotential;

class ProximityPotentialSimple
implements ProximityPotential {
    double r0;
    double w;

    public ProximityPotentialSimple(double w) {
        this.w = w;
    }

    @Override
    public double functionValue(double x) {
        if (x > this.r0) {
            return 0.0;
        }
        double dx = this.r0 - x;
        return dx * dx * dx * this.w;
    }

    private double functionDerivate(double x) {
        if (x > this.r0) {
            return 0.0;
        }
        double dx = this.r0 - x;
        return -3.0 * dx * dx * this.w;
    }

    @Override
    public PotentialType getType() {
        return PotentialType.PROX_SIMPLE;
    }

    @Override
    public double getWeight() {
        return this.w;
    }

    @Override
    public double getTolerance() {
        return this.r0;
    }

    @Override
    public boolean isOk(double x) {
        return x > this.r0;
    }

    @Override
    public double functionDerivateDividedByDist(double x) {
        if (x < 1.0E-6) {
            throw new UnsupportedOperationException("Distance too small.");
        }
        return this.functionDerivate(x) / x;
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.r0;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.r0 = radius;
    }
}

