/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.StatusMol;
import java.io.Serializable;
import java.util.ArrayList;

public class Status
implements Serializable {
    private double volumeScore;
    private double constraintScore;
    private int stepCount;
    private long time;
    private boolean converged = true;
    private boolean timeLimeitReached = false;
    private boolean stepLimeitReached = false;
    private ArrayList<StatusMol> mols;

    protected Status clone() {
        Status ret = new Status();
        ret.volumeScore = this.volumeScore;
        ret.constraintScore = this.constraintScore;
        ret.stepCount = this.stepCount;
        ret.time = this.time;
        ret.converged = this.converged;
        ret.timeLimeitReached = this.timeLimeitReached;
        ret.stepLimeitReached = this.stepLimeitReached;
        if (this.mols != null) {
            ret.mols = new ArrayList();
            for (StatusMol statusMol : this.mols) {
                ret.mols.add(statusMol.clone());
            }
        }
        return ret;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getConstraintScore() {
        return this.constraintScore;
    }

    public void setConstraintScore(double rmsdScore) {
        this.constraintScore = rmsdScore;
    }

    public double getVolumeScore() {
        return this.volumeScore;
    }

    public void setVolumeScore(double volumeScore) {
        this.volumeScore = volumeScore;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public void setConverged(boolean converged) {
        this.converged = converged;
    }

    public boolean isStepLimeitReached() {
        return this.stepLimeitReached;
    }

    public void setStepLimitReached(boolean stepLimeitReached) {
        this.stepLimeitReached = stepLimeitReached;
    }

    public boolean isTimeLimeitReached() {
        return this.timeLimeitReached;
    }

    public void setTimeLimitReached(boolean timeLimeitReached) {
        this.timeLimeitReached = timeLimeitReached;
    }

    public StatusMol getStatusMol(int i) {
        return this.mols.get(i);
    }

    public void addStatusMol(StatusMol st) {
        if (this.mols == null) {
            this.mols = new ArrayList();
        }
        this.mols.add(st);
    }

    public String toString() {
        String s = "StepCount: " + this.stepCount + " \nConverged: " + this.converged + "\nStepLimitReached: " + this.stepLimeitReached;
        s = s + "\nTimeLimitReached:" + this.timeLimeitReached + "\nVolumeScore: " + this.volumeScore + "\nRmsdScore: " + this.constraintScore + " \n";
        for (StatusMol r : this.mols) {
            s = s + r.toString() + "\n";
        }
        return s;
    }
}

