/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.VolumeOverlapConstraint;
import chemaxon.marvin.alignment.VolumeOverlapGrid;

class TanimotoGrid
extends VolumeOverlapGrid {
    private VolumeOverlapGrid vg1;
    private VolumeOverlapGrid vg2;

    TanimotoGrid(AlignmentMolecule am1, AlignmentMolecule am2) throws AlignmentException {
        super(am1, am2);
        this.vg1 = new VolumeOverlapGrid(am1, am1);
        this.vg2 = new VolumeOverlapGrid(am2, am2);
        this.vg1.update();
        this.vg2.update();
        this.update();
    }

    @Override
    double value(double[] crd, int i1, int i2) throws AlignmentException {
        double f = 0.0;
        double w = this.col.getWeight(i1, i2);
        if (w > 0.0) {
            double x = 0.0;
            for (VolumeOverlapConstraint vc : this.atomicOverlaps) {
                vc.calcTypeScale(i1, i2, this.am1.getColors());
                vc.setCurrentColorWeight(w);
                x += vc.getValue(crd);
            }
            for (VolumeOverlapConstraint vc : this.productOverlaps) {
                vc.calcTypeScale(i1, i2, this.am1.getColors());
                vc.setCurrentColorWeight(w);
                x += vc.getValue(crd);
            }
            f = x / (this.vg1.value(crd, i1, i2) + this.vg2.value(crd, i1, i2) - x);
            f *= (double)this.scaleVis;
        }
        return f;
    }
}

