/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.DegreeOfFeedom;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.VolumeOverlapConstraint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class VolumeOverlap {
    AlignmentMolecule am1;
    AlignmentMolecule am2;
    GaussianSum sum1;
    GaussianSum sum2;
    List<VolumeOverlapConstraint> atomicOverlaps;
    List<VolumeOverlapConstraint> productOverlaps;
    List<VolumeOverlapConstraint> selectedNodeOverlaps;
    int[] t1;
    int[] t2;
    NodeColor col;
    private MODE mode = MODE.FULL;

    VolumeOverlap(AlignmentMolecule am1, AlignmentMolecule am2) throws AlignmentException {
        VolumeOverlapConstraint vc;
        double w;
        MolecularGaussian a2;
        int i;
        MolecularGaussian a1;
        int j;
        this.am1 = am1;
        this.am2 = am2;
        this.sum1 = (GaussianSum)am1.nodes;
        this.sum2 = (GaussianSum)am2.nodes;
        if (am1.getColoringScheme() != am2.getColoringScheme()) {
            throw new UnsupportedOperationException("Coloring scheme mismatch");
        }
        this.col = am1.getColors();
        this.atomicOverlaps = new ArrayList<VolumeOverlapConstraint>();
        this.productOverlaps = new ArrayList<VolumeOverlapConstraint>();
        this.selectedNodeOverlaps = new ArrayList<VolumeOverlapConstraint>();
        for (j = 0; j < this.sum1.size() - this.sum1.getMulticenterNodeCount(); ++j) {
            a1 = (MolecularGaussian)this.sum1.get(j);
            if (a1 instanceof AtomicGaussian && am1.isAssigned(j)) continue;
            for (i = 0; i < this.sum2.size() - this.sum2.getMulticenterNodeCount(); ++i) {
                a2 = (MolecularGaussian)this.sum2.get(i);
                if (a2 instanceof AtomicGaussian && am2.isAssigned(i)) continue;
                if (a1 instanceof AtomicGaussian && a2 instanceof AtomicGaussian) {
                    w = this.col.getWeight(a1.getType(), a2.getType());
                    if (!(w > 0.0)) continue;
                    vc = new VolumeOverlapConstraint(a1, a2);
                    vc.setCurrentColorWeight(w);
                    vc.calcTypeScale(a1.getType(), a2.getType(), this.col);
                    if (a1.isSelected() && a2.isSelected()) {
                        this.selectedNodeOverlaps.add(vc);
                    }
                    this.atomicOverlaps.add(vc);
                    continue;
                }
                this.productOverlaps.add(new VolumeOverlapConstraint(a1, a2));
            }
        }
        for (j = this.sum1.size() - this.sum1.getMulticenterNodeCount(); j < this.sum1.size(); ++j) {
            a1 = (MultiCenterGaussian)this.sum1.get(j);
            for (i = this.sum2.size() - this.sum2.getMulticenterNodeCount(); i < this.sum2.size(); ++i) {
                a2 = (MultiCenterGaussian)this.sum2.get(i);
                w = this.col.getWeight(((MultiCenterGaussian)a1).getType(), ((MultiCenterGaussian)a2).getType());
                if (!(w > 0.0)) continue;
                vc = new VolumeOverlapConstraint(a1, a2);
                vc.setCurrentColorWeight(w);
                vc.calcTypeScale(((MultiCenterGaussian)a1).getType(), ((MultiCenterGaussian)a2).getType(), this.col);
                this.selectedNodeOverlaps.add(vc);
            }
        }
        this.t1 = this.sum1.getDifferentTypes();
        this.t2 = this.sum2.getDifferentTypes();
    }

    public void setMode(MODE mode) {
        this.mode = mode;
        if (mode == MODE.SELECTED) {
            if (!this.am1.isRigid()) {
                ((FlexibleMolecule)this.am1).setSelectedMode(true);
            }
            if (!this.am2.isRigid()) {
                ((FlexibleMolecule)this.am2).setSelectedMode(true);
            }
        } else {
            if (!this.am1.isRigid()) {
                ((FlexibleMolecule)this.am1).setSelectedMode(false);
            }
            if (!this.am2.isRigid()) {
                ((FlexibleMolecule)this.am2).setSelectedMode(false);
            }
        }
    }

    public MODE getMode() {
        return this.mode;
    }

    private void update(List<VolumeOverlapConstraint> v) {
        for (int i = 0; i < v.size(); ++i) {
            VolumeOverlapConstraint vc = v.get(i);
            vc.update();
        }
    }

    public void update() throws AlignmentException {
        if (this.mode == MODE.SELECTED) {
            this.update(this.selectedNodeOverlaps);
            return;
        }
        this.update(this.atomicOverlaps);
        if (this.mode == MODE.ATOMIC) {
            return;
        }
        if (this.mode == MODE.FULL) {
            this.update(this.productOverlaps);
            return;
        }
    }

    private double overlap(int t1, int t2, List<VolumeOverlapConstraint> v) {
        double f = 0.0;
        for (int k = 0; k < v.size(); ++k) {
            VolumeOverlapConstraint vc = v.get(k);
            if (vc.isDisabled()) continue;
            vc.calcTypeScale(t1, t2, this.col);
            f += vc.getEnergy();
        }
        return f;
    }

    public double getWeightedOverlap() throws AlignmentException {
        double weightedOverlapSum = 0.0;
        if (this.mode == MODE.SELECTED) {
            for (VolumeOverlapConstraint vc : this.selectedNodeOverlaps) {
                if (vc.isDisabled()) continue;
                weightedOverlapSum += vc.getEnergy();
            }
            return weightedOverlapSum;
        }
        for (VolumeOverlapConstraint vc : this.atomicOverlaps) {
            if (vc.isDisabled()) continue;
            weightedOverlapSum += vc.getEnergy();
        }
        if (this.mode == MODE.ATOMIC) {
            return weightedOverlapSum;
        }
        for (int i = 0; i < this.t1.length; ++i) {
            for (int j = 0; j < this.t2.length; ++j) {
                double w = this.col.getWeight(this.t1[i], this.t2[j]);
                if (w == 0.0) continue;
                double ww = this.overlap(this.t1[i], this.t2[j], this.productOverlaps) * w;
                weightedOverlapSum += ww;
            }
        }
        return weightedOverlapSum;
    }

    void disableConstraints(List<AlignmentConstraint> constr) {
        for (AlignmentConstraint a : constr) {
            for (VolumeOverlapConstraint at : this.atomicOverlaps) {
                at.setDisabled(a);
            }
            for (VolumeOverlapConstraint p : this.productOverlaps) {
                p.setDisabled(a);
            }
        }
    }

    public void enableAll() {
        for (VolumeOverlapConstraint at : this.atomicOverlaps) {
            at.setDisabled(false);
        }
        for (VolumeOverlapConstraint p : this.productOverlaps) {
            p.setDisabled(false);
        }
    }

    private double[] calcOverlapDerivate(DegreeOfFeedom df, double[] gradient, List<VolumeOverlapConstraint> g, int t1, int t2, double w) throws AlignmentException {
        for (int k = 0; k < g.size(); ++k) {
            VolumeOverlapConstraint vc = g.get(k);
            if (vc.isDisabled()) continue;
            vc.calcTypeScale(t1, t2, this.col);
            vc.setCurrentColorWeight(w);
            gradient = df.gradient(gradient, vc);
        }
        return gradient;
    }

    private double[] calcOverlapDerivate(DegreeOfFeedom df, double[] gradient) throws AlignmentException {
        if (!df.isEnabled()) {
            return gradient;
        }
        if (this.mode == MODE.SELECTED) {
            for (int k = 0; k < this.selectedNodeOverlaps.size(); ++k) {
                VolumeOverlapConstraint vc = this.selectedNodeOverlaps.get(k);
                if (vc.isDisabled()) continue;
                gradient = df.gradient(gradient, vc);
            }
            return gradient;
        }
        for (int k = 0; k < this.atomicOverlaps.size(); ++k) {
            VolumeOverlapConstraint vc = this.atomicOverlaps.get(k);
            if (vc.isDisabled()) continue;
            gradient = df.gradient(gradient, vc);
        }
        if (this.mode == MODE.ATOMIC) {
            return gradient;
        }
        for (int i = 0; i < this.t1.length; ++i) {
            for (int j = 0; j < this.t2.length; ++j) {
                double w = this.col.getWeight(this.t1[i], this.t2[j]);
                if (w == 0.0) continue;
                gradient = this.calcOverlapDerivate(df, gradient, this.productOverlaps, this.t1[i], this.t2[j], w);
            }
        }
        return gradient;
    }

    public double[] gradient(double[] gradient) throws AlignmentException {
        this.am1.iteratorPos = 0;
        Iterator<DegreeOfFeedom> df1 = this.am1.getDfIterator();
        while (df1.hasNext()) {
            DegreeOfFeedom df = df1.next();
            gradient = this.calcOverlapDerivate(df, gradient);
        }
        this.am2.iteratorPos = 0;
        Iterator<DegreeOfFeedom> df2 = this.am2.getDfIterator();
        while (df2.hasNext()) {
            DegreeOfFeedom df = df2.next();
            gradient = this.calcOverlapDerivate(df, gradient);
        }
        return gradient;
    }

    public static enum MODE {
        SELECTED,
        ATOMIC,
        FULL;

    }
}

